/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryplugincommon.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryplugincommon.RepositoryPluginCommonErrors;
import com.ibm.cognos.cm.repositoryplugincommon.io.PropertyReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class MetadataDescriptorReader {
    private static final int PROPERTY_READERS_INITIAL_CAP = 4;
    private final SAXReader saxReader;
    private final ConcurrentHashMap<String, PropertyReader> propertyReaders;

    public MetadataDescriptorReader() {
        this(new SAXReader());
    }

    MetadataDescriptorReader(SAXReader saxReader) {
        this.saxReader = saxReader;
        this.propertyReaders = new ConcurrentHashMap(4);
    }

    public void registerPropertyReader(String propertyName, PropertyReader propertyReader) {
        if (propertyReader != null) {
            this.propertyReaders.put(propertyName, propertyReader);
        }
    }

    public HashMap<String, String> readMetadata(File metadataFile) throws RepositoryException {
        try {
            Document doc = this.loadDocument(metadataFile);
            return this.buildMetadata(doc.getRootElement());
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.failedToReadAndParseFile);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadDocument(File file) throws DocumentException, FileNotFoundException, IOException {
        Document doc = null;
        InputStream is = null;
        try {
            is = file.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            doc = this.saxReader.read(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return doc;
    }

    HashMap<String, String> buildMetadata(Element rootElement) {
        HashMap<String, String> metadataHashMap = new HashMap<String, String>();
        List elements = rootElement.elements();
        for (Element element : elements) {
            String nodeName = element.getName();
            if (nodeName == null) continue;
            if (this.propertyReaders.containsKey(nodeName)) {
                String value = this.propertyReaders.get(nodeName).getPropertyValue((Node)element);
                if (value == null) continue;
                metadataHashMap.put(nodeName, value);
                continue;
            }
            metadataHashMap.put(nodeName, element.getStringValue());
        }
        return metadataHashMap;
    }
}

