/*************************************************************************************************************************************************************
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * IBM Cognos Products: Cognos Analytics
 *
 * (C) Copyright IBM Corp. 2019
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office.
 *************************************************************************************************************************************************************/

package com.ibm.bi.rest.bridge.exception;

/**
 * Base class for all unchecked exceptions thrown in restBridgeService.
 */
public class RestBridgeRuntimeException extends RuntimeException {
	private static final long serialVersionUID = 1L;

	public RestBridgeRuntimeException() {
		super();
	}

	public RestBridgeRuntimeException(String msg, Throwable rootCause) {
		super(rootCause instanceof RestBridgeRuntimeException ? msg + "\n" + rootCause.getMessage() : msg, rootCause);
	}

	public RestBridgeRuntimeException(String msg, RestBridgeRuntimeException e) {
		super(msg + "\n" + e.getMessage(), e);
	}

	public RestBridgeRuntimeException(String msg) {
		super(msg);
	}

	public RestBridgeRuntimeException(Throwable rootCause) {
		super(rootCause);
	}
}
