/*************************************************************************************************************************************************************
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * IBM Cognos Products: Cognos Analytics
 *
 * (C) Copyright IBM Corp. 2019
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office.
 *************************************************************************************************************************************************************/

package com.ibm.bi.rest.bridge.methods;

import javax.servlet.http.HttpServletRequest;

import org.apache.log.Logger;
import org.dom4j.Element;

import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.bi.rest.bridge.config.RestBridgeConfiguration;

/**
 * An abstract base class for the restBridgeService methods.
 */
public abstract class BaseMethod implements IServiceMethod {

	private final Logger logger;
	
	protected final HttpServletRequest httpServletRequest;
	protected final RestBridgeConfiguration bridgeConfig;
	protected final AsyncContext asyncContext;

	protected final MessageContext messageContext;
	protected final BIBusEnvelope requestEnvelope;
	
	// Method element from the BI Bus request. For example: <run>
	protected final Element methodElement;

	public BaseMethod(Logger logger, HttpServletRequest httpServletRequest, RestBridgeConfiguration bridgeConfig, AsyncContext asyncContext, Element methodElement) {
		this.logger = logger;
		logMethodCall("BaseMethod constructor");
		
		this.httpServletRequest = httpServletRequest;
		this.bridgeConfig = bridgeConfig;
		this.asyncContext = asyncContext;
		this.methodElement = methodElement;
		
		this.messageContext = asyncContext.getMessageContext();
		this.requestEnvelope = (BIBusEnvelope) this.messageContext.getProperty("request.envelope");
	}

	protected void logMethodCall(String methodName) {
		if (logger.isDebugEnabled()) {
			logger.debug("Calling " + methodName);
		}
	}
}
