/*************************************************************************************************************************************************************
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * IBM Cognos Products: Cognos Analytics
 *
 * (C) Copyright IBM Corp. 2019
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office.
 *************************************************************************************************************************************************************/

package com.ibm.bi.rest.bridge.methods;

import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.bi.rest.bridge.service.RestBridgeAsyncService;

/**
 * An interface for the classes that implement restBridgeService methods,
 * such as <run>, <runSpecification>, etc.
 */
public interface IServiceMethod {

	/**
	 * Execute the service method to completion.
	 */
	public void execute();
	
	/**
	 * Cancel the running service method.
	 */
	public void cancel();

	/**
	 * @see RestBridgeAsyncService#workingImpl(MessageContext, AsyncContext)
	 */
	public void workingImpl(MessageContext mc, AsyncContext ac);

	/**
	 * @see RestBridgeAsyncService#responseReadyImpl(MessageContext, AsyncContext)
	 */
	public void responseReadyImpl(MessageContext mc, AsyncContext ac);
}
