/*************************************************************************************************************************************************************
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * IBM Cognos Products: Cognos Analytics
 *
 * (C) Copyright IBM Corp. 2019
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office.
 *************************************************************************************************************************************************************/

package com.ibm.bi.rest.bridge.methods;

import javax.servlet.http.HttpServletRequest;

import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.bi.rest.bridge.config.RestBridgeConfiguration;
import com.ibm.bi.rest.bridge.exception.RestBridgeRuntimeException;
import com.ibm.bi.rest.bridge.utils.SoapRequestHelper;

public class MethodFactory {

	private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(MethodFactory.class.getName());

	// hide constructor
	private MethodFactory() {
	}

	/**
	 * Returns a method handler for the incoming BI Bus request.
	 * 
	 * @param httpServletRequest
	 *            incoming servlet request
	 *
	 * @param bridgeConfig
	 *            RestBridgeService configuration
	 *
	 * @param asyncContext
	 *            the context of an ongoing async conversation
	 *
	 * @return a {@link IServiceMethod} instance.
	 */
	public static IServiceMethod getMethodHandler(HttpServletRequest httpServletRequest, RestBridgeConfiguration bridgeConfig, AsyncContext asyncContext) {
		if (logger.isDebugEnabled()) {
			logger.debug("Calling getMethodHandler");
		}

		BIBusEnvelope requestEnvelope = (BIBusEnvelope) asyncContext.getMessageContext().getProperty("request.envelope");
		Element methodElement = SoapRequestHelper.getMethod(requestEnvelope);
		String methodName = methodElement.getName();
		
		if (methodName.equals("run")) {
			return new RunMethod(httpServletRequest, bridgeConfig, asyncContext, methodElement);
		}

		String msg = "restBridgeService does not support BI Bus method: " + methodName;
		logger.error(msg);
		throw new RestBridgeRuntimeException(msg);
	}
}
