/*************************************************************************************************************************************************************
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * IBM Cognos Products: Cognos Analytics
 *
 * (C) Copyright IBM Corp. 2019
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office.
 *************************************************************************************************************************************************************/

package com.ibm.bi.rest.bridge.service;

import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.bi.rest.RESTClientFactory;

/**
 * This class is the main entry point to the restBridgeService.
 *
 * RestBridgeHandler is registered with CA Dispatcher via Service XML file:
 *
 * webapps/p2pd/WEB-INF/services/restBridgeService.xml
 *
 * For more details on how services tie into dispatcher, see this wiki page:
 * https://w3-connections.ibm.com/wikis/home?lang=en-us#!/wiki/CognosDispatcher/page/Tie%20into%20Dispatcher%20from%20archive
 *
 */
public final class RestBridgeHandler extends BasicHandler implements Asyncable {

	private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(RestBridgeHandler.class.getName());

	public RestBridgeHandler() {
		super(logger);
		logMethodCall("RestBridgeHandler constructor");
	}

	/**
	 * @see com.cognos.pogo.pdk.Handler#initialize()
	 */
	@Override
	public void initialize() {
		logMethodCall("initialize");
		RESTClientFactory.getInstance().startup("restBridgeService", LaxRedirectStrategy.INSTANCE);
	}

	/**
	 * @see com.cognos.pogo.pdk.Handler#dispose()
	 */
	@Override
	public void dispose() {
		logMethodCall("dispose");
		RESTClientFactory.getInstance().shutdown();
	}

	/**
	 * Returns an instance of RestBridgeAsyncService. This is a signal to Dispatcher
	 * to execute the request in a separate async thread.
	 * 
	 * @param mc		Message context.
	 * @return An instance of RestBridgeAsyncService
	 * 
	 * @see Asyncable#getAsyncRequest
	 */
	public AsyncService getAsyncRequest(MessageContext mc) {
		logMethodCall("getAsyncRequest(MessageContext)");
		return new RestBridgeAsyncService(mc);
	}

	/**
	 * Process synchronous request.
	 *
	 * @param mc		Message context
	 *
	 * @see BasicHandler#invokeImpl
	 */
	@Override
	public void invokeImpl(MessageContext mc) throws PogoException {
		logMethodCall("invokeImpl(MessageContext)");
		// not expected to be called; do nothing
	}
	
	private void logMethodCall(String methodName) {
		if (logger.isDebugEnabled()) {
			logger.debug("Calling " + methodName);
		}
	}
}
