/*************************************************************************************************************************************************************
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * IBM Cognos Products: Cognos Analytics
 *
 * (C) Copyright IBM Corp. 2019
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office.
 *************************************************************************************************************************************************************/

package com.ibm.bi.rest.bridge.utils;

import java.net.HttpCookie;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;

import org.apache.log.Hierarchy;
import org.apache.log.Logger;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.bi.platform.commons.shared.CAConstants;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;

/**
 * A builder class for RESTClient.
 */
public class RESTClientBuilder {

	private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(RESTClientBuilder.class.getName());

	/**
	 * Create a RESTClient instance that can be used to call /bi/v1/* endpoints.
	 *
	 * @param httpServletRequest
	 *            the incoming servlet request
	 *
	 * @param requestEnvelope
	 *            BI Bus request envelope
	 *
	 */
	public static RESTClient createClient(HttpServletRequest httpServletRequest, BIBusEnvelope requestEnvelope) {
		logger.debug("Calling createClient(HttpServletRequest, BIBusEnvelope)");

		RESTClientConfig rcc = new RESTClientConfig(httpServletRequest);

		// The incoming SOAP request is expected to be authenticated.
		// Copy "cam_passport" and "usersessionid" from the SOAP cookies.
		rcc.setPassportCookie(requestEnvelope.getCookieValue(CAConstants.CAM_PASSPORT_COOKIE_NAME));
		rcc.setCookie(new HttpCookie(CAConstants.USERSESSIONID_COOKIE_NAME, requestEnvelope.getCookieValue(CAConstants.USERSESSIONID_COOKIE_NAME)));

		rcc.setRequestHeader(HttpHeaders.ACCEPT, MediaType.APPLICATION_JSON);
		rcc.setRequestHeader(HttpHeaders.CACHE_CONTROL, "no-cache, no-store");

		return RESTClientFactory.getInstance().getClient(rcc);
	}
}
