/*************************************************************************************************************************************************************
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * IBM Cognos Products: Cognos Analytics
 *
 * (C) Copyright IBM Corp. 2019
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office.
 *************************************************************************************************************************************************************/

package com.ibm.bi.rest.bridge.utils;

import java.util.Iterator;

import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.bi.rest.bridge.exception.RestBridgeRuntimeException;

/**
 * Convenience methods for extracting details from a SOAP request DOM.
 */
public class SoapRequestHelper {

	private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(SoapRequestHelper.class.getName());
	
	/**
	 * Return DOM element that represents a SOAP method, such as <run>,
	 * <runSpecification>, etc.
	 *
	 * @param requestEnvelope
	 *            The incoming BI Bus request envelope.
	 */
	public static Element getMethod(BIBusEnvelope requestEnvelope) {
		logger.debug("Calling getMethodElement(BIBusEnvelope)");

		Element requestBody = requestEnvelope.getBody();
		Iterator<?> bodyElements = requestBody.elementIterator();
		if (!bodyElements.hasNext()) {
			String msg = "Empty SOAP request body";
			logger.error(msg);
			throw new RestBridgeRuntimeException(msg);
		}

		// The first child of the SOAP body is the method to be executed,
		// such as <run>, <runSpecification>, etc.
		Element methodElement = (Element) bodyElements.next();

		if (logger.isDebugEnabled()) {
			logger.debug("methodElement: " + methodElement.asXML());
		}

		return methodElement;
	}
	
	/**
	 * Extract object path from a SOAP method element.
	 */
	public static String getObjectPath(Element methodElement) {
		logger.debug("Calling getObjectPath(Element)");

		if (methodElement == null) {
			throw new IllegalArgumentException("methodElement is null");
		}

		Element objectPath  = methodElement.element("objectPath");
		if (objectPath == null) {
			throw new IllegalArgumentException("methodElement.objectPath is null");
		}

		String result = objectPath.getText();
		if (result == null || result.isEmpty()) {
			throw new RestBridgeRuntimeException("objectPath is null or empty");
		}

		if (logger.isDebugEnabled()) {
			logger.debug("Returning objectPath: " + result);
		}

		return result;
	}

	// It's okay to leave this method unimplemented for now, because the incoming requests
	// to run scheduled notebooks don't specify the threshold options.
	public static int getAsyncOptionInt(Element methodElement, String optionName) {
		logger.debug("Calling getAsyncOptionInt(Element, String)");

		// TODO: extract named option from the methodElement, such as this one:

		/*
			<run>
				<options xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="bus:option[2]">
					<item xsi:type="bus:asynchOptionInt">
						<name xsi:type="bus:asynchOptionEnum">primaryWaitThreshold</name>
						<value xsi:type="xsd:int">0</value>
					</item>
					<item xsi:type="bus:pagingOptionInt">
						<name xsi:type="bus:pagingOptionEnum">maximumObjects</name>
						<value xsi:type="xsd:int">2000</value>
					</item>
				</options>
			</run>
		 */

		return -1;
	}

}
