/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.conn.bapi;

public final class JBapiConstants {

    public static final class SAPCompTypes {
        public static final int QCT_ALL = 0;
        public static final int QCT_NIL = 1;
        public static final int QCT_REP = 2;
        public static final int QCT_SEL = 3;
        public static final int QCT_FML = 4;
        public static final int QCT_VAR = 5;
        public static final int QCT_STR = 6;
        public static final int QCT_CKF = 7;
        public static final int QCT_RKF = 8;
        public static final int QCT_FLT = 9;
        public static final int QCT_NUL = 10;
        public static final int QCT_SOB = 11;
        public static final int QCT_CHA = 12;
        public static final int QCT_SHT = 13;
        public static final int QCT_STM = 14;
        public static final int QCT_EXC = 15;
        public static final int QCT_CON = 16;
        public static final int QCT_CEL = 17;

        public static int getCompID(String compType) {
            if (compType.length() == 0) {
                return 10;
            }
            if (compType.equals("SEL")) {
                return 3;
            }
            if (compType.equals("STM")) {
                return 14;
            }
            if (compType.equals("SOB")) {
                return 11;
            }
            if (compType.equals("CHA")) {
                return 12;
            }
            if (compType.equals("SHT")) {
                return 13;
            }
            if (compType.equals("STR")) {
                return 6;
            }
            if (compType.equals("FML")) {
                return 4;
            }
            if (compType.equals("VAR")) {
                return 5;
            }
            if (compType.equals("REP")) {
                return 2;
            }
            if (compType.equals("CKF")) {
                return 7;
            }
            if (compType.equals("NIL")) {
                return 1;
            }
            if (compType.equals("RKF")) {
                return 8;
            }
            if (compType.equals("EXC")) {
                return 15;
            }
            if (compType.equals("CON")) {
                return 16;
            }
            if (compType.equals("CEL")) {
                return 17;
            }
            if (compType.equals("FTL")) {
                return 9;
            }
            if (compType.equals("NUL")) {
                return 10;
            }
            if (compType.equals("*")) {
                return 0;
            }
            return 10;
        }
    }

    public static final class SAPDisplayModes {
        public static final int OM_OPEN = 0;
        public static final int OM_SAVE = 1;
        public static final int OM_PUBLISH = 2;
        public static final int OM_DELETE = 3;
    }

    public static final class SAPSelect {
        public static final int SIGN_INCL = 0;
        public static final int SIGN_EXCL = 1;
        public static final int SEL_EQ = 0;
        public static final int SEL_NE = 1;
        public static final int SEL_BT = 2;
        public static final int SEL_NB = 3;
        public static final int SEL_LE = 4;
        public static final int SEL_GT = 5;
        public static final int SEL_GE = 6;
        public static final int SEL_LT = 7;
        public static final int SEL_CP = 8;
        public static final int SEL_NP = 9;
    }

    public static final class SAPObjViews {
        public static final int OV_HISTORY = 0;
        public static final int OV_FAVORITES = 1;
        public static final int OV_ROLES = 2;
        public static final int OV_FOLDERS = 3;
        public static final int OV_PROPERTIES = 4;
        public static final int OV_SEARCH = 5;
    }

    public static final class SAPObjTypes {
        public static final int OT_INFOAREA = 0;
        public static final int OT_INFOCUBE = 1;
        public static final int OT_INFOPROVIDER = 2;
        public static final int OT_QUERY = 3;
        public static final int OT_VIEW_3X = 4;
        public static final int OT_VIEW_QV = 5;
        public static final int OT_VIEW = 6;
        public static final int IOBJ_UNKNOWN = 0;
        public static final int IOBJ_CHA = 1;
        public static final int IOBJ_KYF = 2;
        public static final int IOBJ_TIM = 3;
        public static final int IOBJ_DPA = 4;
        public static final int IOBJ_UNI = 5;
        public static final int IOBJ_MTA = 6;
        public static final int KYF_UNKNOWN = 0;
        public static final int KYF_AMO = 1;
        public static final int KYF_QUA = 2;
        public static final int KYF_NUM = 3;
        public static final int KYF_INT = 4;
        public static final int KYF_FLO = 5;
        public static final int KYF_DAT = 6;
        public static final int KYF_TIM = 7;
    }

    public static final class SAPRfcTypes {
        public static final String RFCTYPE_CHAR = "Char";
        public static final String RFCTYPE_DATE = "Date";
        public static final String RFCTYPE_BCD = "PackedNumber";
        public static final String RFCTYPE_TIME = "Time";
        public static final String RFCTYPE_BYTE = "Raw";
        public static final String RFCTYPE_TABLE = "Table";
        public static final String RFCTYPE_NUM = "NumChar";
        public static final String RFCTYPE_FLOAT = "Float";
        public static final String RFCTYPE_INT = "Int32";
        public static final String RFCTYPE_ABAPOBJ = "ABAP";
        public static final String RFCTYPE_STRUCTURE = "Structure";
        public static final String RFCTYPE_DECF16 = "DecFloat16";
        public static final String RFCTYPE_DECF34 = "DecFloat34";
        public static final String RFCTYPE_STRING = "String";
        public static final String RFCTYPE_XSTRING = "XString";
        public static final String RFCTYPE_INT8 = "Int64";
        public static final String RFCTYPE_UNKNOWN = "Unknown";

        public static String getTypeDesc(int nType) {
            switch (nType) {
                case 0: {
                    return RFCTYPE_CHAR;
                }
                case 1: {
                    return RFCTYPE_DATE;
                }
                case 2: {
                    return RFCTYPE_BCD;
                }
                case 3: {
                    return RFCTYPE_TIME;
                }
                case 4: {
                    return RFCTYPE_BYTE;
                }
                case 5: {
                    return RFCTYPE_TABLE;
                }
                case 6: {
                    return RFCTYPE_NUM;
                }
                case 7: {
                    return RFCTYPE_FLOAT;
                }
                case 8: {
                    return RFCTYPE_INT;
                }
                case 16: {
                    return RFCTYPE_ABAPOBJ;
                }
                case 17: {
                    return RFCTYPE_STRUCTURE;
                }
                case 23: {
                    return RFCTYPE_DECF16;
                }
                case 24: {
                    return RFCTYPE_DECF34;
                }
                case 29: {
                    return RFCTYPE_STRING;
                }
                case 30: {
                    return RFCTYPE_XSTRING;
                }
                case 31: {
                    return RFCTYPE_INT8;
                }
            }
            return RFCTYPE_UNKNOWN;
        }
    }

    public static final class SAPABAPTypes {
        public static final String ATYPE_C = "Character string";
        public static final String ATYPE_N = "Digits only string";
        public static final String ATYPE_D = "Date: YYYYMMDD";
        public static final String ATYPE_T = "Time: HHMMSS";
        public static final String ATYPE_X = "Byte sequence (heXadecimal)";
        public static final String ATYPE_I = "Signed 4-byte integer";
        public static final String ATYPE_b = "1-byte integer";
        public static final String ATYPE_s = "2-byte integer";
        public static final String ATYPE_P = "Packed Number";
        public static final String ATYPE_F = "8-byte Floating pointer number";
        public static final String ATYPE_g = "Character string with var.len.";
        public static final String ATYPE_y = "Byte sequence with var.len.";
        public static final String ATYPE_u = "Structured type, flat";
        public static final String ATYPE_v = "Structured type, deep";
        public static final String ATYPE_h = "Table type";
        public static final String ATYPE_V = "Character string (VARC)";
        public static final String ATYPE_r = "Reference to class/interface";
        public static final String ATYPE_l = "Reference to data object";

        public static String getTypeDesc(String typeID) {
            if (typeID == null || typeID.length() == 0) {
                return typeID;
            }
            switch (typeID.charAt(0)) {
                case 'C': {
                    return ATYPE_C;
                }
                case 'N': {
                    return ATYPE_N;
                }
                case 'D': {
                    return ATYPE_D;
                }
                case 'T': {
                    return ATYPE_T;
                }
                case 'X': {
                    return ATYPE_X;
                }
                case 'I': {
                    return ATYPE_I;
                }
                case 'b': {
                    return ATYPE_b;
                }
                case 's': {
                    return ATYPE_s;
                }
                case 'P': {
                    return ATYPE_P;
                }
                case 'F': {
                    return ATYPE_F;
                }
                case 'g': {
                    return ATYPE_g;
                }
                case 'y': {
                    return ATYPE_y;
                }
                case 'u': {
                    return ATYPE_u;
                }
                case 'v': {
                    return ATYPE_v;
                }
                case 'h': {
                    return ATYPE_h;
                }
                case 'V': {
                    return ATYPE_V;
                }
                case 'r': {
                    return ATYPE_r;
                }
                case 'l': {
                    return ATYPE_l;
                }
            }
            return typeID;
        }
    }
}

