/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.conn.bapi;

import com.cognos.xqe.conn.bapi.JBapiConnect;
import com.cognos.xqe.conn.bapi.JBapiException;

public abstract class JBapiContainer {
    private static final long serialVersionUID = 1006L;
    private static final String SIGN_INCLUDE = "Include";
    private static final String SIGN_EXCLUDE = "Exclude";
    private static final String OPTION_EQ = "Equal";
    private static final String OPTION_NE = "Not Equal";
    private static final String OPTION_BT = "Between";
    private static final String OPTION_NB = "Not Between";
    private static final String OPTION_LE = "Less or Equal";
    private static final String OPTION_GT = "Greater Than";
    private static final String OPTION_GE = "Greater or Equal";
    private static final String OPTION_LT = "Less Than";
    private static final String OPTION_CP = "Contains Pattern";
    private static final String OPTION_NP = "Not Contains Pattern";
    protected static final int FCTCON_UNKNOWN = 0;
    protected static final int FCTCON_BWINT = 1;
    protected static final int FCTCON_CURUNI = 2;
    protected static final int FCTCON_ETL = 3;
    protected static final int FCTCON_MDX = 4;
    protected static final int FCTCON_META = 5;
    protected static final int FCTCON_TM1 = 6;
    protected static final int FCTCON_TOOLS = 7;
    protected static final int FCTCON_USER = 8;
    protected static final int FCTCON_BROWSER = 9;
    protected int mIType = 0;
    protected long mHCont = 0L;
    protected long mHCnct = 0L;

    abstract boolean assignConnection(JBapiConnect var1);

    protected final void initContainer(JBapiConnect connect, boolean bUnique) {
        this.mHCnct = connect.getHandle();
        try {
            this.mHCont = JBapiContainer.CBContainerInit(this.mIType, this.mHCnct, bUnique);
        }
        catch (JBapiException e) {
            throw new JBapiException("Init container error: " + e.getMessage());
        }
    }

    public final boolean releaseContainer() {
        boolean bResult;
        try {
            bResult = JBapiContainer.CBContainerRelease(this.mHCont);
        }
        catch (JBapiException e) {
            throw new JBapiException("Release container error: " + e.getMessage());
        }
        return bResult;
    }

    public final long getConnectionHandle() {
        return this.mHCnct;
    }

    public final long getContainerHandle() {
        return this.mHCont;
    }

    public final String getCubeUndecorated(String cube) {
        try {
            return JBapiContainer.CBContainerGetCubeUndecorated(this.mHCont, cube);
        }
        catch (JBapiException e) {
            throw new JBapiException("GetCubeUndecorated error: " + e.getMessage());
        }
    }

    public final String getDimUndecorated(String cube, boolean asAttrib) {
        try {
            return JBapiContainer.CBContainerGetDimUndecorated(this.mHCont, cube, asAttrib);
        }
        catch (JBapiException e) {
            throw new JBapiException("GetDimUndecorated error: " + e.getMessage());
        }
    }

    public final String formatTimeStamp(String timeStamp) {
        StringBuffer fmStr = new StringBuffer();
        if (timeStamp.length() < 14) {
            fmStr.setLength(0);
            return fmStr.toString();
        }
        fmStr.append(timeStamp.substring(0, 4));
        fmStr.append("-");
        fmStr.append(timeStamp.substring(4, 6));
        fmStr.append("-");
        fmStr.append(timeStamp.substring(6, 8));
        fmStr.append(", ");
        fmStr.append(timeStamp.substring(8, 10));
        fmStr.append(":");
        fmStr.append(timeStamp.substring(10, 12));
        fmStr.append(":");
        fmStr.append(timeStamp.substring(12, 14));
        return fmStr.toString();
    }

    public final int enableAutoClear(boolean useAutoClear) {
        try {
            return JBapiContainer.CBContainerEnableAutoClear(this.mHCont, useAutoClear);
        }
        catch (JBapiException e) {
            throw new JBapiException("enableAutoClear: " + e.getMessage());
        }
    }

    public final int enableBasXML(boolean useBasXML) {
        try {
            return JBapiContainer.CBContainerEnableBASXML(this.mHCont, useBasXML);
        }
        catch (JBapiException e) {
            throw new JBapiException("enableBasXML: " + e.getMessage());
        }
    }

    public final int enableABAPExceptions(boolean enableABAPEx) {
        try {
            return JBapiContainer.CBContainerEnableABAPExcept(this.mHCont, enableABAPEx);
        }
        catch (JBapiException e) {
            throw new JBapiException("enableABAPExceptions: " + e.getMessage());
        }
    }

    public static final String getSignDesc(String value) {
        if (value.equalsIgnoreCase("I")) {
            return SIGN_INCLUDE;
        }
        if (value.equalsIgnoreCase("E")) {
            return SIGN_EXCLUDE;
        }
        return value;
    }

    public static final String getOptionDesc(String value) {
        if (value.equalsIgnoreCase("EQ")) {
            return OPTION_EQ;
        }
        if (value.equalsIgnoreCase("NE")) {
            return OPTION_NE;
        }
        if (value.equalsIgnoreCase("BT")) {
            return OPTION_BT;
        }
        if (value.equalsIgnoreCase("NB")) {
            return OPTION_NB;
        }
        if (value.equalsIgnoreCase("LE")) {
            return OPTION_LE;
        }
        if (value.equalsIgnoreCase("GT")) {
            return OPTION_GT;
        }
        if (value.equalsIgnoreCase("GE")) {
            return OPTION_GE;
        }
        if (value.equalsIgnoreCase("LT")) {
            return OPTION_LT;
        }
        if (value.equalsIgnoreCase("CP")) {
            return OPTION_CP;
        }
        if (value.equalsIgnoreCase("NP")) {
            return OPTION_NP;
        }
        return value;
    }

    private static native long CBContainerInit(int var0, long var1, boolean var3) throws JBapiException;

    private static native boolean CBContainerRelease(long var0) throws JBapiException;

    private static native String CBContainerGetCubeUndecorated(long var0, String var2) throws JBapiException;

    private static native String CBContainerGetDimUndecorated(long var0, String var2, boolean var3) throws JBapiException;

    private static native int CBContainerEnableBASXML(long var0, boolean var2) throws JBapiException;

    private static native int CBContainerEnableAutoClear(long var0, boolean var2) throws JBapiException;

    private static native int CBContainerEnableABAPExcept(long var0, boolean var2) throws JBapiException;
}

