/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.conn.bapi;

public class JBapiException
extends RuntimeException {
    private static final long serialVersionUID = 1007L;
    public static final int ERROR_LOGON_FAILURE = 104;
    private static final long ABAPEXCODELOW = 3L;
    private static final long ABAPEXCODEHIGH = 5L;
    private boolean mIsSAP;
    private int mRC = 0;
    private int mGroup = 0;
    private String mKey = null;
    private String mRFCMessage = null;
    private String mABAPMessage = null;

    public JBapiException(String pMessage) {
        super(pMessage);
        this.mIsSAP = false;
    }

    public JBapiException(int rc, int group, String key, String message, String abapmsg) {
        super(message + " - ABAP: " + abapmsg);
        this.mRC = rc;
        this.mGroup = group;
        this.mKey = key;
        this.mRFCMessage = message;
        this.mABAPMessage = abapmsg;
        this.mIsSAP = true;
    }

    public final boolean isSAPException() {
        return this.mIsSAP;
    }

    public final boolean isABAPException() {
        if (!this.mIsSAP) {
            return false;
        }
        return (long)this.mRC >= 3L && (long)this.mRC <= 5L;
    }

    public final int getRFCReturnCode() {
        return this.mRC;
    }

    public final int getErrorGroup() {
        return this.mGroup;
    }

    public final String getErrorKey() {
        return this.mKey;
    }

    public final String getRFCMessage() {
        return this.mRFCMessage;
    }

    public final String getABAPMessage() {
        return this.mABAPMessage;
    }
}

