/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.conn.bapi;

import com.cognos.xqe.conn.bapi.JBapiConnect;
import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiParamDesc;
import com.cognos.xqe.conn.bapi.JBapiRfcErrorInfo;
import com.cognos.xqe.conn.bapi.JBapiStructure;
import com.cognos.xqe.conn.bapi.JBapiTable;
import java.util.TreeMap;

public class JBapiFunction {
    private static final long serialVersionUID = 1008L;
    private static final Object LOCK = new Object();
    private String mFuncName = "";
    private long mHFunc = 0L;
    private int mParamCnt = 0;
    private int mStructCnt = 0;
    private int mTableCnt = 0;
    private TreeMap<String, JBapiTable> mTableMap = null;
    private TreeMap<String, JBapiStructure> mStructureMap = null;
    private JBapiConnect mConnect = null;
    private JBapiRfcErrorInfo mErrorInfo = null;

    public JBapiFunction() {
    }

    public JBapiFunction(String funcName, JBapiConnect connect) throws JBapiException {
        this.initFunction(funcName, connect);
    }

    public void initFunction(String funcName, JBapiConnect connect) throws JBapiException {
        this.mFuncName = funcName;
        this.mConnect = connect;
        try {
            this.assignFunction(JBapiFunction.CBFunctionInit(this.mFuncName, connect.getHandle()));
        }
        catch (JBapiException e) {
            throw new JBapiException("Init function error: " + e.getMessage());
        }
        catch (Exception ee) {
            throw new JBapiException("My Error: " + ee.getMessage());
        }
    }

    public void assignFunction(long hFunction) throws JBapiException {
        int[] funcCnts = new int[3];
        int n = 0;
        JBapiTable[] tables = null;
        JBapiStructure[] structs = null;
        if (this.mHFunc != 0L) {
            throw new JBapiException("Function handle already assigned!");
        }
        try {
            if (this.mHFunc == 0L) {
                this.mHFunc = hFunction;
                if (this.mFuncName.length() == 0) {
                    this.mFuncName = JBapiFunction.CBFunctionGetName(this.mHFunc);
                }
                funcCnts = JBapiFunction.CBFunctionPSTCount(this.mHFunc);
                this.mParamCnt = funcCnts[0];
                this.mStructCnt = funcCnts[1];
                this.mTableCnt = funcCnts[2];
                if (this.mTableCnt > 0 && this.mTableMap == null) {
                    tables = (JBapiTable[])JBapiFunction.CBFunctionGetTables(this.mHFunc);
                    if (tables != null) {
                        this.mTableMap = new TreeMap();
                    }
                    for (n = 0; n < tables.length; ++n) {
                        this.mTableMap.put(tables[n].getTableName(), tables[n]);
                    }
                }
                if (this.mStructCnt > 0 && this.mStructureMap == null) {
                    structs = (JBapiStructure[])JBapiFunction.CBFunctionGetStructs(this.mHFunc);
                    if (structs != null) {
                        this.mStructureMap = new TreeMap();
                    }
                    for (n = 0; n < structs.length; ++n) {
                        this.mStructureMap.put(structs[n].getStructureName(), structs[n]);
                    }
                }
            }
        }
        catch (JBapiException e) {
            throw new JBapiException("Init function error: " + e.getMessage());
        }
    }

    public boolean check() {
        return this.mHFunc != 0L;
    }

    public int getNumParams() {
        try {
            return JBapiFunction.CBFunctionParamCount(this.mHFunc);
        }
        catch (JBapiException e) {
            throw new JBapiException("numberOfParams: " + e.getMessage());
        }
    }

    public JBapiParamDesc getParamDesc(int index, JBapiParamDesc desc) {
        JBapiParamDesc pDesc = null;
        try {
            if (desc != null) {
                JBapiFunction.CBFunctionParamDesc(this.mHFunc, index, desc);
                return desc;
            }
            pDesc = new JBapiParamDesc();
            JBapiFunction.CBFunctionParamDesc(this.mHFunc, index, pDesc);
        }
        catch (JBapiException e) {
            throw new JBapiException("getParamDesc: " + e.getMessage());
        }
        return pDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseFunction() {
        int nResult = 0;
        try {
            Object object = LOCK;
            synchronized (object) {
                nResult = JBapiFunction.CBFunctionRelease(this.mHFunc);
            }
        }
        catch (JBapiException e) {
            throw new JBapiException("releaseFunction: " + e.getMessage());
        }
        return nResult == 0;
    }

    public JBapiConnect getConnection() {
        return this.mConnect;
    }

    public int setConnection(JBapiConnect connect) {
        try {
            return JBapiFunction.CBFunctionSetConnect(this.mHFunc, connect.getHandle());
        }
        catch (JBapiException e) {
            throw new JBapiException("setConnection: " + e.getMessage());
        }
    }

    public void logFunctionDesc() throws JBapiException {
        try {
            JBapiFunction.CBFunctionWriteDescLog(this.mHFunc);
        }
        catch (JBapiException e) {
            throw new JBapiException("logFunctionDesc: " + e.getMessage());
        }
    }

    public boolean exportFunctionDesc(String fileName, boolean bOverWrite, boolean bResolve) {
        try {
            return JBapiFunction.CBFunctionWriteDescFile(this.mHFunc, fileName, bOverWrite, 0, bResolve);
        }
        catch (JBapiException e) {
            throw new JBapiException("exportFunctionDesc: " + e.getMessage());
        }
    }

    public void execute(int runMode, boolean throwABAP) throws JBapiException {
        JBapiFunction.CBFunctionInvoke(this.mHFunc, runMode, throwABAP);
    }

    public int cancel(boolean bForced) throws JBapiException {
        try {
            return JBapiFunction.CBFunctionCancel(this.mHFunc, bForced);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFunctionState: " + e.getMessage());
        }
    }

    public int getFunctionState() throws JBapiException {
        return JBapiFunction.CBFunctionGetState(this.mHFunc);
    }

    public int getParamsCount() {
        return this.mParamCnt;
    }

    public int getStructuresCount() {
        return this.mStructCnt;
    }

    public JBapiStructure getStructure(String name) {
        try {
            JBapiStructure ret = this.mStructureMap.get(name);
            if (ret != null) {
                ret.getHandle(false, true);
            }
            return ret;
        }
        catch (Exception e) {
            throw new JBapiException("Requested structure '" + name + "' is not available!");
        }
    }

    public JBapiStructure getStructureDirect(String name) throws JBapiException {
        long pHandle = JBapiFunction.CBFunctionStructHandle(this.mHFunc, name);
        if (pHandle == 0L) {
            return null;
        }
        return new JBapiStructure(pHandle, name);
    }

    public int getTablesCount() {
        return this.mTableCnt;
    }

    public int cleanupTables() throws JBapiException {
        return JBapiFunction.CBFunctionCleanupTables(this.mHFunc);
    }

    public JBapiTable getTable(String name) throws JBapiException {
        try {
            return this.mTableMap.get(name);
        }
        catch (Exception e) {
            throw new JBapiException("Requested table '" + name + "' is not available!");
        }
    }

    public JBapiTable getTableDirect(String name) throws JBapiException {
        long pHandle = JBapiFunction.CBFunctionTableHandle(this.mHFunc, name);
        if (pHandle == 0L) {
            return null;
        }
        return new JBapiTable(pHandle, name);
    }

    public double getRFCRuntime() throws JBapiException {
        return JBapiFunction.CBFunctionGetRuntime(this.mHFunc);
    }

    public double getRFCInittime() throws JBapiException {
        return JBapiFunction.CBFunctionGetInittime(this.mHFunc);
    }

    public void setIntParam(String paramName, int paramValue) throws JBapiException {
        JBapiFunction.CBFunctionSetIntParam(this.mHFunc, paramName, paramValue);
    }

    public void setParam(String paramName, String paramValue) throws JBapiException {
        JBapiFunction.CBFunctionSetParam(this.mHFunc, paramName, paramValue);
    }

    public int setParamDirect(String paramName, char[] value, int valueSz) throws JBapiException {
        return JBapiFunction.CBFunctionSetParamDirect(this.mHFunc, paramName, value, valueSz);
    }

    public String getFunctionName() {
        return this.mFuncName;
    }

    public JBapiRfcErrorInfo getErrorInfo() {
        if (this.mErrorInfo == null) {
            this.mErrorInfo = new JBapiRfcErrorInfo();
            try {
                JBapiFunction.CBFunctionGetErrorInfo(this.mHFunc, this.mErrorInfo);
            }
            catch (JBapiException e) {
                throw new JBapiException("getErrorInfo: " + e.getMessage());
            }
        }
        return this.mErrorInfo;
    }

    public int getIntParam(String paramName) throws JBapiException {
        return JBapiFunction.CBFunctionGetIntParam(this.mHFunc, paramName);
    }

    public String getParam(String paramName) throws JBapiException {
        return JBapiFunction.CBFunctionGetParam(this.mHFunc, paramName);
    }

    public char[] getParamX(String paramName) throws JBapiException {
        return JBapiFunction.CBFunctionGetParamX(this.mHFunc, paramName, 0);
    }

    public int getParamDirect(String paramName, char[] dest, int destSz) throws JBapiException {
        if (destSz <= dest.length) {
            return JBapiFunction.CBFunctionGetParamDirect(this.mHFunc, paramName, dest, destSz);
        }
        return JBapiFunction.CBFunctionGetParamDirect(this.mHFunc, paramName, dest, dest.length);
    }

    public int getParamLen(String paramName) throws JBapiException {
        return JBapiFunction.CBFunctionGetParamLenX(this.mHFunc, paramName);
    }

    public void releaseParamArray(char[] buffer) throws JBapiException {
        JBapiFunction.CBFunctionParamXDispose(this.mHFunc, buffer);
    }

    public int saveParamState(String fileName, int nMode) throws JBapiException {
        return JBapiFunction.CBFunctionSaveState(this.mHFunc, fileName, nMode);
    }

    public int loadParamState(String fileName, int nMode) throws JBapiException {
        return JBapiFunction.CBFunctionLoadState(this.mHFunc, fileName, nMode);
    }

    private static native long CBFunctionInit(String var0, long var1) throws JBapiException;

    private static native int CBFunctionSetConnect(long var0, long var2) throws JBapiException;

    private static native int CBFunctionRelease(long var0) throws JBapiException;

    private static native int CBFunctionParamCount(long var0) throws JBapiException;

    private static native int CBFunctionParamDesc(long var0, int var2, JBapiParamDesc var3) throws JBapiException;

    private static native void CBFunctionWriteDescLog(long var0) throws JBapiException;

    private static native boolean CBFunctionWriteDescFile(long var0, String var2, boolean var3, int var4, boolean var5) throws JBapiException;

    private static native void CBFunctionInvoke(long var0, int var2, boolean var3) throws JBapiException;

    private static native int CBFunctionCancel(long var0, boolean var2) throws JBapiException;

    private static native int CBFunctionGetState(long var0) throws JBapiException;

    private static native int[] CBFunctionPSTCount(long var0) throws JBapiException;

    private static native void CBFunctionSetParam(long var0, String var2, String var3) throws JBapiException;

    private static native int CBFunctionSetParamDirect(long var0, String var2, char[] var3, int var4) throws JBapiException;

    private static native void CBFunctionSetIntParam(long var0, String var2, int var3) throws JBapiException;

    private static native String CBFunctionGetName(long var0) throws JBapiException;

    private static native String CBFunctionGetParam(long var0, String var2) throws JBapiException;

    private static native char[] CBFunctionGetParamX(long var0, String var2, int var3) throws JBapiException;

    private static native void CBFunctionParamXDispose(long var0, char[] var2) throws JBapiException;

    private static native int CBFunctionGetParamLenX(long var0, String var2) throws JBapiException;

    private static native int CBFunctionGetParamDirect(long var0, String var2, char[] var3, int var4) throws JBapiException;

    private static native int CBFunctionGetIntParam(long var0, String var2) throws JBapiException;

    private static native double CBFunctionGetRuntime(long var0) throws JBapiException;

    private static native double CBFunctionGetInittime(long var0) throws JBapiException;

    private static native Object[] CBFunctionGetTables(long var0) throws JBapiException;

    private static native long CBFunctionTableHandle(long var0, String var2) throws JBapiException;

    private static native int CBFunctionCleanupTables(long var0) throws JBapiException;

    private static native Object[] CBFunctionGetStructs(long var0) throws JBapiException;

    private static native long CBFunctionStructHandle(long var0, String var2) throws JBapiException;

    private static native int CBFunctionGetErrorInfo(long var0, JBapiRfcErrorInfo var2) throws JBapiException;

    private static native int CBFunctionSaveState(long var0, String var2, int var3) throws JBapiException;

    private static native int CBFunctionLoadState(long var0, String var2, int var3) throws JBapiException;
}

