/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.conn.bapi;

import com.cognos.xqe.conn.bapi.JBapiConnect;
import com.cognos.xqe.conn.bapi.JBapiException;

public class JBapiIntNW {
    private static final long serialVersionUID = 1009L;
    private static final String LIB_SAPNWJNI = "sapnwjni";
    private static final String LIB_NWRFC = "sapnwrfc";
    private static final String LIB_ICUUC = "icuuc50";
    private static final String LIB_ICUDT = "icudt50";
    private static final String LIB_ICUIN = "icuin50";
    private static final String LIB_UNIX_NWBAP = "libsapnwjni.so";
    private static final String LIB_UNIX_NWRFC = "libsapnwrfc.so";
    private static final String LIBNATIVE_WIN_NWBAP = "sapnwjni.dll";
    private static final String LIBNATIVE_WIN_NWRFC = "sapnwrfc.dll";
    private static final String LIBNATIVE_WIN_ICUUC = "icuuc50.dll";
    private static final String LIBNATIVE_WIN_ICUDT = "icudt50.dll";
    private static final String LIBNATIVE_WIN_ICUIN = "icuin50.dll";
    private static final String LIBNATIVE_WIN_CUDEC = "libicudecnumber.dll";
    private static final String LIBNATIVE_WIN_SAPUC = "libsapucum.dll";
    private static final String LIBNATIVE_LUX_ICUUC = "libicuuc.so.50";
    private static final String LIBNATIVE_LUX_ICUDT = "libicudata.so.50";
    private static final String LIBNATIVE_LUX_ICUIN = "libicui18n.so.50";
    private static final String LIBNATIVE_LUX_CUDEC = "libicudecnumber.so";
    private static final String LIBNATIVE_LUX_SAPUC = "libsapucum.so";
    private static final String LIBNATIVE_AIX_ICUUC = "libicuuc50.a";
    private static final String LIBNATIVE_AIX_ICUDT = "libicudata50.a";
    private static final String LIBNATIVE_AIX_ICUIN = "libicui18n50.a";
    private static final String LIBNATIVE_AIX_CUDEC = "libicudecnumber.so";
    private static final String LIBNATIVE_AIX_SAPUC = "libsapucum.so";
    public static final int BL_OFF = 0;
    public static final int BL_FATAL = 1;
    public static final int BL_ERROR = 2;
    public static final int BL_WARN = 3;
    public static final int BL_INFO = 4;
    public static final int BL_DEBUG = 5;
    public static final int BL_ALL = 6;
    private static boolean bInit = false;
    private static boolean bPreRFCLoading = false;
    private static int bRefPathLen = 0;

    public JBapiIntNW(boolean bRFCLoad, String cfgPath) {
        bPreRFCLoading = bRFCLoad;
        JBapiIntNW.init(null, cfgPath);
    }

    public JBapiIntNW(String nativeLibPath, String cfgPath) {
        JBapiIntNW.init(nativeLibPath, cfgPath);
    }

    private static synchronized void init(String nativeLibPath, String cfgPath) {
        if (bInit) {
            return;
        }
        boolean isSun = false;
        try {
            String osname = System.getProperty("os.name").toLowerCase();
            if (JBapiIntNW.isOSsunos(osname)) {
                isSun = true;
            }
            if (nativeLibPath != null) {
                StringBuffer fullFileName = new StringBuffer(256);
                fullFileName.setLength(0);
                if (nativeLibPath.length() > 0) {
                    fullFileName.append(nativeLibPath);
                    fullFileName.append(System.getProperty("file.separator"));
                    bRefPathLen = fullFileName.length();
                }
                if (JBapiIntNW.isOSwindows(osname)) {
                    JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_WIN_ICUDT);
                    JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_WIN_ICUUC);
                    JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_WIN_ICUIN);
                    JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_WIN_NWRFC);
                    JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_WIN_NWBAP);
                } else {
                    if (JBapiIntNW.isOSlinux(osname) || JBapiIntNW.isOSsunos(osname) || JBapiIntNW.isOSzos(osname)) {
                        JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_LUX_ICUDT);
                        JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_LUX_ICUUC);
                        JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_LUX_ICUIN);
                    } else if (JBapiIntNW.isOSaix(osname)) {
                        JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_AIX_ICUDT);
                        JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_AIX_ICUUC);
                        JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_AIX_ICUIN);
                    } else {
                        throw new Exception("OS not supported: " + osname);
                    }
                    JBapiIntNW.loadNativeLib(fullFileName, LIB_UNIX_NWRFC);
                    JBapiIntNW.loadNativeLib(fullFileName, LIB_UNIX_NWBAP);
                }
            } else if (JBapiIntNW.isOSwindows(osname)) {
                System.loadLibrary(LIBNATIVE_WIN_ICUDT);
                System.loadLibrary(LIBNATIVE_WIN_ICUUC);
                System.loadLibrary(LIBNATIVE_WIN_ICUIN);
                System.loadLibrary(LIBNATIVE_WIN_NWRFC);
                System.loadLibrary(LIBNATIVE_WIN_NWBAP);
            } else {
                if (JBapiIntNW.isOSlinux(osname) || JBapiIntNW.isOSsunos(osname) || JBapiIntNW.isOSzos(osname)) {
                    System.loadLibrary(LIBNATIVE_LUX_ICUDT);
                    System.loadLibrary(LIBNATIVE_LUX_ICUUC);
                    System.loadLibrary(LIBNATIVE_LUX_ICUIN);
                } else if (JBapiIntNW.isOSaix(osname)) {
                    System.loadLibrary(LIBNATIVE_AIX_ICUDT);
                    System.loadLibrary(LIBNATIVE_AIX_ICUUC);
                    System.loadLibrary(LIBNATIVE_AIX_ICUIN);
                } else {
                    throw new Exception("OS not supported: " + osname);
                }
                System.loadLibrary(LIB_UNIX_NWRFC);
                System.loadLibrary(LIB_UNIX_NWBAP);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            if (nativeLibPath == null && isSun) {
                try {
                    StringBuffer fullFileName = new StringBuffer(256);
                    fullFileName.setLength(0);
                    fullFileName.append(System.getProperty("user.dir"));
                    fullFileName.append(System.getProperty("file.separator"));
                    fullFileName.append("../bin64/");
                    bRefPathLen = fullFileName.length();
                    JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_LUX_ICUDT);
                    JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_LUX_ICUUC);
                    JBapiIntNW.loadNativeLib(fullFileName, LIBNATIVE_LUX_ICUIN);
                    JBapiIntNW.loadNativeLib(fullFileName, LIB_UNIX_NWRFC);
                    JBapiIntNW.loadNativeLib(fullFileName, LIB_UNIX_NWBAP);
                }
                catch (UnsatisfiedLinkError ue) {
                    throw new JBapiException("SAPNWJNI library not Found: " + ule.getLocalizedMessage() + " " + ue.getLocalizedMessage());
                }
                catch (SecurityException se) {
                    throw new JBapiException("SAPNWJNI library not Found: " + ule.getLocalizedMessage() + " " + se.getLocalizedMessage());
                }
                catch (Exception e) {
                    throw new JBapiException("SAPNWJNI library not Found: " + ule.getLocalizedMessage());
                }
            }
            throw new JBapiException("SAPNWJNI library not Found: " + ule.getLocalizedMessage());
        }
        catch (SecurityException se) {
            throw new JBapiException("SAPNWJNI library failed to load: " + se.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new JBapiException("Unknown error while loading SAPNWJNI library: " + e.getLocalizedMessage());
        }
        try {
            if (JBapiIntNW.CBInit(true, null) == 0) {
                bInit = true;
            }
        }
        catch (Exception e) {
            throw new JBapiException("Initialization error occured: " + e.getLocalizedMessage());
        }
    }

    public static final boolean isInitialized() {
        return bInit;
    }

    private static final void loadNativeLib(StringBuffer pathRef, String libName) {
        pathRef.setLength(bRefPathLen);
        pathRef.append(libName);
        System.load(pathRef.toString());
    }

    private static final boolean isOSwindows(String osname) {
        return osname.indexOf("win") >= 0;
    }

    private static final boolean isOSlinux(String osname) {
        return osname.indexOf("linux") >= 0;
    }

    private static final boolean isOSaix(String osname) {
        return osname.indexOf("aix") >= 0;
    }

    private static final boolean isOSsunos(String osname) {
        return osname.indexOf("sunos") >= 0;
    }

    private static final boolean isOSzos(String osname) {
        return osname.indexOf("zos") >= 0;
    }

    public static final void writeBAPILog(int logLvl, String msgLine1, String msgLine2) {
        try {
            JBapiIntNW.CBWriteBAPILog(logLvl, msgLine1, msgLine2);
        }
        catch (Exception e) {
            return;
        }
    }

    public static final void setBAPILogLevel(int logLvl) {
        try {
            JBapiIntNW.CBSetBAPILogLevel(logLvl);
        }
        catch (Exception e) {
            return;
        }
    }

    public final void release() {
        if (bInit) {
            JBapiIntNW.CBRelease();
            bInit = false;
        }
    }

    public String getRFCVersion() {
        int[] verInfo = new int[3];
        verInfo = JBapiIntNW.CBGetRFCVersion();
        String verStr = "v" + verInfo[0] + "." + verInfo[1] + "." + verInfo[2];
        return verStr;
    }

    public String getBAPIINTNWVersion() {
        String verStr;
        int[] verInfo = new int[2];
        try {
            verInfo = JBapiIntNW.CBGetBAPIINTNWVersion();
            verStr = "v" + verInfo[0] + "." + verInfo[1];
        }
        catch (Exception e) {
            throw new JBapiException("getBAPIINTNWVersion: " + e.getLocalizedMessage());
        }
        return verStr;
    }

    public int healthCheck(int iReserved) {
        try {
            return JBapiIntNW.CBHealthCheck(iReserved);
        }
        catch (Exception e) {
            throw new JBapiException("healthCheck: " + e.getLocalizedMessage());
        }
    }

    public int reloadConfig(String cfgPath) {
        try {
            return JBapiIntNW.CBReloadConfig(cfgPath);
        }
        catch (Exception e) {
            throw new JBapiException("reloadConfig: " + e.getLocalizedMessage());
        }
    }

    public String getConfigFileName() {
        try {
            return JBapiIntNW.CBGetConfigFileName();
        }
        catch (Exception e) {
            throw new JBapiException("getConfigFileName: " + e.getLocalizedMessage());
        }
    }

    public boolean exportConfig(String fileName) {
        try {
            return JBapiIntNW.CBExportConfiguration(fileName);
        }
        catch (Exception e) {
            throw new JBapiException("exportConfig: " + e.getLocalizedMessage());
        }
    }

    public void setRFCTraceLevel(int nLevel) {
        JBapiIntNW.CBSetRFCTraceLevel(nLevel);
    }

    public void setConnectionRecovery(int flag) {
        JBapiIntNW.CBSetConnectRecovery(flag);
    }

    public boolean exportFunctionCache(String fileName) {
        try {
            return JBapiIntNW.CBExportFuncCache(fileName);
        }
        catch (Exception e) {
            throw new JBapiException("exportFunctionCache: " + e.getLocalizedMessage());
        }
    }

    public int getFunctionDescCount(boolean bIgnoreStatic) {
        try {
            return JBapiIntNW.CBGetFunctionDescCount(bIgnoreStatic);
        }
        catch (Exception e) {
            throw new JBapiException("getFunctionCount: " + e.getLocalizedMessage());
        }
    }

    public int getContainerCount() {
        try {
            return JBapiIntNW.CBGetContainersCount();
        }
        catch (Exception e) {
            throw new JBapiException("getContainerCount: " + e.getLocalizedMessage());
        }
    }

    public int getFunctionCount() {
        try {
            return JBapiIntNW.CBGetFunctionsCount();
        }
        catch (Exception e) {
            throw new JBapiException("getFunctionCount: " + e.getLocalizedMessage());
        }
    }

    public String getCurrentPath() {
        try {
            return JBapiIntNW.CBCurrentPath();
        }
        catch (Exception e) {
            throw new JBapiException("CBCurrentPath: " + e.getLocalizedMessage());
        }
    }

    public int rebuildFuncCache(JBapiConnect connect, boolean bDfltLoad, boolean bForced) throws JBapiException {
        if (connect == null) {
            return -1;
        }
        return JBapiIntNW.CBRebuildFuncCache(connect.getHandle(), bDfltLoad, bForced);
    }

    private static native int[] CBGetRFCVersion() throws JBapiException;

    private static native int[] CBGetBAPIINTNWVersion() throws JBapiException;

    private static native int CBReloadConfig(String var0) throws JBapiException;

    private static native String CBGetConfigFileName() throws JBapiException;

    private static native int CBHealthCheck(int var0) throws JBapiException;

    private static native int CBInit(boolean var0, String var1) throws JBapiException;

    private static native void CBRelease() throws JBapiException;

    private static native void CBWriteBAPILog(int var0, String var1, String var2) throws JBapiException;

    private static native void CBSetBAPILogLevel(int var0) throws JBapiException;

    private static native void CBSetRFCTraceLevel(int var0) throws JBapiException;

    private static native int CBGetFunctionDescCount(boolean var0) throws JBapiException;

    private static native int CBGetContainersCount() throws JBapiException;

    private static native int CBGetFunctionsCount() throws JBapiException;

    private static native boolean CBExportFuncCache(String var0) throws JBapiException;

    private static native boolean CBExportConfiguration(String var0) throws JBapiException;

    private static native String CBCurrentPath() throws JBapiException;

    private static native int CBRebuildFuncCache(long var0, boolean var2, boolean var3) throws JBapiException;

    private static native void CBSetConnectRecovery(int var0) throws JBapiException;
}

