/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.conn.bapi;

import com.cognos.xqe.conn.bapi.JBapiComplex;
import com.cognos.xqe.conn.bapi.JBapiException;

public class JBapiTable
extends JBapiComplex {
    private static final String COL_SEP_STR = "; ";
    private static final String NEW_LINE_STR = "\n";
    private static final String OF_BP_STR = " of ";
    private int mTableRows = -1;
    private boolean mIsStandAlone = false;

    public JBapiTable(long hTable, String name) {
        this.mName = name;
        this.mPHandle = hTable;
    }

    public JBapiTable(JBapiTable refTable) {
        this.mName = refTable.mName;
        try {
            this.mPHandle = JBapiTable.CBTableCopyConstructor(refTable.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldName: " + e.getMessage());
        }
        if (this.mPHandle > 0L) {
            this.mIsStandAlone = true;
        }
    }

    public final boolean release() {
        if (!this.mIsStandAlone || this.mPHandle == 0L) {
            return false;
        }
        JBapiTable.CBTableRelease(this.mPHandle);
        this.mPHandle = 0L;
        return true;
    }

    public final String getTableName() {
        return this.mName;
    }

    public final int getNumRows() {
        this.mTableRows = JBapiTable.CBTableRowCount(this.mPHandle);
        return this.mTableRows;
    }

    public final void clearContent() throws JBapiException {
        try {
            JBapiTable.CBTableClear(this.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("clearContent: " + e.getMessage());
        }
    }

    public final int copyRowsFrom(JBapiTable refTable, int nMaxRows, boolean bAppend, boolean bForce) {
        try {
            return JBapiTable.CBTableCopyRowsFrom(this.mPHandle, refTable.mPHandle, nMaxRows, bAppend, bForce);
        }
        catch (JBapiException e) {
            throw new JBapiException("copyRowsFrom: " + e.getMessage());
        }
    }

    public final void deleteRow() throws JBapiException {
        try {
            JBapiTable.CBTableDeleteRow(this.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("deleteRow: " + e.getMessage());
        }
    }

    public final void appendRow() throws JBapiException {
        try {
            JBapiTable.CBTableAppendRow(this.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("appendRow: " + e.getMessage());
        }
    }

    public final int moveTo(int nRow) throws JBapiException {
        try {
            return JBapiTable.CBTableMoveTo(this.mPHandle, nRow);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveTo: " + e.getMessage());
        }
    }

    public final int moveToFirst() throws JBapiException {
        try {
            return JBapiTable.CBTableMoveToFirst(this.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveToFirst: " + e.getMessage());
        }
    }

    public final int moveToLast() throws JBapiException {
        try {
            return JBapiTable.CBTableMoveToLast(this.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveToLast: " + e.getMessage());
        }
    }

    public final int moveToNext() throws JBapiException {
        try {
            return JBapiTable.CBTableMoveToNext(this.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveToNext: " + e.getMessage());
        }
    }

    public final int moveToPrevious() throws JBapiException {
        try {
            return JBapiTable.CBTableMoveToPrevious(this.mPHandle);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveToPrevious: " + e.getMessage());
        }
    }

    public final int moveToNextIndex(boolean bChild, boolean bRestart) throws JBapiException {
        try {
            return JBapiTable.CBTableMoveToNextIndex(this.mPHandle, bChild, bRestart);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveToNextIndex: " + e.getMessage());
        }
    }

    public final int moveToSearchInt(int fieldNumber, int iSearch, boolean bBackward, boolean bRestart) throws JBapiException {
        try {
            return JBapiTable.CBTableMoveToSearchInt(this.mPHandle, fieldNumber, iSearch, bBackward, bRestart);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveToSearchInt: " + e.getMessage());
        }
    }

    public final int moveToSearch(int fieldNumber, String searchString, boolean bBackward) throws JBapiException {
        try {
            return JBapiTable.CBTableMoveToSearch(this.mPHandle, fieldNumber, searchString, bBackward);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveToSearch: " + e.getMessage());
        }
    }

    public final int moveToSearchNext(int fieldNumber) throws JBapiException {
        try {
            return JBapiTable.CBTableMoveToSearchNext(this.mPHandle, fieldNumber);
        }
        catch (JBapiException e) {
            throw new JBapiException("moveToSearchNext: " + e.getMessage());
        }
    }

    public final String getField(String fldName) throws JBapiException {
        try {
            return JBapiTable.CBTableGetField(this.mPHandle, fldName);
        }
        catch (JBapiException e) {
            throw new JBapiException("getField: " + e.getMessage());
        }
    }

    public final void setField(String fldName, String value) throws JBapiException {
        try {
            JBapiTable.CBTableSetField(this.mPHandle, fldName, value);
        }
        catch (JBapiException e) {
            throw new JBapiException("setField: " + e.getMessage());
        }
    }

    public final String getFieldFast(String fldName) throws JBapiException {
        try {
            return JBapiTable.CBTableGetFieldFast(this.mPHandle, fldName);
        }
        catch (JBapiException e) {
            throw new JBapiException("getField: " + e.getMessage());
        }
    }

    public final String[] getFieldArray(String fldName, int nStartRow, int nEndRow) throws JBapiException {
        try {
            return JBapiTable.CBTableGetFieldArray(this.mPHandle, fldName, nStartRow, nEndRow);
        }
        catch (JBapiException e) {
            throw new JBapiException("getFieldArray: " + e.getMessage());
        }
    }

    public final int saveTable(String fileName, char fldSep, boolean bAddRowNums, boolean bStrConv) throws JBapiException {
        return JBapiTable.CBTableSaveTable(this.mPHandle, fileName, fldSep, false, bAddRowNums, bStrConv);
    }

    public final long getHandle(boolean funcHandle, boolean update) throws JBapiException {
        try {
            return JBapiTable.CBTableGetHandle(this.mPHandle, funcHandle, update);
        }
        catch (JBapiException e) {
            throw new JBapiException("getHandle: " + e.getMessage());
        }
    }

    public final String traceToString(int maxRows) {
        int max = maxRows;
        if (max > this.getNumRows()) {
            max = this.getNumRows();
        }
        StringBuffer ret = new StringBuffer("BAPI Table Dump: ");
        ret.append(this.mName);
        ret.append(" (");
        ret.append(max);
        ret.append(OF_BP_STR);
        ret.append(this.getNumRows());
        ret.append(" rows)");
        ret.append(NEW_LINE_STR);
        if (this.getFieldDesc(0) == null) {
            return ret.toString();
        }
        for (int i = 0; i < this.mFldArray.length; ++i) {
            ret.append(this.mFldArray[i].fldName);
            ret.append(COL_SEP_STR);
        }
        ret.append(NEW_LINE_STR);
        for (int row = 0; row < max; ++row) {
            this.moveTo(row);
            for (int i = 0; i < this.mFldArray.length; ++i) {
                ret.append(this.getFieldByIndex(i));
                ret.append(COL_SEP_STR);
            }
            ret.append(NEW_LINE_STR);
        }
        return ret.toString();
    }

    private static native long CBTableCopyConstructor(long var0) throws JBapiException;

    private static native int CBTableCopyRowsFrom(long var0, long var2, int var4, boolean var5, boolean var6) throws JBapiException;

    private static native int CBTableRelease(long var0) throws JBapiException;

    private static native int CBTableRowCount(long var0) throws JBapiException;

    private static native void CBTableClear(long var0) throws JBapiException;

    private static native void CBTableDeleteRow(long var0) throws JBapiException;

    private static native void CBTableAppendRow(long var0) throws JBapiException;

    private static native int CBTableMoveTo(long var0, int var2) throws JBapiException;

    private static native int CBTableMoveToFirst(long var0) throws JBapiException;

    private static native int CBTableMoveToLast(long var0) throws JBapiException;

    private static native int CBTableMoveToNext(long var0) throws JBapiException;

    private static native int CBTableMoveToPrevious(long var0) throws JBapiException;

    private static native int CBTableMoveToNextIndex(long var0, boolean var2, boolean var3) throws JBapiException;

    private static native int CBTableMoveToSearch(long var0, int var2, String var3, boolean var4) throws JBapiException;

    private static native int CBTableMoveToSearchNext(long var0, int var2) throws JBapiException;

    private static native int CBTableMoveToSearchInt(long var0, int var2, int var3, boolean var4, boolean var5) throws JBapiException;

    private static native void CBTableSetField(long var0, String var2, String var3) throws JBapiException;

    private static native String CBTableGetField(long var0, String var2) throws JBapiException;

    private static native String CBTableGetFieldFast(long var0, String var2) throws JBapiException;

    private static native String[] CBTableGetFieldArray(long var0, String var2, int var3, int var4) throws JBapiException;

    private static native int CBTableSaveTable(long var0, String var2, char var3, boolean var4, boolean var5, boolean var6) throws JBapiException;

    private static native long CBTableGetHandle(long var0, boolean var2, boolean var3) throws JBapiException;
}

