/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.siebel.sdb.impl;

import com.cognos.cdms.ds.logger.Logger;
import com.cognos.cdms.ds.siebel.beans.SiebelFieldBean;
import com.cognos.cdms.ds.siebel.beans.SiebelMethodParamBean;
import com.cognos.cdms.ds.siebel.beans.SiebelQueryBean;
import com.cognos.cdms.ds.siebel.sdb.SDBConnection;
import com.cognos.cdms.ds.siebel.sdb.SDBException;
import com.cognos.cdms.ds.siebel.sdb.SDBLoggerModule;
import com.cognos.cdms.ds.siebel.sdb.SDBProcedure;
import com.cognos.cdms.ds.siebel.sdb.SDBResultSet;
import com.cognos.cdms.ds.siebel.sdb.impl.SDBParamsHelper;
import com.cognos.cdms.ds.siebel.sdb.impl.SDBProcedureImpl;
import com.cognos.cdms.ds.siebel.sdb.impl.SDBResultSetImpl;
import com.cognos.cdms.ds.siebel.sdb.impl.SDBSession;
import com.cognos.cdms.ds.siebel.sdb.impl.SDBSessionPool;
import com.siebel.data.SiebelBusComp;
import com.siebel.data.SiebelBusObject;
import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDBConnectionImpl
implements SDBConnection {
    private static final Logger logger = SDBLoggerModule.getLoggerFactory().getLogger(SDBConnectionImpl.class);
    private SDBSession mSDBSession = null;
    private String mConnectStr = null;
    private String mUserName = null;
    private String mPassword = null;

    public SDBConnectionImpl(String connectStr, String userName, String password) {
        this.mConnectStr = connectStr;
        this.mUserName = userName;
        this.mPassword = password;
    }

    SDBConnectionImpl(String connectStr, String userName, String password, SDBSession session) {
        this(connectStr, userName, password);
        this.mSDBSession = session;
    }

    protected static String escapeSplChars(String str) {
        return "\"" + str + "\"";
    }

    private void addAuditFields(List<SiebelFieldBean> fields) {
        String[] dateFields = new String[]{"Created", "Updated"};
        String[] userIDFields = new String[]{"Created By", "Updated By"};
        for (int i = 0; i < userIDFields.length; ++i) {
            String dateField = dateFields[i];
            SiebelFieldBean field = new SiebelFieldBean(dateField, true);
            field.setNativeDataType("DTYPE_DATETIME");
            fields.add(field);
            String userID = userIDFields[i];
            field = new SiebelFieldBean(userID, true);
            field.setNativeDataType("DTYPE_ID");
            fields.add(field);
        }
    }

    private void addIdField(List<SiebelFieldBean> fields) {
        SiebelFieldBean field = new SiebelFieldBean("Id", true);
        field.setNativeDataType("DTYPE_ID");
        field.setDestFieldName("Id");
        fields.add(field);
    }

    private void executeQuery(SiebelBusComp busComp, boolean forwardOnlyCursor) throws SiebelException {
        try {
            busComp.executeQuery(forwardOnlyCursor);
        }
        catch (SiebelException se) {
            if (logger.isDebug()) {
                logger.debug("Exception while invoking executeQuery on Business Component", se);
            }
            throw se;
        }
    }

    @Override
    public SDBResultSet executeQuery(SiebelQueryBean queryBean) throws SDBException {
        this.assertConnected();
        SiebelBusObject busObj = null;
        SiebelBusComp busComp = null;
        try {
            String sortSpec;
            busObj = this.mSDBSession.getBusObject(queryBean.getBusinessObject());
            busComp = busObj.getBusComp(queryBean.getBusinessComponent());
            busComp.clearToQuery();
            busComp.setViewMode(queryBean.getViewMode());
            List<String> fields = queryBean.getFields();
            for (String fieldName : fields) {
                if (fieldName.equals("1")) {
                    fieldName = "Id";
                }
                busComp.activateField(fieldName);
            }
            String searchExpr = queryBean.getSearchExpression();
            if (searchExpr != null && searchExpr.trim().length() > 0) {
                if (logger.isDebug()) {
                    logger.debug("Pushing WHERE clause : " + searchExpr);
                }
                busComp.setSearchExpr(searchExpr);
            }
            if ((sortSpec = queryBean.getSortSpecification()) != null && sortSpec.trim().length() > 0) {
                if (logger.isDebug()) {
                    logger.debug("Pushing ORDER BY clause : " + sortSpec);
                }
                busComp.setSortSpec(sortSpec);
            }
            this.executeQuery(busComp, true);
            return new SDBResultSetImpl(busComp, queryBean.clone());
        }
        catch (SiebelException e) {
            if (busComp != null) {
                busComp.release();
            }
            if (busObj != null) {
                busObj.release();
            }
            if (logger.isDebug()) {
                logger.debug("Unable to execute Query " + queryBean.getSql());
                logger.log(e);
            }
            throw new SDBException(1, "Query Execution failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, Map<String, String>>> getDestFieldProps(Map<String, Set<String>> destBCToFieldsMap, String repositoryName) throws SiebelException {
        HashMap<String, Map<String, Map<String, String>>> destFieldProps = new HashMap<String, Map<String, Map<String, String>>>();
        Set<String> destBCNames = destBCToFieldsMap.keySet();
        if (destBCNames.size() == 0) {
            return destFieldProps;
        }
        Iterator<String> bcIter = destBCNames.iterator();
        StringBuilder searchExpr = new StringBuilder("( ");
        while (bcIter.hasNext()) {
            String bcName = bcIter.next();
            searchExpr.append("[Name] = '" + bcName + "'");
            if (bcIter.hasNext()) {
                searchExpr.append(" OR ");
                continue;
            }
            searchExpr.append(" )");
            searchExpr.append(" AND ([Repository Name] = '" + repositoryName + "' )");
        }
        SiebelBusObject busCompBO = this.mSDBSession.getBusObject("Repository Business Component");
        SiebelBusComp busCompBC = busCompBO.getBusComp("Repository Business Component");
        try {
            busCompBC.clearToQuery();
            busCompBC.setSearchExpr(searchExpr.toString());
            busCompBC.executeQuery(true);
            boolean loop = busCompBC.firstRecord();
            while (loop) {
                String bcName = busCompBC.getFieldValue("Name");
                SiebelBusComp fieldBC = busCompBO.getBusComp("Repository Field");
                Set<String> fieldSet = destBCToFieldsMap.get(bcName);
                Iterator<String> fieldIter = fieldSet.iterator();
                StringBuilder fieldSearchExpr = new StringBuilder("( ");
                while (fieldIter.hasNext()) {
                    String fieldName = fieldIter.next();
                    fieldSearchExpr.append("[Name] = '" + fieldName + "'");
                    if (fieldIter.hasNext()) {
                        fieldSearchExpr.append(" OR ");
                        continue;
                    }
                    fieldSearchExpr.append(" ) ");
                }
                fieldBC.clearToQuery();
                fieldBC.setSearchExpr(fieldSearchExpr.toString());
                fieldBC.activateField("Type");
                fieldBC.activateField("Text Length");
                fieldBC.activateField("Precision");
                fieldBC.activateField("Scale");
                fieldBC.activateField("Required");
                fieldBC.executeQuery(true);
                boolean loopInner = fieldBC.firstRecord();
                HashMap fieldMap = new HashMap();
                destFieldProps.put(bcName, fieldMap);
                while (loopInner) {
                    String fieldName = fieldBC.getFieldValue("Name");
                    HashMap<String, String> fieldPropMap = new HashMap<String, String>();
                    fieldPropMap.put("Type", fieldBC.getFieldValue("Type"));
                    fieldPropMap.put("Text Length", fieldBC.getFieldValue("Text Length"));
                    fieldPropMap.put("Precision", fieldBC.getFieldValue("Precision"));
                    fieldPropMap.put("Scale", fieldBC.getFieldValue("Scale"));
                    fieldPropMap.put("Required", fieldBC.getFieldValue("Required"));
                    fieldMap.put(fieldName, fieldPropMap);
                    loopInner = fieldBC.nextRecord();
                }
                fieldBC.release();
                loop = busCompBC.nextRecord();
            }
            HashMap<String, Map<String, Map<String, String>>> hashMap = destFieldProps;
            return hashMap;
        }
        finally {
            if (busCompBC != null) {
                busCompBC.release();
            }
            if (busCompBO != null) {
                busCompBO.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> getMVLProps(String busCompName, String repositoryName) throws SiebelException {
        SiebelBusObject busCompBO = null;
        SiebelBusComp busCompBC = null;
        try {
            busCompBO = this.mSDBSession.getBusObject("Repository Business Component");
            busCompBC = busCompBO.getBusComp("Repository Business Component");
            busCompBC.clearToQuery();
            busCompBC.setSearchSpec("Name", SDBConnectionImpl.escapeSplChars(busCompName));
            busCompBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
            busCompBC.executeQuery(true);
            boolean found = busCompBC.firstRecord();
            if (found) {
                SiebelBusComp mvlBC = busCompBO.getBusComp("Repository Multi Value Link");
                mvlBC.clearToQuery();
                mvlBC.activateField("No Associate");
                mvlBC.activateField("Destination Business Component");
                mvlBC.activateField("Destination Link");
                mvlBC.activateField("Primary Id Field");
                mvlBC.activateField("Use Primary Join");
                mvlBC.executeQuery(true);
                boolean loop = mvlBC.firstRecord();
                HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
                while (loop) {
                    String mvlName = mvlBC.getFieldValue("Name");
                    String noAssocValue = mvlBC.getFieldValue("No Associate");
                    String destBusCompName = mvlBC.getFieldValue("Destination Business Component");
                    String destLink = mvlBC.getFieldValue("Destination Link");
                    String primaryIdField = mvlBC.getFieldValue("Primary Id Field");
                    String usePrimaryJoin = mvlBC.getFieldValue("Use Primary Join");
                    SiebelBusObject linkBO = this.mSDBSession.getBusObject("Repository Link");
                    SiebelBusComp linkBC = linkBO.getBusComp("Repository Link");
                    linkBC.clearToQuery();
                    destLink = SDBConnectionImpl.escapeSplChars(destLink);
                    linkBC.setSearchSpec("Name", destLink);
                    linkBC.activateField("Source Field");
                    linkBC.activateField("Destination Field");
                    linkBC.executeQuery(true);
                    String linkSourceField = null;
                    String linkDestField = null;
                    if (linkBC.firstRecord()) {
                        linkSourceField = linkBC.getFieldValue("Source Field");
                        linkDestField = linkBC.getFieldValue("Destination Field");
                    }
                    linkBC.release();
                    linkBO.release();
                    HashMap<String, String> propMap = new HashMap<String, String>();
                    propMap.put("No Associate", noAssocValue);
                    propMap.put("Destination Business Component", destBusCompName);
                    propMap.put("Link Source Field", linkSourceField);
                    propMap.put("Link Destination Field", linkDestField);
                    propMap.put("Primary Id Field", primaryIdField);
                    propMap.put("Use Primary Join", usePrimaryJoin);
                    map.put(mvlName, propMap);
                    loop = mvlBC.nextRecord();
                }
                mvlBC.release();
                HashMap<String, Map<String, String>> hashMap = map;
                return hashMap;
            }
            Map<String, Map<String, String>> map = null;
            return map;
        }
        finally {
            if (busCompBC != null) {
                busCompBC.release();
            }
            if (busCompBO != null) {
                busCompBO.release();
            }
        }
    }

    SiebelPropertySet executeProcedure(SDBProcedure proc) throws SDBException {
        SDBProcedureImpl procImpl = (SDBProcedureImpl)proc;
        SiebelService busService = null;
        String busServiceName = proc.getSchemaName();
        String busMethodName = proc.getProcedureName();
        String errorMsg = "Failed to execute the Business Method " + busServiceName + "." + busMethodName;
        try {
            busService = this.mSDBSession.getService(busServiceName);
            SiebelPropertySet ipPS = this.mSDBSession.newPropertySet();
            SiebelPropertySet opPS = this.mSDBSession.newPropertySet();
            boolean success = busService.invokeMethod(busMethodName, SDBParamsHelper.getInputParamsAsPropertySet(procImpl.getInputParams(), ipPS), opPS);
            if (!success) {
                if (logger.isDebug()) {
                    logger.debug(errorMsg);
                }
                throw new SDBException(2, errorMsg, null);
            }
            SiebelPropertySet siebelPropertySet = opPS;
            return siebelPropertySet;
        }
        catch (SiebelException se) {
            if (logger.isDebug()) {
                logger.debug("Exception while executing Business Method " + busServiceName + "." + busMethodName, se);
            }
            throw new SDBException(2, errorMsg, se);
        }
        finally {
            if (busService != null) {
                busService.release();
            }
        }
    }

    @Override
    public void connect(int retryCount, int retryDelay, String codePage) throws SDBException {
        if (this.mSDBSession != null) {
            this.close();
        }
        ++retryCount;
        for (int i = 0; i < retryCount; ++i) {
            try {
                System.setProperty("siebel.conmgr.retry", String.valueOf(0));
                this.mSDBSession = SDBSessionPool.getInstance().checkOut(this.mConnectStr, this.mUserName, this.mPassword, codePage);
                break;
            }
            catch (SDBException sdbException) {
                if (logger.isDebug()) {
                    logger.debug("Login attempt no. " + (i + 1) + " failed .");
                }
                if (i < retryCount - 1) {
                    if (logger.isDebug()) {
                        logger.debug(" Will try login again after " + retryDelay + " seconds.");
                    }
                    try {
                        Thread.sleep(retryDelay * 1000);
                    }
                    catch (InterruptedException ie) {
                        logger.log(ie);
                    }
                    continue;
                }
                if (logger.isDebug()) {
                    logger.debug("Failed to login after " + retryCount + "attempts. ");
                }
                throw new SDBException(0, "Failed to login after " + retryCount + "attempts. ");
            }
        }
    }

    @Override
    public void close() {
        if (this.mSDBSession != null) {
            SDBSessionPool.getInstance().checkIn(this.mSDBSession);
            this.mSDBSession = null;
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public List<String> getBusinessComponentNames(String busObjName, String busCompFilter, String repositoryName) {
        this.assertConnected();
        try {
            ArrayList<String> bcNames = new ArrayList<String>();
            SiebelBusObject busObjBO = this.mSDBSession.getBusObject("Repository Business Object");
            SiebelBusComp busObjBC = busObjBO.getBusComp("Repository Business Object");
            busObjBC.clearToQuery();
            busObjBC.setSearchSpec("Name", SDBConnectionImpl.escapeSplChars(busObjName));
            busObjBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
            busObjBC.activateField("Name");
            busObjBC.executeQuery(true);
            boolean found = busObjBC.firstRecord();
            if (found) {
                SiebelBusComp busObjCompBC = busObjBO.getBusComp("Repository Business Object Component");
                busObjCompBC.clearToQuery();
                if (busCompFilter != null && !"".equals(busCompFilter)) {
                    busObjCompBC.setSearchSpec("BusComp", "LIKE '" + busCompFilter + "'");
                }
                busObjCompBC.setSearchSpec("Inactive", "N");
                busObjCompBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
                busObjCompBC.activateField("BusComp");
                busObjCompBC.executeQuery(true);
                boolean loop = busObjCompBC.firstRecord();
                while (loop) {
                    String busCompName = busObjCompBC.getFieldValue("BusComp");
                    bcNames.add(busCompName);
                    loop = busObjCompBC.nextRecord();
                }
                busObjCompBC.release();
            }
            busObjBC.release();
            busObjBO.release();
            return bcNames;
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("Exception while fetching Business Components for Business Object = " + busObjName + "and filter = " + busCompFilter, e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getBusinessMethodNames(String busServiceName, String busMethodFilter, String repositoryName) {
        this.assertConnected();
        SiebelBusObject busServBO = null;
        SiebelBusComp busServBC = null;
        try {
            ArrayList<String> busMethodNames = new ArrayList<String>();
            busServBO = this.mSDBSession.getBusObject("Repository Business Service");
            busServBC = busServBO.getBusComp("Repository Business Service");
            busServBC.clearToQuery();
            busServBC.setSearchSpec("Name", SDBConnectionImpl.escapeSplChars(busServiceName));
            busServBC.setSearchSpec("Inactive", "N");
            busServBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
            busServBC.executeQuery(true);
            boolean found = busServBC.firstRecord();
            if (found) {
                SiebelBusComp busMethodBC = busServBO.getBusComp("Repository Business Service Method");
                busMethodBC.clearToQuery();
                if (busMethodFilter != null && !"".equals(busMethodFilter)) {
                    busMethodBC.setSearchSpec("Name", "LIKE '" + busMethodFilter + "'");
                }
                busMethodBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
                busMethodBC.setSearchSpec("Inactive", "N");
                busMethodBC.activateField("Name");
                busMethodBC.executeQuery(true);
                boolean loop = busMethodBC.firstRecord();
                while (loop) {
                    String name = busMethodBC.getFieldValue("Name");
                    busMethodNames.add(name);
                    loop = busMethodBC.nextRecord();
                }
                busMethodBC.release();
            }
            ArrayList<String> arrayList = busMethodNames;
            return arrayList;
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("Exception while fetching Business methods for Business Service = " + busServiceName + " with filter = " + busMethodFilter, e);
            }
        }
        finally {
            if (busServBC != null) {
                busServBC.release();
            }
            if (busServBO != null) {
                busServBO.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getBusinessObjectNames(String busObjFilter, String repositoryName) {
        this.assertConnected();
        SiebelBusObject busObjBO = null;
        SiebelBusComp busObjBC = null;
        try {
            ArrayList<String> boNames = new ArrayList<String>();
            busObjBO = this.mSDBSession.getBusObject("Repository Business Object");
            busObjBC = busObjBO.getBusComp("Repository Business Object");
            busObjBC.clearToQuery();
            if (busObjFilter != null && !"".equals(busObjFilter)) {
                busObjBC.setSearchSpec("Name", "LIKE '" + busObjFilter + "'");
            }
            busObjBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
            busObjBC.activateField("Name");
            busObjBC.executeQuery(true);
            boolean loop = busObjBC.firstRecord();
            while (loop) {
                String name = busObjBC.getFieldValue("Name");
                boNames.add(name);
                loop = busObjBC.nextRecord();
            }
            ArrayList<String> arrayList = boNames;
            return arrayList;
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("Exception while fetching Business Objects with filter = " + busObjFilter + " in Repository = " + repositoryName, e);
            }
        }
        finally {
            if (busObjBC != null) {
                busObjBC.release();
            }
            if (busObjBO != null) {
                busObjBO.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getBusinessServiceNames(String busServiceFilter, String repositoryName) {
        this.assertConnected();
        SiebelBusObject busServBO = null;
        SiebelBusComp busServBC = null;
        try {
            ArrayList<String> bsNames = new ArrayList<String>();
            busServBO = this.mSDBSession.getBusObject("Repository Business Service");
            busServBC = busServBO.getBusComp("Repository Business Service");
            busServBC.clearToQuery();
            if (busServiceFilter != null && !"".equals(busServiceFilter)) {
                busServBC.setSearchSpec("Name", "LIKE '" + busServiceFilter + "'");
            }
            busServBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
            busServBC.setSearchSpec("Inactive", "N");
            busServBC.activateField("Name");
            busServBC.executeQuery(true);
            boolean loop = busServBC.firstRecord();
            while (loop) {
                String name = busServBC.getFieldValue("Name");
                bsNames.add(name);
                loop = busServBC.nextRecord();
            }
            ArrayList<String> arrayList = bsNames;
            return arrayList;
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("Exception while fetching Business Services  with search filter = " + busServiceFilter, e);
            }
        }
        finally {
            if (busServBC != null) {
                busServBC.release();
            }
            if (busServBO != null) {
                busServBO.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SiebelFieldBean> getFields(String busCompName, String repositoryName) {
        this.assertConnected();
        SiebelBusObject busCompBO = null;
        SiebelBusComp busCompBC = null;
        try {
            busCompBO = this.mSDBSession.getBusObject("Repository Business Component");
            busCompBC = busCompBO.getBusComp("Repository Business Component");
            busCompBC.clearToQuery();
            busCompBC.setSearchSpec("Name", SDBConnectionImpl.escapeSplChars(busCompName));
            busCompBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
            busCompBC.executeQuery(true);
            boolean found = busCompBC.firstRecord();
            if (found) {
                ArrayList<SiebelFieldBean> fields = new ArrayList<SiebelFieldBean>();
                this.addIdField(fields);
                SiebelBusComp fieldBC = busCompBO.getBusComp("Repository Field");
                fieldBC.clearToQuery();
                fieldBC.setSearchSpec("Repository Name", SDBConnectionImpl.escapeSplChars(repositoryName));
                fieldBC.setSearchSpec("Inactive", "N");
                fieldBC.activateField("Required");
                fieldBC.activateField("Link Specification");
                fieldBC.activateField("Text Length");
                fieldBC.activateField("Scale");
                fieldBC.activateField("Read Only");
                fieldBC.executeQuery(true);
                boolean loop = fieldBC.firstRecord();
                while (loop) {
                    String name = fieldBC.getFieldValue("Name");
                    String required = fieldBC.getFieldValue("Required");
                    String nativeDataType = fieldBC.getFieldValue("Type");
                    String mvLinkName = fieldBC.getFieldValue("Multi Value Link");
                    String destField = fieldBC.getFieldValue("Dest Field");
                    String textLength = fieldBC.getFieldValue("Text Length");
                    String precision = fieldBC.getFieldValue("Precision");
                    String scale = fieldBC.getFieldValue("Scale");
                    String readOnly = fieldBC.getFieldValue("Read Only");
                    String linkSpec = fieldBC.getFieldValue("Link Specification");
                    SiebelFieldBean field = new SiebelFieldBean(name, "Y".equals(required));
                    if (mvLinkName != null && mvLinkName.length() > 0) {
                        field.setMVLinkName(mvLinkName);
                        field.setDestFieldName(destField);
                    }
                    field.setNativeDataType(nativeDataType);
                    field.setTextLength(textLength);
                    field.setPrecision(precision);
                    field.setScale(scale);
                    field.setLinkSpec("Y".equals(linkSpec));
                    field.setReadOnly("Y".equals(readOnly));
                    fields.add(field);
                    loop = fieldBC.nextRecord();
                }
                fieldBC.release();
                Map<String, Map<String, String>> mvlPropMap = this.getMVLProps(busCompName, repositoryName);
                Iterator iter = fields.iterator();
                HashMap<String, Set<String>> destBCToFieldsMap = new HashMap<String, Set<String>>();
                while (iter.hasNext()) {
                    SiebelFieldBean field = (SiebelFieldBean)iter.next();
                    String mvlName = field.getMVLinkName();
                    Map<String, String> props = mvlPropMap.get(mvlName);
                    if (!field.isMultiValued() || props == null) continue;
                    field.setNoAssociate("Y".equals(props.get("No Associate")));
                    field.setDestBusCompName(props.get("Destination Business Component"));
                    field.setLinkSourceField(props.get("Link Source Field"));
                    field.setLinkDestField(props.get("Link Destination Field"));
                    String primaryIdField = props.get("Primary Id Field");
                    field.setUsePrimaryJoin(primaryIdField != null && primaryIdField.trim().length() > 0 && "Y".equals(props.get("Use Primary Join")));
                    HashSet<String> fieldSet = (HashSet<String>)destBCToFieldsMap.get(field.getDestBusCompName());
                    if (fieldSet == null) {
                        fieldSet = new HashSet<String>();
                        destBCToFieldsMap.put(field.getDestBusCompName(), fieldSet);
                    }
                    fieldSet.add(field.getDestFieldName());
                }
                Map<String, Map<String, Map<String, String>>> destFieldProps = this.getDestFieldProps(destBCToFieldsMap, repositoryName);
                for (SiebelFieldBean field : fields) {
                    String destBCName;
                    Map<String, Map<String, String>> fieldProps;
                    if (!field.isMultiValued() || (fieldProps = destFieldProps.get(destBCName = field.getDestBusCompName())) == null) continue;
                    String destFieldName = field.getDestFieldName();
                    Map<String, String> props = fieldProps.get(destFieldName);
                    if (props != null) {
                        field.setNativeDataType(props.get("Type"));
                        field.setTextLength(props.get("Text Length"));
                        field.setPrecision(props.get("Precision"));
                        field.setScale(props.get("Scale"));
                        field.setRequired("Y".equals(props.get("Required")));
                        continue;
                    }
                    if (!"Id".equals(destFieldName) && !"Updated By".equals(destFieldName) && !"Created By".equals(destFieldName) && !"Updated".equals(destFieldName) && !"Created".equals(destFieldName)) continue;
                    field.setNativeDataType("DTYPE_TEXT");
                }
                this.addAuditFields(fields);
                ArrayList<SiebelFieldBean> arrayList = fields;
                return arrayList;
            }
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("Exception while fetching field information for Business Component " + busCompName, e);
            }
        }
        finally {
            if (busCompBC != null) {
                busCompBC.release();
            }
            if (busCompBO != null) {
                busCompBO.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SiebelMethodParamBean> getMethodParams(String busServiceName, String methodName, String repositoryName) {
        this.assertConnected();
        ArrayList<SiebelMethodParamBean> list = new ArrayList<SiebelMethodParamBean>();
        SiebelBusObject busServiceBO = null;
        SiebelBusComp busServiceBC = null;
        try {
            busServiceBO = this.mSDBSession.getBusObject("Repository Business Service");
            busServiceBC = busServiceBO.getBusComp("Repository Business Service");
            busServiceBC.clearToQuery();
            busServiceBC.setSearchSpec("Name", SDBConnectionImpl.escapeSplChars(busServiceName));
            busServiceBC.setSearchSpec("Inactive", "N");
            busServiceBC.executeQuery(true);
            if (busServiceBC.firstRecord()) {
                SiebelBusComp busMethodBC = busServiceBO.getBusComp("Repository Business Service Method");
                busMethodBC.clearToQuery();
                busMethodBC.setSearchSpec("Name", SDBConnectionImpl.escapeSplChars(methodName));
                busMethodBC.setSearchSpec("Inactive", "N");
                busMethodBC.executeQuery(true);
                if (busMethodBC.firstRecord()) {
                    SiebelBusComp argBC = busServiceBO.getBusComp("Repository Business Service Method Arg");
                    argBC.clearToQuery();
                    argBC.activateField("Data Type");
                    argBC.activateField("Type");
                    argBC.activateField("Optional");
                    argBC.executeQuery(true);
                    argBC.setSearchSpec("Inactive", "N");
                    boolean loop = argBC.firstRecord();
                    while (loop) {
                        String name = argBC.getFieldValue("Name");
                        String dataType = argBC.getFieldValue("Data Type");
                        String direction = argBC.getFieldValue("Type");
                        String optional = argBC.getFieldValue("Optional");
                        SiebelMethodParamBean param = new SiebelMethodParamBean();
                        param.setName(name);
                        param.setNativeDataType(dataType);
                        param.setDirection(direction);
                        param.setRequired("N".equals(optional));
                        list.add(param);
                        loop = argBC.nextRecord();
                    }
                    argBC.release();
                }
                busMethodBC.release();
            }
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("Exception while fetching  Method Parameter information for Business Method = " + methodName, e);
            }
        }
        finally {
            if (busServiceBC != null) {
                busServiceBC.release();
            }
            if (busServiceBO != null) {
                busServiceBO.release();
            }
        }
        return list;
    }

    @Override
    public SDBProcedure getProcedure(String busServiceName, String busMethodName) {
        return new SDBProcedureImpl(busServiceName, busMethodName, this);
    }

    protected void assertConnected() {
        if (this.mSDBSession == null) {
            throw new RuntimeException("Connection not established.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testConnection(String connectStr, String username, String password) {
        SiebelDataBean dataBean = null;
        try {
            dataBean = new SiebelDataBean();
            dataBean.login(connectStr, username, password);
        }
        catch (SiebelException e) {
            if (logger.isDebug()) {
                logger.debug("Exception while logging in.", e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block13: {
                try {
                    dataBean.logoff();
                }
                catch (SiebelException se) {
                    if (!logger.isDebug()) break block13;
                    logger.debug("Exception while logging off.", se);
                }
            }
        }
        return true;
    }
}

