/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel.tcp;

import com.ibm.bi.crypto.tunnel.tcp.ConnectionTerminationHandler;
import com.ibm.bi.crypto.tunnel.tcp.TcpObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpForwarder
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TcpForwarder.class);
    private final List<TcpObserver> observers;
    private final InputStream is;
    private final OutputStream os;
    private final int bufferSize;
    private final ConnectionTerminationHandler connectionTerminationHandler;
    private final String name;

    public TcpForwarder(String name, InputStream socket1Input, OutputStream socket2Output, ConnectionTerminationHandler connectionTerminationHandler, int forwardBufferSize, TcpObserver ... tcpObservers) {
        this.name = name;
        this.is = socket1Input;
        this.os = socket2Output;
        this.bufferSize = forwardBufferSize;
        this.observers = Arrays.asList(tcpObservers);
        this.connectionTerminationHandler = connectionTerminationHandler;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[this.bufferSize];
        try {
            while (true) {
                int bytesRead;
                if ((bytesRead = this.is.read(buffer)) == -1) {
                    LOG.info("THREAD {}: TCP tunnel half connection terminated {}", (Object)Thread.currentThread().getName(), (Object)this.name);
                    this.connectionTerminationHandler.terminateHalfConnection();
                    break;
                }
                if (this.observers != null) {
                    for (TcpObserver observer : this.observers) {
                        observer.observe(buffer, 0, bytesRead);
                    }
                }
                this.os.write(buffer, 0, bytesRead);
                this.os.flush();
            }
        }
        catch (IOException e) {
            LOG.info("THREAD {}: connection broken at {}", new Object[]{Thread.currentThread().getName(), this.name, e});
            this.connectionTerminationHandler.terminateConnection();
        }
    }
}

