/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel.tcp;

import com.ibm.bi.crypto.tunnel.Config;
import com.ibm.bi.crypto.tunnel.TlsCredentials;
import com.ibm.bi.crypto.tunnel.TunnelSessionParams;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TcpTunnelSessionParams
implements TunnelSessionParams {
    private final String remoteHostname;
    private final int remotePort;
    private final boolean enableMutualAuth;
    private final TlsCredentials tlsCredentials;
    private final long maxInactivityPeriod;

    public TcpTunnelSessionParams(String remoteHostname, int remotePort, boolean enableMutualAuth, TlsCredentials tlsCredentials) {
        this(remoteHostname, remotePort, enableMutualAuth, tlsCredentials, null);
    }

    public TcpTunnelSessionParams(String remoteHostname, int remotePort, boolean enableMutualAuth, TlsCredentials tlsCredentials, Long maxInactivityPeriod) {
        Objects.requireNonNull(remoteHostname, "remote hostname should not be null");
        Objects.requireNonNull(Integer.valueOf(remotePort), "remote port should not be null");
        Objects.requireNonNull(tlsCredentials, "TLS credentials should not be null");
        this.remoteHostname = remoteHostname;
        this.remotePort = remotePort;
        this.enableMutualAuth = enableMutualAuth;
        this.tlsCredentials = tlsCredentials;
        this.maxInactivityPeriod = maxInactivityPeriod == null ? Config.tcpTunnelSessionMaxInactivityPeriod.longValue() : maxInactivityPeriod.longValue();
    }

    @Override
    public String remoteHostname() {
        return this.remoteHostname;
    }

    @Override
    public int remotePort() {
        return this.remotePort;
    }

    @Override
    public boolean enableMutualAuth() {
        return this.enableMutualAuth;
    }

    @Override
    public TlsCredentials tlsCredentials() {
        return this.tlsCredentials;
    }

    @Override
    public long maxInactivityPeriod() {
        return this.maxInactivityPeriod;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TcpTunnelSessionParams rhs = (TcpTunnelSessionParams)obj;
        return new EqualsBuilder().append((Object)this.remoteHostname, (Object)rhs.remoteHostname).append(this.remotePort, rhs.remotePort).append(this.enableMutualAuth, rhs.enableMutualAuth).append((Object)this.tlsCredentials, (Object)rhs.tlsCredentials).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.remoteHostname).append(this.remotePort).append(this.enableMutualAuth).append((Object)this.tlsCredentials).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("remoteHostname", (Object)this.remoteHostname).append("remotePort", this.remotePort).append("enableMutualAuth", this.enableMutualAuth).append("tlsCredentials", this.tlsCredentials.hashCode()).toString();
    }
}

