/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.request;

import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.SForceException;
import com.ibm.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResult;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResultRecord;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.soap.axis2.SForceAxis2SOAPQueryResult;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceResultSet {
    private static ISForceQueryResult errorShutdownPill = new SForceAxis2SOAPQueryResult();
    private static final Logger logger;
    private boolean hasNext;
    private ISForceQueryResult currentBatch;
    private volatile BlockingQueue<ISForceQueryResult> queue;
    private long knownResultSetSize;
    private final SForceConnectionParams connectionParams;
    private Thread backGroundTask;
    private volatile Throwable childThreadException;
    private int cursorPosition;
    private volatile boolean closed;
    private boolean hasMultipleBatches;
    private boolean retreiveRemainingBatches;

    public SForceResultSet(ISForceQueryResult firstBatch, SForceConnectionParams connectionParams, boolean retreiveRemainingBatches) {
        this.connectionParams = connectionParams;
        this.currentBatch = firstBatch;
        this.childThreadException = null;
        this.knownResultSetSize = 0L;
        this.cursorPosition = 0;
        this.closed = false;
        this.retreiveRemainingBatches = retreiveRemainingBatches;
        this.hasNext = firstBatch.getSize() != 0L;
        this.queue = new LinkedBlockingQueue<ISForceQueryResult>();
        if (!firstBatch.isDone() && retreiveRemainingBatches) {
            this.initializeBackGroundThread();
            this.hasMultipleBatches = true;
        } else {
            this.backGroundTask = null;
            this.hasMultipleBatches = false;
        }
    }

    public SForceResultSet() {
        this.connectionParams = null;
        this.currentBatch = null;
        this.childThreadException = null;
        this.knownResultSetSize = 0L;
        this.cursorPosition = 0;
        this.closed = false;
        this.retreiveRemainingBatches = false;
        this.hasNext = false;
        this.backGroundTask = null;
        this.queue = new LinkedBlockingQueue<ISForceQueryResult>();
        this.hasMultipleBatches = false;
    }

    private void initializeBackGroundThread() {
        this.backGroundTask = new Thread(new SForceQueryMoreThread(this.currentBatch.getQueryLocator()));
        this.backGroundTask.start();
        if (logger.isDebugEnabled()) {
            logger.info("Started the background thread");
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public ISForceQueryResultRecord next() throws Throwable {
        if (this.isClosed()) {
            throw new SForceException(1900002, new Object[0]);
        }
        if (this.childThreadexceptionRaised()) {
            this.reThrowException(this.childThreadException);
        }
        if (!this.hasNext) {
            throw new SForceException(1900003, new Object[0]);
        }
        if ((long)this.cursorPosition == this.getCurrentBatchSize() && !this.currentBatch.isDone()) {
            try {
                ISForceQueryResult newData = this.queue.take();
                if (newData.equals(errorShutdownPill)) {
                    this.reThrowException(this.childThreadException);
                }
                this.knownResultSetSize += this.getCurrentBatchSize();
                this.currentBatch = newData;
                this.cursorPosition = 0;
            }
            catch (InterruptedException e) {
                this.reThrowException(null);
            }
        }
        if ((long)this.cursorPosition == this.getCurrentBatchSize() - 1L && this.currentBatch.isDone()) {
            this.hasNext = false;
        }
        ISForceQueryResultRecord currentRecord = this.currentBatch.getRecords(this.cursorPosition);
        this.currentBatch.setRecords(this.cursorPosition, null);
        ++this.cursorPosition;
        return currentRecord;
    }

    private boolean childThreadexceptionRaised() {
        return this.childThreadException != null;
    }

    private void reThrowException(Throwable ex) throws Throwable {
        this.close();
        if (ex != null) {
            throw ex;
        }
    }

    public long getCurrentPosition() {
        return this.knownResultSetSize + (long)this.cursorPosition;
    }

    protected void queueResultSet(ISForceQueryResult queryResult) throws InterruptedException {
        if (logger.isDebugEnabled()) {
            logger.info("queuing next result set");
        }
        this.queue.put(queryResult);
    }

    private long getCurrentBatchSize() {
        return this.currentBatch.getSize();
    }

    public void close() {
        this.hasNext = false;
        this.closed = true;
        if (logger.isDebugEnabled() && this.hasMultipleBatches) {
            logger.debug("background thread state " + (Object)((Object)this.backGroundTask.getState()));
        }
        if (this.hasMultipleBatches && this.backGroundTask.getState() != Thread.State.TERMINATED) {
            this.backGroundTask.interrupt();
            this.queue.clear();
        }
    }

    public void finalize() {
        if (logger.isDebugEnabled()) {
            logger.debug("SForceQueryResult garbage collected");
        }
        if (this.hasMultipleBatches) {
            if (logger.isDebugEnabled()) {
                logger.debug("Clearing the blocking queue");
            }
            this.queue.clear();
        }
    }

    public int getNoOfBatchesInQueue() {
        if (this.hasMultipleBatches) {
            return this.queue.size();
        }
        return 0;
    }

    public boolean isBackGroundThreadActive() {
        if (this.backGroundTask == null) {
            return false;
        }
        return !this.backGroundTask.isInterrupted() && this.backGroundTask.getState() != Thread.State.TERMINATED;
    }

    public boolean isClosed() {
        return this.closed;
    }

    static {
        errorShutdownPill.setDone(true);
        logger = LoggerFactory.getLogger(SForceResultSet.class);
    }

    private class SForceQueryMoreThread
    implements Runnable {
        private String queryLocator;

        private SForceQueryMoreThread(String startLocator) {
            this.queryLocator = startLocator;
        }

        @Override
        public void run() {
            String currentLocator = this.queryLocator;
            ISForceQueryResult queryResult = null;
            try {
                do {
                    queryResult = SForceRequestManager.getInstance().queryMore(SForceResultSet.this.connectionParams, currentLocator);
                    currentLocator = queryResult.getQueryLocator();
                    SForceResultSet.this.queueResultSet(queryResult);
                } while (!queryResult.isDone() && !Thread.currentThread().isInterrupted() && !SForceResultSet.this.closed);
                if (logger.isDebugEnabled()) {
                    logger.debug("SforceQueryMore thread exiting task done");
                }
            }
            catch (InterruptedException ie) {
                if (!SForceResultSet.this.isClosed()) {
                    this.handleException(new SForceException(1900004, new Object[0]));
                } else if (logger.isDebugEnabled()) {
                    logger.debug("SforceQueryMore thread interrupted");
                }
            }
            catch (Throwable ex) {
                this.handleException(ex);
            }
        }

        private void handleException(Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug("SforceQueryMore thread interrupted by an external entity.", e);
            }
            SForceResultSet.this.childThreadException = e;
            try {
                SForceResultSet.this.queueResultSet(errorShutdownPill);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

