/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.request.session;

import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.provider.ISForceProvider;
import com.ibm.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceCredentials;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceTrackingSession;
import com.sforce.ws.ConnectionException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SForceSessionManager.class);
    private static Map<String, SForceSessionKey> sessionMap = new HashMap<String, SForceSessionKey>();
    private static ReadWriteLock globalSessionLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISForceSession getSession(SForceConnectionParams connectionParams, ISForceProvider provider) throws SForceAPIException {
        if (logger.isDebugEnabled()) {
            logger.debug("retrieving session for " + connectionParams.toString());
        }
        SForceSessionKey sessionKey = null;
        SForceCredentials sforceCreds = new SForceCredentials(connectionParams, provider);
        if (sforceCreds.isSSO()) {
            sessionKey = sforceCreds.getSessionKey();
        } else {
            Lock readLock = globalSessionLock.readLock();
            try {
                readLock.lock();
                sessionKey = sessionMap.get(connectionParams.getKey());
                if (sessionKey == null) {
                    boolean restFlag = connectionParams.isRestEnabled();
                    SForceConnectionParams newParams = connectionParams.getCopy();
                    newParams.setRestEnabled(!restFlag);
                    sessionKey = sessionMap.get(newParams.getKey());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Trying to reuse session for connection " + connectionParams.toString());
                }
            }
            finally {
                readLock.unlock();
            }
            if (sessionKey == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating new session for connection " + connectionParams.toString());
                }
                Lock writeLock = globalSessionLock.writeLock();
                try {
                    writeLock.lock();
                    if (!sessionMap.containsKey(connectionParams.getKey())) {
                        sessionKey = sforceCreds.getSessionKey();
                        sessionMap.put(connectionParams.getKey(), sessionKey);
                    } else {
                        sessionKey = sessionMap.get(connectionParams.getKey());
                    }
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
        ISForceSession sforceSession = null;
        try {
            sforceSession = provider.createSession(connectionParams, sessionKey);
        }
        catch (ConnectionException e) {
            throw new SForceAPIException(e.getMessage());
        }
        return new SForceTrackingSession(sforceSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateSession(SForceConnectionParams connectionParameters, SForceSessionKey sessionKey) {
        Lock writeLock = globalSessionLock.writeLock();
        if (logger.isDebugEnabled()) {
            logger.debug("Trying to invalidate session for connection " + connectionParameters.toString());
        }
        try {
            writeLock.lock();
            SForceSessionKey currentSessionKey = sessionMap.get(connectionParameters.getKey());
            if (currentSessionKey != null && currentSessionKey.equals(sessionKey)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Invalidating session for connection " + connectionParameters.toString());
                }
                sessionMap.remove(connectionParameters.getKey());
            } else if (logger.isDebugEnabled()) {
                logger.debug("Session already invalidated by a separate thread " + connectionParameters.toString());
            }
        }
        finally {
            writeLock.unlock();
        }
    }
}

