/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.request.session.soap.axis2;

import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceChildRelationShipInfo;
import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTable;
import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableInfo;
import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectorConfig;
import com.ibm.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResult;
import com.ibm.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.ibm.cognos.jdbc.sfdc.util.DataType;
import com.ibm.cognos.jdbc.sfdc.util.MetadataUtils;
import com.sforce.soap.partner.ChildRelationship;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.SessionHeader_element;
import com.sforce.soap.partner.fault.InvalidSObjectFault;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.util.HashMap;

public class SForceAxis2SOAPAPISession
implements ISForceSession {
    private PartnerConnection connection = null;
    private final SForceConnectionParams connectionParams;
    private final SForceSessionKey sessionKey;

    public SForceAxis2SOAPAPISession(SForceConnectionParams connectionParams, SForceSessionKey sessionKey) {
        this.connectionParams = connectionParams;
        this.sessionKey = sessionKey;
    }

    @Override
    public int getConcurrentCallsLimit() {
        return this.connectionParams.getConcurrentCallsLimit();
    }

    @Override
    public int getUserConcurrentCallsLimit() {
        return this.connectionParams.getUserConcurrentCallsLimit();
    }

    @Override
    public String getConnectionKey() {
        return this.sessionKey.getConnectionKey();
    }

    @Override
    public String getOrganizationKey() {
        return this.sessionKey.getOrganizationId() + ":" + this.connectionParams.getDataSourceId();
    }

    @Override
    public SForceSessionKey getSessionkey() {
        return this.sessionKey;
    }

    private SessionHeader_element getSessionHeader(String sessionId) {
        SessionHeader_element headerDoc = new SessionHeader_element();
        headerDoc.setSessionId(sessionId);
        return headerDoc;
    }

    @Override
    public SForceTable[] getTables() throws SForceAPIException, ConnectionException {
        try {
            DescribeGlobalResult globalRes = this.getConnection().describeGlobal();
            DescribeGlobalSObjectResult[] sobjs = globalRes.getSobjects();
            SForceTable[] tables = new SForceTable[sobjs.length];
            for (int i = 0; i < sobjs.length; ++i) {
                tables[i] = new SForceTable(sobjs[i].getName(), sobjs[i].getQueryable());
            }
            return tables;
        }
        catch (UnexpectedErrorFault e) {
            throw new SForceAPIException(e.getExceptionMessage());
        }
    }

    @Override
    public SForceTableInfo getTableMetadata(String objectName) throws SForceAPIException, ConnectionException {
        try {
            DescribeSObjectResult res = this.getConnection().describeSObject(objectName);
            return this.createTableColumnResult(res);
        }
        catch (InvalidSObjectFault e) {
            throw new SForceAPIException(e);
        }
        catch (UnexpectedErrorFault e) {
            throw new SForceAPIException(e.getExceptionMessage());
        }
    }

    @Override
    public HashMap<String, SForceTableInfo> getTablesMetadata(String[] objectNames) throws SForceAPIException, ConnectionException {
        try {
            DescribeSObjectResult[] descSobjsResult = this.getConnection().describeSObjects(objectNames);
            return this.createMultipleTableColumnResult(descSobjsResult);
        }
        catch (UnexpectedErrorFault ue) {
            throw new SForceAPIException(ue.getExceptionMessage());
        }
        catch (InvalidSObjectFault e) {
            throw new SForceAPIException(e);
        }
    }

    private HashMap<String, SForceTableInfo> createMultipleTableColumnResult(DescribeSObjectResult[] descSobjsResult) {
        HashMap<String, SForceTableInfo> multipleTabColResult = new HashMap<String, SForceTableInfo>();
        for (DescribeSObjectResult sobjResult : descSobjsResult) {
            multipleTabColResult.put(sobjResult.getName(), this.createTableColumnResult(sobjResult));
        }
        return multipleTabColResult;
    }

    private SForceTableInfo createTableColumnResult(DescribeSObjectResult sobjResult) {
        Field[] fields = sobjResult.getFields();
        SForceTableColumn[] columns = new SForceTableColumn[fields.length];
        for (int index = 0; index < columns.length; ++index) {
            columns[index] = new SForceTableColumn(fields[index].getName(), sobjResult.getName(), fields[index].getType(), DataType.fromValue(MetadataUtils.inferDataTypeName(fields[index].getType(), this.connectionParams.bindDatetimeWithTimestamp())), fields[index].getNillable(), fields[index].getIdLookup(), fields[index].getReferenceTo(), fields[index].getRelationshipName(), fields[index].getLength(), fields[index].getDigits(), fields[index].getPrecision(), fields[index].getScale(), fields[index].isGroupable());
        }
        return new SForceTableInfo(sobjResult.getName(), columns, this.getChildRelationshipInfo(sobjResult));
    }

    private SForceChildRelationShipInfo[] getChildRelationshipInfo(DescribeSObjectResult sobjResult) {
        ChildRelationship[] rels = sobjResult.getChildRelationships();
        SForceChildRelationShipInfo[] childInfo = null;
        if (rels != null) {
            childInfo = new SForceChildRelationShipInfo[rels.length];
            int index = 0;
            for (ChildRelationship rel : rels) {
                SForceChildRelationShipInfo info;
                childInfo[index] = info = new SForceChildRelationShipInfo(rel.getChildSObject(), rel.getDeprecatedAndHidden(), rel.getField(), rel.getRelationshipName());
                ++index;
            }
        }
        return childInfo;
    }

    @Override
    public ISForceQueryResult queryMore(String queryLocator) throws SForceAPIException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SForceResultSet query(String sql, boolean retrieveAllBatches) throws SForceAPIException {
        throw new UnsupportedOperationException();
    }

    private PartnerConnection getConnection() throws SForceAPIException {
        if (this.connection == null) {
            SForceConnectorConfig config = new SForceConnectorConfig(this.connectionParams, this.getSessionkey().getSessionServerURL(), this.getSessionkey().getSessionID());
            try {
                this.connection = Connector.newConnection((ConnectorConfig)config.getConfig());
            }
            catch (ConnectionException e) {
                throw new SForceAPIException(e);
            }
        }
        return this.connection;
    }
}

