/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.soql.cursors;

import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.SForceException;
import com.ibm.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.ibm.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResultRecord;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.ISForceColumnValue;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.ISForceRecord;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.ISForceSOQLQuery;

public abstract class SForceSOQLCursor {
    protected ISForceSOQLQuery query;
    private SForceResultSet queryResult;
    protected SForceConnectionParams connectionParams;
    private volatile boolean closed = Boolean.FALSE;
    private SForceTableRecordCursor currentCursor;

    protected SForceSOQLCursor(SForceConnectionParams connectionParams, ISForceSOQLQuery query) {
        this.connectionParams = connectionParams;
        this.query = query;
        this.queryResult = SForceRequestManager.getInstance().query(this.connectionParams, this.query.getSOQL(), true);
        if (this.isClosed()) {
            this.queryResult.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ISForceColumnValue[] next() {
        try {
            if (this.currentCursor == null || !this.currentCursor.hasNext()) {
                this.currentCursor = this.getNextCursor();
            }
            if (this.currentCursor != null && this.currentCursor.hasNext()) {
                return this.currentCursor.next();
            }
        }
        catch (Throwable t) {
            SForceException.rethrow(t);
        }
        return null;
    }

    private SForceTableRecordCursor getNextCursor() throws Throwable {
        if (!this.queryResult.hasNext()) {
            return null;
        }
        ISForceQueryResultRecord record = this.queryResult.next();
        ISForceRecord tableRecord = this.query.getTableRecord();
        tableRecord.initialize(1);
        this.processRecord(record, this.query, this.query.getOuterTableName(), tableRecord);
        return new SForceTableRecordCursor(tableRecord);
    }

    protected abstract void processRecord(ISForceQueryResultRecord var1, ISForceSOQLQuery var2, String var3, ISForceRecord var4);

    public void close() {
        if (this.queryResult != null) {
            this.queryResult.close();
        }
    }

    private class SForceTableRecordCursor {
        private ISForceRecord record;
        int recordSize = 0;
        int currentPosition = 0;

        SForceTableRecordCursor(ISForceRecord record) {
            this.record = record;
            this.recordSize = record.getSize();
        }

        public boolean hasNext() {
            return this.currentPosition < this.recordSize;
        }

        public ISForceColumnValue[] next() {
            return this.record.getRecord(this.currentPosition++);
        }
    }
}

