/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.soql.parsers;

import com.ibm.cognos.cdms.ds.sforce.soql.parsers.ParseException;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.SOQLParserConstants;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.SOQLParserTokenManager;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.SimpleCharStream;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class SOQLParser
implements SOQLParserConstants {
    private int paranthesisCounter = 0;
    private boolean stopFlag = false;
    private String currentTableName = null;
    private static final String SEPARATOR = " ";
    private int nestedQueryCount = 0;
    private int selectNo = 0;
    private ArrayList<String> columnList = new ArrayList();
    private ArrayList<Integer> selectStartPositions = new ArrayList();
    private ArrayList<String> innerTablesList = new ArrayList();
    public SOQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[42];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public SOQLParser(String s) {
        this(new StringReader(s));
    }

    public static void main(String[] args) {
        try {
            String query = args[0];
            if (query == null || query.length() == 0) {
                query = "SELECT a,func(b) funcalias from c";
            }
            System.out.println(query);
            SOQLParser parser = new SOQLParser(query);
            parser.parse();
            System.out.println(parser.getColumnsList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getColumnsList() {
        return this.columnList;
    }

    public ArrayList<String> getInnerTableList() {
        return this.innerTablesList;
    }

    private void selectStart() {
        this.selectStartPositions.add(this.selectNo, this.columnList.size());
        ++this.selectNo;
    }

    private void selectEnd() {
        --this.selectNo;
    }

    private void addTableNameToColumns(String tableName) {
        int startIndex = this.selectStartPositions.get(this.selectNo - 1);
        int columnListSize = this.columnList.size();
        for (int i = startIndex; i < columnListSize; ++i) {
            String currentName = this.columnList.get(i);
            if (SOQLParser.containsTableName(currentName, tableName)) continue;
            this.columnList.remove(i);
            this.columnList.add(i, tableName + "." + currentName);
        }
        if (this.selectNo == 1) {
            int tableSize = this.innerTablesList.size();
            for (int index = 0; index < tableSize; ++index) {
                String current = this.innerTablesList.get(index);
                if (SOQLParser.containsTableName(current, tableName)) continue;
                this.innerTablesList.remove(index);
                this.innerTablesList.add(index, tableName + "." + current);
            }
        }
        this.innerTablesList.add(tableName);
    }

    private void removeAliasNameFromColumns(String aliasName) {
        String fullName = this.currentTableName + "." + aliasName;
        int startIndex = this.selectStartPositions.get(this.selectNo - 1);
        int columnListSize = this.columnList.size();
        for (int i = startIndex; i < columnListSize; ++i) {
            String currentName = this.columnList.get(i);
            if (currentName.indexOf(fullName) != 0) continue;
            this.columnList.remove(i);
            this.columnList.add(i, currentName.replaceFirst(fullName, this.currentTableName));
        }
        if (this.selectNo == 1) {
            int tableSize = this.innerTablesList.size();
            for (int index = 0; index < tableSize; ++index) {
                String current = this.innerTablesList.get(index);
                if (current.indexOf(fullName) != 0) continue;
                this.innerTablesList.remove(index);
                this.innerTablesList.add(index, current.replaceFirst(fullName, this.currentTableName));
            }
        }
    }

    private static boolean containsTableName(String token, String tableName) {
        return token.trim().toLowerCase().indexOf(tableName.toLowerCase() + ".") == 0;
    }

    public final void parse() throws ParseException {
        this.expression();
        this.jj_consume_token(0);
    }

    public final void expression() throws ParseException {
        this.selectStart();
        this.jj_consume_token(5);
        this.columnsexpr();
        this.jj_consume_token(7);
        this.tableExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                this.whereClause();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        if (this.stopFlag) {
            int kind = this.jj_ntk();
            while (kind != 0) {
                this.jj_consume_token(kind);
                kind = this.jj_ntk();
            }
            return;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.groupByexpr();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.havingExpr();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.orderByexpr();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.limitExpr();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.selectEnd();
    }

    public final void nestedQuery() throws ParseException {
        ++this.nestedQueryCount;
        this.jj_consume_token(5);
        this.columnsexpr();
        this.jj_consume_token(7);
        this.tableExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                this.whereClause();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        --this.nestedQueryCount;
    }

    public final void subQuery() throws ParseException {
        this.selectStart();
        this.jj_consume_token(5);
        this.columnsexpr();
        this.jj_consume_token(7);
        this.tableExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                this.whereClause();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.selectEnd();
    }

    public final void columnsexpr() throws ParseException {
        block12: {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: 
                case 49: {
                    this.columnexpr();
                    break;
                }
                case 8: {
                    this.jj_consume_token(8);
                    this.subQuery();
                    this.jj_consume_token(9);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(17);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: 
                    case 49: {
                        this.columnexpr();
                        continue block11;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        this.subQuery();
                        this.jj_consume_token(9);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void funcexpr() throws ParseException {
        this.funcname();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.funcalias();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
    }

    public final void funcname() throws ParseException {
        Token tcomparand = this.jj_consume_token(49);
        if (this.nestedQueryCount == 0) {
            this.columnList.add(tcomparand.image);
        }
    }

    public final void funcalias() throws ParseException {
        Token tcomparand = this.jj_consume_token(37);
        if (this.nestedQueryCount == 0 && tcomparand != null) {
            int latestColIndex = this.columnList.size();
            String colName = this.columnList.get(latestColIndex - 1);
            this.columnList.remove(latestColIndex - 1);
            this.columnList.add(colName + SEPARATOR + tcomparand.image);
        }
    }

    public final void columnexpr() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.simplecolumn();
                break;
            }
            case 49: {
                this.funcexpr();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void simplecolumn() throws ParseException {
        this.simplecolumnname();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.simplecolumnalias();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
    }

    public final void simplecolumnname() throws ParseException {
        Token tcomparand = this.jj_consume_token(37);
        if (this.nestedQueryCount == 0) {
            this.columnList.add(tcomparand.image);
        }
    }

    public final void simplecolumnalias() throws ParseException {
        Token tcomparand = this.jj_consume_token(37);
        if (this.nestedQueryCount == 0 && tcomparand != null) {
            int latestColIndex = this.columnList.size();
            String colName = this.columnList.get(latestColIndex - 1);
            this.columnList.remove(latestColIndex - 1);
            this.columnList.add(colName + SEPARATOR + tcomparand.image);
        }
    }

    public final void tableExpr() throws ParseException {
        this.tableName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.tableAlias();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
    }

    public final void tableAlias() throws ParseException {
        Token tcomparand = this.jj_consume_token(37);
        if (this.nestedQueryCount == 0 && tcomparand.image != null) {
            this.removeAliasNameFromColumns(tcomparand.image);
        }
    }

    public final void tableName() throws ParseException {
        Token tcomparand = this.jj_consume_token(37);
        if (this.nestedQueryCount == 0) {
            this.currentTableName = tcomparand.image;
            this.addTableNameToColumns(tcomparand.image);
        }
    }

    public final void whereClause() throws ParseException {
        if (this.selectNo == 1) {
            this.stopFlag = true;
            return;
        }
        this.paranthesisCounter = 0;
        ++this.paranthesisCounter;
        while (true) {
            int kind;
            if ((kind = this.jj_ntk()) == 8) {
                ++this.paranthesisCounter;
            } else if (kind == 9) {
                --this.paranthesisCounter;
                if (this.paranthesisCounter == 0) {
                    return;
                }
            }
            this.jj_consume_token(kind);
        }
    }

    public final void sforceORExpression() throws ParseException {
        block8: {
            this.jj_consume_token(24);
            this.jj_consume_token(8);
            this.sforceexpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: 
                    case 24: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.sforceORExpression();
                        continue block7;
                    }
                    case 23: {
                        this.sforceANDExpression();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[17] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(9);
    }

    public final void sforceANDExpression() throws ParseException {
        block8: {
            this.jj_consume_token(23);
            this.jj_consume_token(8);
            this.sforceexpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: 
                    case 24: {
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.sforceORExpression();
                        continue block7;
                    }
                    case 23: {
                        this.sforceANDExpression();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[19] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(9);
    }

    public final void sforceexpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                this.sforceComparisonExpression();
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                this.sforceInExpression();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void sforceComparisonExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                this.nestedQuery();
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void sforceInExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(8);
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                this.jj_consume_token(39);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: {
                            break;
                        }
                        default: {
                            this.jj_la1[25] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(17);
                    this.jj_consume_token(39);
                }
            }
            case 5: {
                this.nestedQuery();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(9);
    }

    public final void orderByexpr() throws ParseException {
        this.jj_consume_token(27);
        this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 36: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        this.jj_consume_token(35);
                        break block4;
                    }
                    case 36: {
                        this.jj_consume_token(36);
                        break block4;
                    }
                }
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        break block11;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        break block11;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        block39: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block39;
                }
            }
            this.jj_consume_token(17);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: {
                    this.jj_consume_token(37);
                    break;
                }
                case 49: {
                    this.jj_consume_token(49);
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block25 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: 
                case 36: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            this.jj_consume_token(35);
                            break block25;
                        }
                        case 36: {
                            this.jj_consume_token(36);
                            break block25;
                        }
                    }
                    this.jj_la1[34] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: {
                    this.jj_consume_token(28);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            this.jj_consume_token(29);
                            continue block39;
                        }
                        case 30: {
                            this.jj_consume_token(30);
                            continue block39;
                        }
                    }
                    this.jj_la1[36] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_la1[37] = this.jj_gen;
        }
    }

    public final void groupByexpr() throws ParseException {
        this.jj_consume_token(26);
        this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(17);
            this.jj_consume_token(37);
        }
    }

    public final void havingExpr() throws ParseException {
        this.jj_consume_token(32);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(39);
    }

    public final void limitExpr() throws ParseException {
        this.jj_consume_token(31);
        this.jj_consume_token(39);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{64, 0x4000000, 0, 0x8000000, Integer.MIN_VALUE, 64, 64, 256, 131072, 256, 0, 0, 0, 0, 0x1800000, 0x1800000, 0x1800000, 0x1800000, 0x1800000, 0x1800000, 0, 8256512, 1178624, 256, 0x6C0000, 131072, 32, 0, 0, 0, 0x60000000, 0x10000000, 131072, 0, 0, 0, 0x60000000, 0x10000000, 0, 131072, 0, 130048};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 1, 0, 0, 0, 0, 131104, 0, 131104, 32, 131104, 32, 32, 0, 0, 0, 0, 0, 0, 131104, 0, 0, 164, 0, 0, 128, 131104, 24, 24, 0, 0, 0, 131104, 24, 24, 0, 0, 131104, 0, 131104, 0};
    }

    public SOQLParser(InputStream stream) {
        this(stream, null);
    }

    public SOQLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SOQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 42; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 42; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SOQLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SOQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 42; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 42; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SOQLParser(SOQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 42; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SOQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 42; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[57];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 42; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 57; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SOQLParser.jj_la1_init_0();
        SOQLParser.jj_la1_init_1();
    }
}

