/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc;

import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableInfo;
import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.SForceException;
import com.ibm.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.ibm.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.ParseException;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.SOQLParser;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.TokenMgrError;
import com.ibm.cognos.jdbc.sfdc.QueryResult;
import com.ibm.cognos.jdbc.sfdc.QueryStatus;
import com.ibm.cognos.jdbc.sfdc.SFDCConnection;
import com.ibm.cognos.jdbc.sfdc.SFDCResultSet;
import com.ibm.cognos.jdbc.sfdc.SFDCResultSetMetaData;
import com.ibm.cognos.jdbc.sfdc.SFDCStatement;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageKeys;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageUtil;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLErrorCode;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLState;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

class QueryExecutor
implements SFDCMessageKeys {
    static Pattern groupByPattern = Pattern.compile("(.*)([G|g][R|r][O|o][U|u][P|p])(.*)([B|b][Y|y])(.*)");
    private final AtomicBoolean closed = new AtomicBoolean();

    QueryExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    QueryResult executeQuery(String queryId, String connectionId, String sql, SFDCStatement statement, SForceConnectionParams sfdcConnParams) {
        QueryStatus queryStatus = new QueryStatus(queryId);
        if (this.closed.get()) {
            queryStatus.start();
            queryStatus.fail(new SQLException(SFDCMessageUtil.getMessage("0042"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_EXECUTOR_CLOSED.getErrorCode()));
            return new QueryResult(queryStatus, null, null);
        }
        SQLException validationException = this.validateQueryExecute(queryId, connectionId, sql, statement, sfdcConnParams);
        if (null != validationException) {
            queryStatus.start();
            queryStatus.fail(validationException);
            return new QueryResult(queryStatus, null, null);
        }
        SFDCResultSet result = null;
        SFDCResultSetMetaData resultSetMetaData = null;
        try {
            String column;
            boolean allColumnBounded;
            queryStatus.start();
            SOQLParser parser = new SOQLParser(sql);
            parser.parse();
            ArrayList<String> columnList = parser.getColumnsList();
            ArrayList<String> tableList = parser.getInnerTableList();
            if (tableList.isEmpty() || 1 < tableList.size()) {
                throw new IllegalStateException(SFDCMessageUtil.getMessage("0086", 1, tableList.size()));
            }
            SForceConnectionParams params = ((SFDCConnection)statement.getConnection()).getConnectionParams();
            SForceTableInfo tableInfo = SForceRequestManager.getInstance().describeSObject(params, tableList.get(0));
            ArrayList<SForceTableColumn> columns = new ArrayList<SForceTableColumn>();
            Iterator<String> iterator = columnList.iterator();
            block8: do {
                int n;
                SForceTableColumn[] sForceTableColumnArray;
                String columnName;
                if (iterator.hasNext()) {
                    SForceTableColumn[] fields;
                    column = iterator.next();
                    allColumnBounded = false;
                    columnName = column.substring(column.indexOf(".") + 1, column.length());
                    sForceTableColumnArray = fields = tableInfo.getFields();
                    n = sForceTableColumnArray.length;
                } else {
                    resultSetMetaData = new SFDCResultSetMetaData(columns);
                    boolean retrieveAllBatches = true;
                    if (groupByPattern.matcher(sql).matches()) {
                        retrieveAllBatches = false;
                    }
                    SForceResultSet sForceResult = SForceRequestManager.getInstance().query(params, sql, retrieveAllBatches);
                    result = new SFDCResultSet((Statement)statement, sForceResult, resultSetMetaData);
                    queryStatus.complete();
                    return new QueryResult(queryStatus, result, resultSetMetaData);
                }
                for (int i = 0; i < n; ++i) {
                    SForceTableColumn field = sForceTableColumnArray[i];
                    if (!columnName.equals(field.getName())) continue;
                    columns.add(field);
                    allColumnBounded = true;
                    continue block8;
                }
            } while (allColumnBounded);
            throw new IllegalStateException(SFDCMessageUtil.getMessage("0017", 1, column));
        }
        catch (TokenMgrError e) {
            if (!queryStatus.isPendingOrRunning()) return new QueryResult(queryStatus, null, null);
            queryStatus.fail(new SQLException(SFDCMessageUtil.getMessage("0072"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode(), e));
            return new QueryResult(queryStatus, null, null);
        }
        catch (ParseException e) {
            if (!queryStatus.isPendingOrRunning()) return new QueryResult(queryStatus, null, null);
            queryStatus.fail(new SQLException(SFDCMessageUtil.getMessage("0072"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode(), e));
            return new QueryResult(queryStatus, null, null);
        }
        catch (SForceException e) {
            if (!queryStatus.isPendingOrRunning()) return new QueryResult(queryStatus, null, null);
            queryStatus.fail(new SQLException(SFDCMessageUtil.getMessage("0048"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode(), e));
            return new QueryResult(queryStatus, null, null);
        }
        catch (RuntimeException e) {
            if (!queryStatus.isPendingOrRunning()) return new QueryResult(queryStatus, null, null);
            queryStatus.fail(new SQLException(SFDCMessageUtil.getMessage("0045"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode(), e));
            return new QueryResult(queryStatus, null, null);
        }
        catch (Exception e) {
            if (!queryStatus.isPendingOrRunning()) return new QueryResult(queryStatus, null, null);
            queryStatus.fail(new SQLException(SFDCMessageUtil.getMessage("0048"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.QUERY_ERROR.getErrorCode(), e));
            return new QueryResult(queryStatus, null, null);
        }
    }

    void cancelQuery(String queryId) throws SQLException {
    }

    void close() {
        if (this.closed.compareAndSet(false, true)) {
            // empty if block
        }
    }

    private SQLException validateQueryExecute(String queryId, String connectionId, String sql, SFDCStatement statement, SForceConnectionParams sfdcConnParams) {
        if (null == queryId) {
            return new SQLException(SFDCMessageUtil.getMessage("0007", "queryId"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.NULL_QUERY_ID.getErrorCode());
        }
        if (null == connectionId) {
            return new SQLException(SFDCMessageUtil.getMessage("0007", "connectionId"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.NULL_CONNECTION_ID.getErrorCode());
        }
        if (null == sql) {
            return new SQLException(SFDCMessageUtil.getMessage("0007", "SQL query"), SFDCSQLState.INVALID_SQL.getState(), SFDCSQLErrorCode.NULL_SQL_STATEMENT.getErrorCode());
        }
        if (null == statement) {
            return new SQLException(SFDCMessageUtil.getMessage("0007", "statement"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.NULL_STATEMENT.getErrorCode());
        }
        if (null == sfdcConnParams) {
            return new SQLException(SFDCMessageUtil.getMessage("0007", "sfdcConnParams"), SFDCSQLState.TRANSACTION_STATE.getState(), SFDCSQLErrorCode.NULL_CONNECTION_STRING.getErrorCode());
        }
        return null;
    }
}

