/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc;

import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.provider.ISForceProvider;
import com.ibm.cognos.cdms.ds.sforce.request.provider.SForceProviderManager;
import com.ibm.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceSessionManager;
import com.ibm.cognos.jdbc.sfdc.QueryExecutor;
import com.ibm.cognos.jdbc.sfdc.QueryResult;
import com.ibm.cognos.jdbc.sfdc.SFDCDatabaseMetaData;
import com.ibm.cognos.jdbc.sfdc.SFDCPreparedStatement;
import com.ibm.cognos.jdbc.sfdc.SFDCStatement;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageKeys;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageUtil;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLErrorCode;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLState;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class SFDCConnection
implements Connection,
SFDCMessageKeys {
    private static final String PREPARE_CALL = "prepareCall";
    private static final String PREPARED_STATEMENT = "preparedStatement";
    private static final String PASSWORD = "password";
    private static final String SLASH_STR = "/";
    private SFDCDatabaseMetaData mDatabaseMetaData = null;
    private SForceConnectionParams mParams = null;
    private final AtomicBoolean closed;
    private final String connectionUUID;
    private final QueryExecutor executor;

    public SFDCConnection(SForceConnectionParams params, QueryExecutor queryExecutor) {
        this.mParams = params;
        this.closed = new AtomicBoolean(false);
        this.connectionUUID = UUID.randomUUID().toString();
        this.executor = queryExecutor;
        this.mDatabaseMetaData = new SFDCDatabaseMetaData(params, this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(SFDCMessageUtil.getMessage("0009", iface), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.INVALID_UNWRAP.getErrorCode());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return new SFDCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return new SFDCPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw SFDCConnection.notSupported(PREPARE_CALL);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw SFDCConnection.notSupported("setAutoCommit");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        throw SFDCConnection.notSupported("commit");
    }

    @Override
    public void rollback() throws SQLException {
        throw SFDCConnection.notSupported("rollback");
    }

    @Override
    public void close() throws SQLException {
        ISForceProvider provider = SForceProviderManager.getInstance().getMetadataProvider();
        try {
            ISForceSession session = SForceSessionManager.getSession(this.mParams, provider);
            SForceSessionKey sessionKey = session.getSessionkey();
            SForceSessionManager.invalidateSession(this.mParams, sessionKey);
            this.closed.compareAndSet(false, true);
        }
        catch (SForceAPIException e) {
            throw new SQLException(SFDCMessageUtil.getMessage("0048", e.getMessage()));
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.mDatabaseMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw SFDCConnection.notSupported("setReadOnly");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw SFDCConnection.notSupported("setCatalog");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw SFDCConnection.notSupported("setTransactionIsolation");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        return new SFDCStatement(this);
    }

    private void checkResultSetConcurrency(int resultSetConcurrency) throws SQLException {
        if (1007 != resultSetConcurrency) {
            throw new SQLException(SFDCMessageUtil.getMessage("0006", 1007, resultSetConcurrency), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.INVALID_CONCURRENCY.getErrorCode());
        }
    }

    private void checkResultSetType(int resultSetType) throws SQLException {
        if (1003 != resultSetType) {
            throw new SQLException(SFDCMessageUtil.getMessage("0005", 1003, resultSetType), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.INVALID_RESULTSET_TYPE.getErrorCode());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        return new SFDCPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw SFDCConnection.notSupported(PREPARE_CALL);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw SFDCConnection.notSupported("getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw SFDCConnection.notSupported("setTypeMap");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw SFDCConnection.notSupported("setHoldability");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw SFDCConnection.notSupported("getHoldability");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw SFDCConnection.notSupported("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw SFDCConnection.notSupported("setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw SFDCConnection.notSupported("rollback Savepoint");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw SFDCConnection.notSupported("releaseSavePoint");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        if (2 != resultSetHoldability) {
            throw new SQLException(SFDCMessageUtil.getMessage("0004", 2, resultSetHoldability), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.UNSUPPORTED_CURSOR_COMMIT.getErrorCode());
        }
        return new SFDCStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        if (2 != resultSetHoldability) {
            throw new SQLException(SFDCMessageUtil.getMessage("0004", 2, resultSetHoldability), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.UNSUPPORTED_CURSOR_COMMIT.getErrorCode());
        }
        return new SFDCPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw SFDCConnection.notSupported(PREPARE_CALL);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw SFDCConnection.notSupported(PREPARED_STATEMENT);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw SFDCConnection.notSupported(PREPARED_STATEMENT);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw SFDCConnection.notSupported(PREPARED_STATEMENT);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw SFDCConnection.notSupported("createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw SFDCConnection.notSupported("createBlob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SFDCConnection.notSupported("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SFDCConnection.notSupported("createSQLXML");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException(SFDCMessageUtil.getMessage("0002"), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.NEGATIVE_VALUE_NOT_ALLOWED.getErrorCode());
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SFDCConnection.notSupported("createArrayOf");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SFDCConnection.notSupported("createStruct");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw SFDCConnection.notSupported("setSchema");
    }

    @Override
    public String getSchema() throws SQLException {
        throw SFDCConnection.notSupported("getSchema");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
        if (milliseconds < 0) {
            throw new SQLException(SFDCMessageUtil.getMessage("0002"), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.NEGATIVE_VALUE_NOT_ALLOWED.getErrorCode());
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw SFDCConnection.notSupported("getNetworkTimeout");
    }

    String getConnectionUUID() {
        return this.connectionUUID;
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(SFDCMessageUtil.getMessage("0001"), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.STATEMENT_CLOSED.getErrorCode());
        }
    }

    private static SQLFeatureNotSupportedException notSupported(String s) {
        return new SQLFeatureNotSupportedException(SFDCMessageUtil.getMessage("0003", s), SFDCSQLState.FEATURE_NOT_SUPPORTED.getState(), SFDCSQLErrorCode.JDBC_FEATURE_NOT_SUPPORTED.getErrorCode());
    }

    public SForceConnectionParams getConnectionParams() {
        return this.mParams;
    }

    QueryResult executeQuery(String queryId, String sql, SFDCStatement statement) {
        return this.executor.executeQuery(queryId, this.connectionUUID, sql, statement, this.mParams);
    }

    void cancelQuery(String queryId) throws SQLException {
        this.executor.cancelQuery(queryId);
    }
}

