/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc;

import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceChildRelationShipInfo;
import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTable;
import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableInfo;
import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.SForceException;
import com.ibm.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.ibm.cognos.jdbc.sfdc.EOFRow;
import com.ibm.cognos.jdbc.sfdc.Row;
import com.ibm.cognos.jdbc.sfdc.SFDCConnection;
import com.ibm.cognos.jdbc.sfdc.SFDCDriver;
import com.ibm.cognos.jdbc.sfdc.SFDCResultSet;
import com.ibm.cognos.jdbc.sfdc.SFDCResultSetMetaData;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageKeys;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageUtil;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLErrorCode;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLState;
import com.ibm.cognos.jdbc.sfdc.util.DataType;
import com.ibm.cognos.jdbc.sfdc.util.MetadataUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SFDCDatabaseMetaData
implements DatabaseMetaData,
SFDCMessageKeys {
    static final int DATABASE_VERSION_MAJOR = 1;
    static final int DATABASE_VERSION_MINOR = 0;
    public static final String EMPTY_STR = "";
    static final String PROCEDURES_TABLE_NAME = "PROCEDURES";
    static final String PROCEDURE_COLUMNS_TABLE_NAME = "PROCEDURE_COLUMNS";
    static final String INDEXES_TABLE_NAME = "INDEXES";
    static final String CLIENT_INFO_TABLE_NAME = "CLIENTINFO";
    static final String FUNCTIONS_TABLE_NAME = "FUNCTIONS";
    static final String FUNCTION_COLUMNS_TABLE_NAME = "FUNCTION_COLUMNS";
    static final String PSEUDOCOLUMNS_TABLE_NAME = "PSEUDOCOLUMNS";
    static final String PSEUDO_COLUMN_STR = "PSEUDO_COLUMN";
    static final String ATTRIBUTES_TABLE_NAME = "ATTRIBUTES";
    static final String SUPERTABLES_TABLE_NAME = "SUPERTABLES";
    static final String SUPERTYPES_TABLE_NAME = "SUPERTYPES";
    static final String USER_DEFINED_TYPES_TABLE_NAME = "USER_DEFINED_TYPES";
    static final String VERSION_COLUMNS_TABLE_NAME = "VERSION_COLUMNS";
    static final String PRIMARY_KEYS_TABLE_NAME = "PRIMARY_KEYS";
    static final String PRIMARY_KEY_NAME = "PRIMARY_KEY";
    static final String PKTABLE_NAME_STR = "PKTABLE_NAME";
    static final String PKCOLUMN_NAME_STR = "PKCOLUMN_NAME";
    static final String FKTABLE_NAME_STR = "FKTABLE_NAME";
    static final String FKCOLUMN_NAME_STR = "FKCOLUMN_NAME";
    static final String KEY_SEQ_STR = "KEY_SEQ";
    static final String PKTABLE_SCHEM_STR = "PKTABLE_SCHEM";
    static final String PK_NAME_STR = "PK_NAME";
    static final String PKTABLE_CAT_STR = "PKTABLE_CAT";
    static final String FKTABLE_CAT_STR = "FKTABLE_CAT";
    static final String FOREIGN_KEY_NAME = "FOREIGN_KEY";
    static final String FKTABLE_SCHEM_STR = "FKTABLE_SCHEM";
    static final String FK_NAME_STR = "FK_NAME";
    static final String UPDATE_RULE_STR = "UPDATE_RULE";
    static final String DEFERRABILITY_STR = "DEFERRABILITY";
    static final String DELETE_RULE_STR = "DELETE_RULE";
    static final String IMPORTED_EXPORTED_KEYS_TABLE_NAME = "IMPORTED_EXPORTED_KEYS";
    static final String ROW_IDENTIFIERS_TABLE_NAME = "ROW_IDENTIFIERS";
    static final String TABLES_TABLE_NAME = "TABLES";
    static final String SCHEMAS_TABLE_NAME = "SCHEMAS";
    static final String CATALOGS_TABLE_NAME = "CATALOGS";
    static final String TABLE_TYPES_TABLE_NAME = "TABLETYPES";
    static final String TYPES_TABLE_NAME = "TYPES";
    static final String COLUMNS_TABLE_NAME = "COLUMNS";
    static final String REMARKS_STR = "REMARKS";
    static final String LENGTH_STR = "LENGTH";
    static final String SCALE_STR = "SCALE";
    static final String RADIX_STR = "RADIX";
    static final String COLUMN_DEF_STR = "COLUMN_DEF";
    static final String SPECIFIC_NAME_STR = "SPECIFIC_NAME";
    static final String COLUMN_NAME_STR = "COLUMN_NAME";
    static final String NULLABLE_STR = "NULLABLE";
    static final String TYPE_NAME_STR = "TYPE_NAME";
    static final String ORDINAL_POSITION_STR = "ORDINAL_POSITION";
    static final String NON_UNIQUE_STR = "NON_UNIQUE";
    static final String TYPE_STR = "TYPE";
    static final String ASC_OR_DESC_STR = "ASC_OR_DESC";
    static final String INDEX_NAME_STR = "INDEX_NAME";
    static final String DATA_TYPE_STR = "DATA_TYPE";
    static final String IS_NULLABLE_STR = "IS_NULLABLE";
    static final String CHAR_OCTET_LENGTH_STR = "CHAR_OCTET_LENGTH";
    static final String TABLE_SCHEM_STR = "TABLE_SCHEM";
    static final String TABLE_CAT_STR = "TABLE_CAT";
    static final String TABLE_CATALOG_STR = "TABLE_CATALOG";
    static final String TABLE_NAME_STR = "TABLE_NAME";
    static final String TABLE_TYPE_STR = "TABLE_TYPE";
    static final String TYPE_CAT_STR = "TYPE_CAT";
    static final String TYPE_SCHEM_STR = "TYPE_SCHEM";
    static final String DECIMAL_DIGITS_STR = "DECIMAL_DIGITS";
    static final String COLUMN_SIZE_STR = "COLUMN_SIZE";
    static final String PRECISION_STR = "PRECISION";
    static final String NUM_PREC_RADIX_STR = "NUM_PREC_RADIX";
    static final String SQL_DATETIME_SUB_STR = "SQL_DATETIME_SUB";
    static final String SQL_DATA_TYPE_STR = "SQL_DATA_TYPE";
    static final String BUFFER_LENGTH_STR = "BUFFER_LENGTH";
    static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    static final String PROCEDURE_TYPE = "PROCEDURE_TYPE";
    static final String NULL_STR = "NULL";
    static final String SELF_REFERENCING_COL_NAME_STR = "SELF_REFERENCING_COL_NAME";
    static final String REF_GENERATION_STR = "REF_GENERATION";
    static final String SCOPE_STR = "SCOPE";
    static final String CASE_SENSITIVE_STR = "CASE_SENSITIVE";
    static final String LOCAL_TYPE_NAME_STR = "LOCAL_TYPE_NAME";
    static final String AUTO_INCREMENT_STR = "AUTO_INCREMENT";
    static final String UNSIGNED_ATTRIBUTE_STR = "UNSIGNED_ATTRIBUTE";
    static final String FIXED_PREC_SCALE_STR = "FIXED_PREC_SCALE";
    static final String MINIMUM_SCALE_STR = "MINIMUM_SCALE";
    static final String MAXIMUM_SCALE_STR = "MAXIMUM_SCALE";
    static final String SEARCHABLE_STR = "SEARCHABLE";
    static final String LITERAL_PREFIX_STR = "LITERAL_PREFIC";
    static final String LITERAL_SUFFIX_STR = "LITERAL_SUFFIX";
    static final String COLUMN_USAGE_STR = "COLUMN_USAGE";
    static final String INDEX_QUALIFIER_STR = "INDEX_QUALIFIER";
    static final String CARDINALITY_STR = "CARDINALITY";
    static final String PAGES_STR = "PAGES";
    static final String FILTER_CONDITION_STR = "FILTER_DONDITION";
    static final String CREATE_PARAMS_STR = "CREATE_PARAMS";
    static final String CLASS_NAME_STR = "CLASS_NAME";
    static final String SUPERTYPE_CAT_STR = "SUPERTYPE_CAT";
    static final String BASE_TYPE_STR = "BASE_TYPE";
    static final String SUPERTYPE_SCHEM_STR = "SUPERTYPE_SCHEM";
    static final String SUPERTYPE_NAME_STR = "SUPERTYPE_NAME";
    static final String ATTR_TYPE_NAME_STR = "ATTR_TYPE_NAME";
    static final String ATTR_NAME_STR = "ATTR_NAME";
    static final String SUPERTABLE_NAME_STR = "SUPERTABLE_NAME";
    static final String ATTR_SIZE_STR = "ATTR_SIZE";
    static final String ATTR_DEF_STR = "ATTR_DEF";
    static final String SOURCE_DATA_TYPE_STR = "SOURCE_DATA_TYPE";
    static final String SCOPE_SCHEMA_STR = "SCOPE_SCHEMA";
    static final String SCOPE_CATALOG_STR = "SCOPE_CATALOG";
    static final String DEFAULT_VALUE_STR = "DEFAULT_VALUE";
    static final String DESCRIPTION_STR = "DESCRIPTIO";
    static final String FUNCTION_NAME_STR = "FUNCTION_NAME";
    static final String FUNCTION_TYPE_STR = "FUNCTION_TYPE";
    static final String FUNCTION_CAT_STR = "FUNCTION_CAT";
    static final String MAX_LEN_STR = "MAX_LEN";
    static final String NAME_STR = "NAME";
    static final String SCOPE_TABLE_STR = "SCOPE_TABLE";
    static final String FUNCTION_SCHEM_STR = "FUNCTION_SCHEM";
    static final String IS_AUTOINCREMENT_STR = "IS_AUTOINCREMENT";
    static final String IS_GENERATEDCOLUMN_STR = "IS_GENERATEDCOLUMNS";
    static final String GRANTOR_STR = "GRANTOR";
    static final String GRANTEE_STR = "GRANTEE";
    static final String PRIVILEGE_STR = "PRIVILEGE";
    static final String COLUMN_TYPE_STR = "COLUMN_TYPE";
    static final String IS_GRANTABLE_STR = "IS_GRANTABLE";
    static final SForceTableColumn[] getProceduresColumnInfo = SFDCDatabaseMetaData.constructGetProceduresColumnInfo();
    static final SForceTableColumn[] getProcedureColumnsColumnInfo = SFDCDatabaseMetaData.constructGetProcedureColumnsColumnInfo();
    static final SForceTableColumn[] getTablesColumnInfo = SFDCDatabaseMetaData.constructGetTablesColumnInfo();
    static final SForceTableColumn[] getSchemasColumnInfo = SFDCDatabaseMetaData.constructGetSchemasColumnInfo();
    static final SForceTableColumn[] getCatalogsColumnInfo = SFDCDatabaseMetaData.constructGetCatalogsColumnInfo();
    static final SForceTableColumn[] getTableTypesColumnInfo = SFDCDatabaseMetaData.constructGetTableTypesColumnInfo();
    static final SForceTableColumn[] getBestRowIdentifierColumnInfo = SFDCDatabaseMetaData.constructGetBestRowIdentifierColumnInfo();
    static final SForceTableColumn[] getVersionColumnsColumnInfo = SFDCDatabaseMetaData.constructGetVersionColumnInfo();
    static final SForceTableColumn[] getPrimaryKeysColumnInfo = SFDCDatabaseMetaData.constructGetPrimaryKeysColumnInfo();
    static final SForceTableColumn[] getImportedKeysColumnInfo = SFDCDatabaseMetaData.constructGetImportedKeysColumnInfo();
    static final SForceTableColumn[] getExportedKeysColumnInfo = SFDCDatabaseMetaData.constructGetExportedKeysColumnInfo();
    static final SForceTableColumn[] getTypeInfoColumnInfo = SFDCDatabaseMetaData.constructGetTypeInfoColumnInfo();
    static final SForceTableColumn[] getIndexInfoColumnInfo = SFDCDatabaseMetaData.constructGetIndexInfoColumnInfo();
    static final SForceTableColumn[] getUDTsColumnInfo = SFDCDatabaseMetaData.constructGetUDTsColumnInfo();
    static final SForceTableColumn[] getSuperTypesColumnInfo = SFDCDatabaseMetaData.constructGetSuperTypesColumnInfo();
    static final SForceTableColumn[] getSuperTablesColumnInfo = SFDCDatabaseMetaData.constructGetSuperTablesColumnInfo();
    static final SForceTableColumn[] getAttributesColumnInfo = SFDCDatabaseMetaData.constructGetAttributesColumnInfo();
    static final SForceTableColumn[] getClientInfoPropertiesColumnInfo = SFDCDatabaseMetaData.constructGetClientInfoPropertiesColumnInfo();
    static final SForceTableColumn[] getFunctionsColumnInfo = SFDCDatabaseMetaData.constructGetFunctionsColumnInfo();
    static final SForceTableColumn[] getFunctionColumnsColumnInfo = SFDCDatabaseMetaData.constructGetFunctionColumnsColumnInfo();
    static final SForceTableColumn[] getPseudoColumnsColumnInfo = SFDCDatabaseMetaData.constructGetPseudoColumnsColumnInfo();
    static final SForceTableColumn[] getTablePrivilegesColumnInfo = SFDCDatabaseMetaData.constructGetTablePrivilegesColumnInfo();
    static final SForceTableColumn[] getColumnsColumnInfo = SFDCDatabaseMetaData.constructGetColumnsColumnInfo();
    static final SForceTableColumn[] getColumnPrivilegesColumnInfo = SFDCDatabaseMetaData.constructGetColumnPrivilegesColumnInfo();
    public static final int MAX_VARCHAR_PRECISION = 1024;
    static final String VARCHAR = "VARCHAR";
    static final String INTEGER = "INTEGER";
    static final String BOOLEAN = "BOOLEAN";
    private SForceConnectionParams mParams = null;
    private SForceTable[] tableList = null;
    private HashMap<String, SForceTableInfo> tableColumnInfo = null;
    private HashMap<String, ArrayList<SForceParentRelationshipInfo>> parentChildRelInfo = null;
    private SFDCConnection connection;

    public SFDCDatabaseMetaData(SForceConnectionParams params, SFDCConnection conn) {
        this.mParams = params;
        this.connection = Objects.requireNonNull(conn, SFDCMessageUtil.getMessage("0007", "connection"));
    }

    private synchronized void initTable() {
        if (this.tableList == null) {
            this.tableList = SForceRequestManager.getInstance().describeGlobal(this.mParams);
        }
    }

    private synchronized void initColumn() {
        this.initTable();
        String[] tableNames = new String[this.tableList.length];
        int index = 0;
        for (SForceTable table : this.tableList) {
            tableNames[index++] = table.getName();
        }
        this.tableColumnInfo = SForceRequestManager.getInstance().describeSObjects(this.mParams, tableNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(SFDCMessageUtil.getMessage("0009", iface), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.INVALID_UNWRAP.getErrorCode());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getAttributesColumnInfo);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getBestRowIdentifierColumnInfo);
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getCatalogsColumnInfo);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getClientInfoPropertiesColumnInfo);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getColumnPrivilegesColumnInfo);
    }

    @Override
    public ResultSet getColumns(String catalogName, String schemaNamePattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Optional<String> tableNamePatternOptional = Optional.ofNullable(SFDCDatabaseMetaData.convertJDBCMetachars(tableNamePattern));
        if (this.tableList == null || this.tableColumnInfo == null) {
            this.initColumn();
        }
        HashMap<String, SForceTableInfo> tableColumnInfoBasedOnTable = new HashMap<String, SForceTableInfo>();
        for (int i = 0; i < this.tableList.length; ++i) {
            String tableName;
            if (!this.tableList[i].isQueryable() || SFDCDatabaseMetaData.filterNotMatching(tableName = this.tableList[i].getName(), tableNamePatternOptional)) continue;
            tableColumnInfoBasedOnTable.put(this.tableList[i].getName(), this.tableColumnInfo.get(this.tableList[i].getName()));
        }
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        new Thread(() -> {
            this.populateColumnRows(columnNamePattern, queue, tableColumnInfoBasedOnTable);
            queue.add(new EOFRow());
        }).start();
        SFDCResultSetMetaData resultSetMeta = new SFDCResultSetMetaData(Arrays.asList(getColumnsColumnInfo));
        SFDCResultSet rs = new SFDCResultSet(null, queue, resultSetMeta);
        return rs;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedKeys(parentCatalog, parentSchema, parentTable);
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Salesforce";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return String.valueOf(this.getDatabaseMajorVersion()) + '.' + this.getDatabaseMinorVersion();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public int getDriverMajorVersion() {
        return SFDCDriver.DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getDriverMinorVersion() {
        return SFDCDriver.DRIVER_VERSION_MINOR;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "SFDC JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return SFDCDriver.DRIVER_VERSION;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String tableName) throws SQLException {
        if (this.tableList == null || this.tableColumnInfo == null) {
            this.initColumn();
        }
        HashMap<String, SForceTableInfo> tableColumnInfoBasedOnTable = new HashMap<String, SForceTableInfo>();
        tableColumnInfoBasedOnTable.put(tableName, this.tableColumnInfo.get(tableName));
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        new Thread(() -> {
            this.populateExportedKeys(queue, tableColumnInfoBasedOnTable);
            queue.add(new EOFRow());
        }).start();
        SFDCResultSetMetaData resultSetMeta = new SFDCResultSetMetaData(Arrays.asList(getExportedKeysColumnInfo));
        SFDCResultSet rs = new SFDCResultSet(null, queue, resultSetMeta);
        return rs;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getFunctionColumnsColumnInfo);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getFunctionsColumnInfo);
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String tableName) throws SQLException {
        if (this.tableList == null || this.tableColumnInfo == null) {
            this.initColumn();
        }
        if (this.parentChildRelInfo == null) {
            this.processSForceChildRelationshipInfo();
        }
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        new Thread(() -> {
            this.populateImportedKeys(queue, tableName);
            queue.add(new EOFRow());
        }).start();
        SFDCResultSetMetaData resultSetMeta = new SFDCResultSetMetaData(Arrays.asList(getImportedKeysColumnInfo));
        SFDCResultSet rs = new SFDCResultSet(null, queue, resultSetMeta);
        return rs;
    }

    @Override
    public ResultSet getIndexInfo(String catalogName, String schemaName, String tableName, boolean unique, boolean approximate) throws SQLException {
        if (this.tableList == null || this.tableColumnInfo == null) {
            this.initColumn();
        }
        HashMap<String, SForceTableInfo> tableColumnInfoBasedOnTable = new HashMap<String, SForceTableInfo>();
        tableColumnInfoBasedOnTable.put(tableName, this.tableColumnInfo.get(tableName));
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        new Thread(() -> {
            this.populateIndexInfo(queue, tableColumnInfoBasedOnTable);
            queue.add(new EOFRow());
        }).start();
        SFDCResultSetMetaData resultSetMeta = new SFDCResultSetMetaData(Arrays.asList(getIndexInfoColumnInfo));
        SFDCResultSet rs = new SFDCResultSet(null, queue, resultSetMeta);
        return rs;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalogName, String schemaName, String tableName) throws SQLException {
        if (this.tableList == null || this.tableColumnInfo == null) {
            this.initColumn();
        }
        HashMap<String, SForceTableInfo> tableColumnInfoBasedOnTable = new HashMap<String, SForceTableInfo>();
        tableColumnInfoBasedOnTable.put(tableName, this.tableColumnInfo.get(tableName));
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        new Thread(() -> {
            this.populatePrimaryKeys(queue, tableColumnInfoBasedOnTable);
            queue.add(new EOFRow());
        }).start();
        SFDCResultSetMetaData resultSetMeta = new SFDCResultSetMetaData(Arrays.asList(getPrimaryKeysColumnInfo));
        SFDCResultSet rs = new SFDCResultSet(null, queue, resultSetMeta);
        return rs;
    }

    @Override
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getProcedureColumnsColumnInfo);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getProcedures(String arg0, String arg1, String arg2) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getProceduresColumnInfo);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getSchemasColumnInfo);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getSchemasColumnInfo);
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getSuperTablesColumnInfo);
    }

    @Override
    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getSuperTypesColumnInfo);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getTablePrivileges(String arg0, String arg1, String arg2) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getTablePrivilegesColumnInfo);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        SFDCResultSetMetaData resultSetMeta = new SFDCResultSetMetaData(Arrays.asList(getTableTypesColumnInfo));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TABLE_TYPE_STR, "TABLE");
        Row row = new Row(map);
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        queue.add(row);
        queue.add(new EOFRow());
        return new SFDCResultSet(null, queue, resultSetMeta);
    }

    @Override
    public ResultSet getTables(String catalogName, String schemaName, String tableNamePattern, String[] tableTypes) throws SQLException {
        LinkedBlockingQueue<Row> queue = new LinkedBlockingQueue<Row>();
        Optional<String> tableNamePatternOptional = Optional.ofNullable(SFDCDatabaseMetaData.convertJDBCMetachars(tableNamePattern));
        if (this.tableList == null) {
            this.initTable();
        }
        new Thread(() -> {
            if (tableTypes != null) {
                for (String tableType : tableTypes) {
                    if (!"TABLE".equals(tableType)) continue;
                    this.populateTableRows(tableNamePattern, tableType, queue);
                }
            } else {
                this.populateTableRows(tableNamePattern, "TABLE", queue);
            }
            queue.add(new EOFRow());
        }).start();
        SFDCResultSetMetaData resultSetMeta = new SFDCResultSetMetaData(Arrays.asList(getTablesColumnInfo));
        SFDCResultSet rs = new SFDCResultSet(null, queue, resultSetMeta);
        return rs;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return EMPTY_STR;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getTypeInfoColumnInfo);
    }

    @Override
    public ResultSet getUDTs(String arg0, String arg1, String arg2, int[] arg3) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getUDTsColumnInfo);
    }

    @Override
    public String getURL() throws SQLException {
        throw new SQLException();
    }

    @Override
    public String getUserName() throws SQLException {
        throw SFDCDatabaseMetaData.notSupported("getUserName");
    }

    @Override
    public ResultSet getVersionColumns(String arg0, String arg1, String arg2) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getVersionColumnsColumnInfo);
    }

    @Override
    public boolean insertsAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int arg0, int arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return 1003 == type && 1007 == concurrency;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return 1 == holdability;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return 1003 == type;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw SFDCDatabaseMetaData.notSupported("generatedKeyAlwaysReturnd");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return SFDCResultSet.constructEmptyResultSet(getPseudoColumnsColumnInfo);
    }

    private void processSForceChildRelationshipInfo() {
        this.parentChildRelInfo = new HashMap();
        for (String tableName : this.tableColumnInfo.keySet()) {
            SForceChildRelationShipInfo[] childInfo;
            SForceTableInfo tableInfo = this.tableColumnInfo.get(tableName);
            for (SForceChildRelationShipInfo cInfo : childInfo = tableInfo.getChildRelationships()) {
                String childObject = cInfo.getChildSobject();
                SForceParentRelationshipInfo pInfo = new SForceParentRelationshipInfo(tableName, cInfo);
                if (!this.parentChildRelInfo.containsKey(childObject)) {
                    this.parentChildRelInfo.put(childObject, new ArrayList(5));
                }
                this.parentChildRelInfo.get(childObject).add(pInfo);
            }
        }
    }

    private void populateTableRows(String tablePattern, String tableType, BlockingQueue<Row> queue) {
        try {
            if (null == this.tableList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(TABLE_NAME_STR, tablePattern);
                map.put(TABLE_TYPE_STR, tableType);
                queue.add(new Row(map));
            } else {
                SForceTable[] result = this.tableList;
                Optional<String> tableNamePatternOptional = Optional.ofNullable(SFDCDatabaseMetaData.convertJDBCMetachars(tablePattern));
                for (int i = 0; i < result.length; ++i) {
                    String tableName;
                    if (!result[i].isQueryable() || SFDCDatabaseMetaData.filterNotMatching(tableName = result[i].getName(), tableNamePatternOptional)) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(TABLE_NAME_STR, tableName);
                    map.put(TABLE_TYPE_STR, tableType);
                    queue.add(new Row(map));
                }
            }
        }
        catch (SForceException sfe) {
            for (Throwable cause = sfe.getCause(); cause != null; cause = cause.getCause()) {
                StackTraceElement[] traceElements = cause.getStackTrace();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(TABLE_NAME_STR, cause.getMessage());
                queue.add(new Row(map));
                for (StackTraceElement trace : traceElements) {
                    map = new HashMap();
                    map.put(TABLE_NAME_STR, trace.toString());
                    queue.add(new Row(map));
                }
                map = new HashMap();
                map.put(TABLE_NAME_STR, "--------------------------------------------");
                queue.add(new Row(map));
            }
            queue.add(new EOFRow());
            System.out.println(sfe.getCause());
            sfe.printStackTrace();
            throw sfe;
        }
    }

    private void populateColumnRows(String columnPattern, BlockingQueue<Row> queue, HashMap<String, SForceTableInfo> tableColumnInfoBasedOnTable) {
        Optional<String> columnNamePatternOptional = Optional.ofNullable(SFDCDatabaseMetaData.convertJDBCMetachars(columnPattern));
        for (String tableName : tableColumnInfoBasedOnTable.keySet()) {
            SForceTableColumn[] fields;
            SForceTableInfo tableInfo = tableColumnInfoBasedOnTable.get(tableName);
            for (SForceTableColumn field : fields = tableInfo.getFields()) {
                HashMap<String, String> row = new HashMap<String, String>();
                if (SFDCDatabaseMetaData.filterNotMatching(field.getName(), columnNamePatternOptional)) continue;
                row.put(TABLE_NAME_STR, tableName);
                row.put(COLUMN_NAME_STR, field.getName());
                row.put(REMARKS_STR, "NATIVE_DATA_TYPE=" + field.getNativeType());
                row.put(DATA_TYPE_STR, String.valueOf(MetadataUtils.inferDataTypeAsJDBC(field.getDataType())));
                row.put(TYPE_NAME_STR, MetadataUtils.inferDataTypeName(field.getNativeType(), this.mParams.bindDatetimeWithTimestamp()));
                row.put(COLUMN_SIZE_STR, String.valueOf(MetadataUtils.getColumnSize(field)));
                row.put(DECIMAL_DIGITS_STR, String.valueOf(MetadataUtils.getDecimalDigits(field)));
                row.put(NULLABLE_STR, field.isNillable() ? String.valueOf(1) : String.valueOf(0));
                row.put(IS_NULLABLE_STR, field.isNillable() ? "YES" : "NO");
                queue.add(new Row(row));
            }
        }
    }

    private void populateIndexInfo(BlockingQueue<Row> queue, HashMap<String, SForceTableInfo> tableColumnInfoBasedOnTable) {
        for (String tableName : tableColumnInfoBasedOnTable.keySet()) {
            SForceTableColumn[] fields;
            SForceTableInfo tableInfo = tableColumnInfoBasedOnTable.get(tableName);
            for (SForceTableColumn field : fields = tableInfo.getFields()) {
                if (!field.isIdLookup()) continue;
                field.setTable(tableName);
                HashMap<String, String> row = new HashMap<String, String>();
                row.put(TABLE_NAME_STR, tableName);
                row.put(NON_UNIQUE_STR, "false");
                row.put(TYPE_STR, String.valueOf(2));
                row.put(ORDINAL_POSITION_STR, String.valueOf(1));
                row.put(COLUMN_NAME_STR, field.getName());
                row.put(ASC_OR_DESC_STR, "A");
                row.put(INDEX_NAME_STR, field.getName() + "_IDX");
                row.put(CARDINALITY_STR, "0");
                row.put(PAGES_STR, "0");
                queue.add(new Row(row));
            }
        }
    }

    private void populatePrimaryKeys(BlockingQueue<Row> queue, HashMap<String, SForceTableInfo> tableColumnInfoBasedOnTable) {
        for (String tableName : tableColumnInfoBasedOnTable.keySet()) {
            SForceTableColumn[] fields;
            SForceTableInfo tableInfo = tableColumnInfoBasedOnTable.get(tableName);
            for (SForceTableColumn field : fields = tableInfo.getFields()) {
                if (!field.getName().equalsIgnoreCase("id")) continue;
                field.setTable(tableName);
                HashMap<String, String> row = new HashMap<String, String>();
                String pkTableName = tableName;
                String pkName = pkTableName + "_PK";
                row.put(TABLE_NAME_STR, pkTableName);
                row.put(COLUMN_NAME_STR, field.getName());
                row.put(KEY_SEQ_STR, String.valueOf(1));
                row.put(PK_NAME_STR, pkName);
                queue.add(new Row(row));
            }
        }
    }

    private void populateExportedKeys(BlockingQueue<Row> queue, HashMap<String, SForceTableInfo> tableColumnInfoBasedOnTable) {
        for (String tableName : tableColumnInfoBasedOnTable.keySet()) {
            SForceTableInfo tableInfo = tableColumnInfoBasedOnTable.get(tableName);
            SForceChildRelationShipInfo[] childRelations = tableInfo.getChildRelationships();
            if (childRelations == null) continue;
            for (SForceChildRelationShipInfo childRelation : childRelations) {
                HashMap<String, String> row = new HashMap<String, String>();
                String pkTableName = tableName;
                String fkTableName = childRelation.getChildSobject();
                String fkColumnName = childRelation.getField();
                String pkName = pkTableName + "_PK";
                String fkName = childRelation.getRelationShipName();
                fkName = fkName == null ? pkTableName + "_" + fkTableName + "_" + fkColumnName : fkName + "_" + pkTableName;
                row.put(PKTABLE_NAME_STR, pkTableName);
                row.put(PKCOLUMN_NAME_STR, "Id");
                row.put(FKTABLE_NAME_STR, fkTableName);
                row.put(FKCOLUMN_NAME_STR, fkColumnName);
                row.put(KEY_SEQ_STR, String.valueOf(1));
                row.put(PK_NAME_STR, pkName);
                row.put(FK_NAME_STR, fkName);
                row.put(KEY_SEQ_STR, String.valueOf(1));
                row.put(UPDATE_RULE_STR, String.valueOf(3));
                row.put(DELETE_RULE_STR, String.valueOf(3));
                row.put(DEFERRABILITY_STR, String.valueOf(7));
                queue.add(new Row(row));
            }
        }
    }

    private void populateImportedKeys(BlockingQueue<Row> queue, String tableName) {
        ArrayList<SForceParentRelationshipInfo> parentRelations = this.parentChildRelInfo.get(tableName);
        if (parentRelations != null) {
            Collections.sort(parentRelations);
            for (SForceParentRelationshipInfo parentRelation : parentRelations) {
                HashMap<String, String> row = new HashMap<String, String>();
                String pkTableName = parentRelation.getParentSobject();
                String fkTableName = tableName;
                String fkColumnName = parentRelation.getField();
                String pkName = pkTableName + "_PK";
                String fkName = parentRelation.getRelationShipName();
                fkName = fkName == null ? pkTableName + "_" + fkTableName + "_" + fkColumnName : fkName + "_" + pkTableName;
                row.put(PKTABLE_NAME_STR, pkTableName);
                row.put(PKCOLUMN_NAME_STR, "Id");
                row.put(FKTABLE_NAME_STR, fkTableName);
                row.put(FKCOLUMN_NAME_STR, fkColumnName);
                row.put(KEY_SEQ_STR, String.valueOf(1));
                row.put(PK_NAME_STR, pkName);
                row.put(FK_NAME_STR, fkName);
                row.put(UPDATE_RULE_STR, String.valueOf(3));
                row.put(DELETE_RULE_STR, String.valueOf(3));
                row.put(DEFERRABILITY_STR, String.valueOf(7));
                queue.add(new Row(row));
            }
        }
    }

    private static SForceTableColumn[] constructGetProceduresColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(PROCEDURE_CAT).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PROCEDURE_SCHEM).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PROCEDURE_NAME).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NULL_STR).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NULL_STR).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NULL_STR).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PROCEDURE_TYPE).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SPECIFIC_NAME_STR).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetProcedureColumnsColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(PROCEDURE_CAT).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PROCEDURE_SCHEM).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PROCEDURE_NAME).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setTable(PROCEDURES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PRECISION_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(LENGTH_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SCALE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(RADIX_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NULLABLE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsIdLookup(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_DEF_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SQL_DATA_TYPE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SQL_DATETIME_SUB_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_NULLABLE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SPECIFIC_NAME_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetTablesColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).build(), new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).build(), new SForceTableColumn.Builder().setColumnName(TABLE_NAME_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_TYPE_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).build(), new SForceTableColumn.Builder().setColumnName(TYPE_CAT_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).build(), new SForceTableColumn.Builder().setColumnName(TYPE_SCHEM_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).build(), new SForceTableColumn.Builder().setColumnName(SELF_REFERENCING_COL_NAME_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).build(), new SForceTableColumn.Builder().setColumnName(REF_GENERATION_STR).setTable(TABLES_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetSchemasColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(SCHEMAS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_CATALOG_STR).setTable(SCHEMAS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetCatalogsColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(CATALOGS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetTableTypesColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_TYPE_STR).setTable(TABLE_TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetBestRowIdentifierColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(SCOPE_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_SIZE_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(BUFFER_LENGTH_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PSEUDO_COLUMN_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetVersionColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(SCOPE_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_SIZE_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(BUFFER_LENGTH_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PSEUDO_COLUMN_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetPrimaryKeysColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_NAME_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(KEY_SEQ_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PK_NAME_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetImportedKeysColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(PKTABLE_CAT_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PKTABLE_SCHEM_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PKTABLE_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PKCOLUMN_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FKTABLE_CAT_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FKTABLE_SCHEM_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FKTABLE_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FKCOLUMN_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(KEY_SEQ_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(UPDATE_RULE_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DELETE_RULE_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FK_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PK_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DEFERRABILITY_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetExportedKeysColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(PKTABLE_CAT_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PKTABLE_SCHEM_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PKTABLE_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PKCOLUMN_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FKTABLE_CAT_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FKTABLE_SCHEM_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FKTABLE_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FKCOLUMN_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(KEY_SEQ_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(UPDATE_RULE_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DELETE_RULE_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FK_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PK_NAME_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DEFERRABILITY_STR).setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetTypeInfoColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PRECISION_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(LITERAL_PREFIX_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(LITERAL_SUFFIX_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CREATE_PARAMS_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NULLABLE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CASE_SENSITIVE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.BOOLEAN).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SEARCHABLE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(UNSIGNED_ATTRIBUTE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.BOOLEAN).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FIXED_PREC_SCALE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.BOOLEAN).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(AUTO_INCREMENT_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.BOOLEAN).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(LOCAL_TYPE_NAME_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(MINIMUM_SCALE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(MAXIMUM_SCALE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SQL_DATA_TYPE_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SQL_DATETIME_SUB_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NUM_PREC_RADIX_STR).setTable(TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetIndexInfoColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_NAME_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NON_UNIQUE_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.BOOLEAN).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(INDEX_QUALIFIER_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(INDEX_NAME_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ASC_OR_DESC_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CARDINALITY_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PAGES_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FILTER_CONDITION_STR).setTable(INDEXES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetUDTsColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TYPE_CAT_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_SCHEM_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CLASS_NAME_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(BASE_TYPE_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetSuperTypesColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TYPE_CAT_STR).setTable(SUPERTYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_SCHEM_STR).setTable(SUPERTYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(SUPERTYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SUPERTYPE_CAT_STR).setTable(SUPERTYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SUPERTYPE_SCHEM_STR).setTable(SUPERTYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SUPERTYPE_NAME_STR).setTable(SUPERTYPES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetSuperTablesColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(SUPERTABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(SUPERTABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_NAME_STR).setTable(SUPERTABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SUPERTABLE_NAME_STR).setTable(SUPERTABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetAttributesColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TYPE_CAT_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_SCHEM_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ATTR_NAME_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ATTR_TYPE_NAME_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ATTR_SIZE_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NUM_PREC_RADIX_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NULLABLE_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ATTR_DEF_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SQL_DATA_TYPE_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SQL_DATETIME_SUB_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_NULLABLE_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SCOPE_CATALOG_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SCOPE_SCHEMA_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SCOPE_TABLE_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SOURCE_DATA_TYPE_STR).setTable(ATTRIBUTES_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetClientInfoPropertiesColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(NAME_STR).setTable(CLIENT_INFO_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(MAX_LEN_STR).setTable(CLIENT_INFO_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DEFAULT_VALUE_STR).setTable(CLIENT_INFO_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DESCRIPTION_STR).setTable(CLIENT_INFO_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetFunctionsColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(FUNCTION_CAT_STR).setTable(FUNCTIONS_TABLE_NAME).setDataType(DataType.VARCHAR).build(), new SForceTableColumn.Builder().setColumnName(FUNCTION_SCHEM_STR).setTable(FUNCTIONS_TABLE_NAME).setDataType(DataType.VARCHAR).build(), new SForceTableColumn.Builder().setColumnName(FUNCTION_NAME_STR).setTable(FUNCTIONS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(FUNCTIONS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FUNCTION_TYPE_STR).setTable(FUNCTIONS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SPECIFIC_NAME_STR).setTable(FUNCTIONS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetFunctionColumnsColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(FUNCTION_CAT_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FUNCTION_SCHEM_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(FUNCTION_NAME_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_TYPE_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PRECISION_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(LENGTH_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SCALE_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(RADIX_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NULLABLE_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_NULLABLE_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SPECIFIC_NAME_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetPseudoColumnsColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_NAME_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_SIZE_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NUM_PREC_RADIX_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_USAGE_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_NULLABLE_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetTablePrivilegesColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(TABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(TABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_NAME_STR).setTable(TABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(GRANTOR_STR).setTable(TABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(GRANTEE_STR).setTable(TABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PRIVILEGE_STR).setTable(TABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_GRANTABLE_STR).setTable(TABLES_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetColumnsColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_NAME_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DATA_TYPE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TYPE_NAME_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_SIZE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(BUFFER_LENGTH_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NUM_PREC_RADIX_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(NULLABLE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(REMARKS_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_DEF_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SQL_DATA_TYPE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SQL_DATETIME_SUB_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_NULLABLE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SCOPE_CATALOG_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SCOPE_SCHEMA_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SCOPE_TABLE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(SOURCE_DATA_TYPE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.INTEGER).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_AUTOINCREMENT_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_GENERATEDCOLUMN_STR).setTable(COLUMNS_TABLE_NAME).setCatalog(EMPTY_STR).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build()};
        return columns;
    }

    private static SForceTableColumn[] constructGetColumnPrivilegesColumnInfo() {
        SForceTableColumn[] columns = new SForceTableColumn[]{new SForceTableColumn.Builder().setColumnName(TABLE_CAT_STR).setTable(COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_SCHEM_STR).setTable(COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(TABLE_NAME_STR).setTable(COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(COLUMN_NAME_STR).setTable(COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(GRANTOR_STR).setTable(COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(GRANTEE_STR).setTable(COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(PRIVILEGE_STR).setTable(COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(false).setIsIdLookup(false).build(), new SForceTableColumn.Builder().setColumnName(IS_GRANTABLE_STR).setTable(COLUMNS_TABLE_NAME).setDataType(DataType.VARCHAR).setIsNillable(true).setIsIdLookup(false).build()};
        return columns;
    }

    private static SQLFeatureNotSupportedException notSupported(String s) {
        return new SQLFeatureNotSupportedException(SFDCMessageUtil.getMessage("0029", s), SFDCSQLState.FEATURE_NOT_SUPPORTED.getState(), SFDCSQLErrorCode.JDBC_FEATURE_NOT_SUPPORTED.getErrorCode());
    }

    private static String convertJDBCMetachars(String input) {
        if (null == input) {
            return null;
        }
        return input.replaceAll("_", ".").replaceAll("%", ".*");
    }

    private static boolean filterNotMatching(String value, Optional<String> pattern) {
        return pattern.isPresent() && (pattern.get().length() == 0 || !value.toUpperCase().matches(pattern.get().toUpperCase()));
    }

    static class SForceParentRelationshipInfo
    implements Comparable<SForceParentRelationshipInfo> {
        private String parentSObject;
        private SForceChildRelationShipInfo cInfo;

        private SForceParentRelationshipInfo(String parentSObject, SForceChildRelationShipInfo cInfo) {
            this.parentSObject = parentSObject;
            this.cInfo = cInfo;
        }

        public String getField() {
            return this.cInfo.getField();
        }

        public String getRelationShipName() {
            return this.cInfo.getRelationShipName();
        }

        public String getParentSobject() {
            return this.parentSObject;
        }

        @Override
        public int compareTo(SForceParentRelationshipInfo o) {
            return this.parentSObject.compareTo(o.getParentSobject());
        }
    }
}

