/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc;

import com.ibm.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.ibm.cognos.cdms.ds.sforce.request.SForceException;
import com.ibm.cognos.cdms.ds.sforce.request.SForceRequestManager;
import com.ibm.cognos.jdbc.sfdc.QueryExecutor;
import com.ibm.cognos.jdbc.sfdc.SFDCConnection;
import com.ibm.cognos.jdbc.sfdc.SFDCOptionEnum;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageUtil;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLErrorCode;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLState;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class SFDCDriver
implements Driver {
    static final String DRIVER_NAME = "SFDC JDBC Driver";
    static final String DATABASE_PRODUCT_NAME = "Salesforce";
    static final String UNKNOWN_STR = "unknown";
    static final String DRIVER_VERSION;
    static final int DRIVER_VERSION_MAJOR;
    static final int DRIVER_VERSION_MINOR;
    private static final String JDBC_CONNECTION_STR_PREFIX = "jdbc:sfdc://";

    private SForceConnectionParams getSFDCConnParams(Properties info) throws SQLException {
        SForceConnectionParams params = new SForceConnectionParams();
        String user = info.getProperty("user");
        if (null == user) {
            throw new SQLException(String.format("Connection property username is required.", new Object[0]), SFDCSQLState.CONNECTION_INVALID_OPTION.getState(), SFDCSQLErrorCode.REQUIRED_PROPERTY_NAME.getErrorCode());
        }
        params.setUserName(user);
        String password = info.getProperty("password");
        if (null == password) {
            throw new SQLException(String.format("Connection property password is required.", new Object[0]), SFDCSQLState.CONNECTION_INVALID_OPTION.getState(), SFDCSQLErrorCode.REQUIRED_PROPERTY_NAME.getErrorCode());
        }
        params.setPassword(password);
        HashMap<String, PropertyDescriptor> pdMap = new HashMap<String, PropertyDescriptor>();
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = Introspector.getBeanInfo(params.getClass());
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                pdMap.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException beanInfo) {
            // empty catch block
        }
        Set<Map.Entry<Object, Object>> entrySet = info.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String optionName = (String)entry.getKey();
            String optionValue = (String)entry.getValue();
            try {
                SFDCOptionEnum optionEnum = SFDCOptionEnum.lookup(optionName);
                if (optionEnum == null) continue;
                if (null == optionValue) {
                    throw new SQLException("0057", SFDCSQLState.CONNECTION_INVALID_OPTION.getState(), SFDCSQLErrorCode.MISSING_PROPERTY_VALUE.getErrorCode());
                }
                String sForceKey = optionEnum.getSForceKey();
                PropertyDescriptor pd = (PropertyDescriptor)pdMap.get(sForceKey);
                if (pd.getPropertyType().getName() == "int" || pd.getPropertyType() == Integer.class) {
                    pd.getWriteMethod().invoke((Object)params, Integer.valueOf(optionValue));
                    continue;
                }
                if (pd.getPropertyType().getName() == "boolean" || pd.getPropertyType() == Boolean.class) {
                    pd.getWriteMethod().invoke((Object)params, Boolean.valueOf(optionValue));
                    continue;
                }
                if (pd.getPropertyType() != String.class) continue;
                pd.getWriteMethod().invoke((Object)params, optionValue);
            }
            catch (InvocationTargetException ite) {
                System.err.println(optionName);
                ite.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return params;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (null == url) {
            throw new SQLException(SFDCMessageUtil.getMessage("0036"));
        }
        SFDCConnection conn = null;
        QueryExecutor queryExecutor = null;
        String[] parts = url.split(";");
        if (parts != null && parts.length > 0 && this.isSFDCSubprotocol(parts[0])) {
            String sfdcURL = parts[0].trim().substring(JDBC_CONNECTION_STR_PREFIX.length());
            String[] options = new String[parts.length - 1];
            System.arraycopy(parts, 1, options, 0, options.length);
            this.mergeURLOptions(options, info);
            info.put(SFDCOptionEnum.URL.getOptionName(), sfdcURL);
            SForceConnectionParams sfdcConnParams = this.getSFDCConnParams(info);
            try {
                queryExecutor = new QueryExecutor();
                SForceRequestManager.getInstance().validateConnection(sfdcConnParams);
                conn = new SFDCConnection(sfdcConnParams, queryExecutor);
                return conn;
            }
            catch (SForceException sfe) {
                if (null != conn) {
                    conn.close();
                }
                if (null != queryExecutor) {
                    queryExecutor.close();
                }
                throw new SQLException(sfe);
            }
            catch (Exception e) {
                if (null != conn) {
                    conn.close();
                }
                if (null != queryExecutor) {
                    queryExecutor.close();
                }
                throw new SQLException(e);
            }
        }
        throw new SQLException(SFDCMessageUtil.getMessage("0033"));
    }

    @Override
    public int getMajorVersion() {
        return DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DRIVER_VERSION_MINOR;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties arg1) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger() is not supported.");
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.isSFDCSubprotocol(url);
    }

    protected void mergeURLOptions(String[] options, Properties info) throws SQLException {
        for (int i = 0; i < options.length; ++i) {
            String[] parts = options[i].split("=");
            if (parts == null || parts.length != 2) continue;
            String optionName = parts[0].trim();
            String optionValue = parts[1].trim();
            info.put(optionName, optionValue);
        }
    }

    private boolean isSFDCSubprotocol(String url) throws SQLException {
        if (null == url) {
            throw new SQLException(SFDCMessageUtil.getMessage("0036"));
        }
        return url.startsWith(JDBC_CONNECTION_STR_PREFIX);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        DRIVER_VERSION_MAJOR = 1;
        DRIVER_VERSION_MINOR = 0;
        DRIVER_VERSION = String.valueOf(DRIVER_VERSION_MAJOR) + '.' + String.valueOf(DRIVER_VERSION_MINOR);
        SFDCDriver thisDriver = new SFDCDriver();
        try {
            DriverManager.registerDriver(thisDriver);
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
        }
    }
}

