/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc;

import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.ibm.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.ibm.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResultRecord;
import com.ibm.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.ibm.cognos.jdbc.sfdc.EOFRow;
import com.ibm.cognos.jdbc.sfdc.Row;
import com.ibm.cognos.jdbc.sfdc.SFDCResultSetMetaData;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageUtil;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLErrorCode;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCSQLState;
import com.sforce.soap.partner.FieldType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SFDCResultSet
implements ResultSet {
    public static final String SFORCE_DATATYPE_ID = FieldType.id.toString();
    public static final String SFORCE_DATATYPE_REFERENCE = FieldType.reference.toString();
    public static final String SFORCE_DATATYPE_STRING = FieldType.string.toString();
    public static final String SFORCE_DATATYPE_PHONE = FieldType.phone.toString();
    public static final String SFORCE_DATATYPE_URL = FieldType.url.toString();
    public static final String SFORCE_DATATYPE_EMAIL = FieldType.email.toString();
    public static final String SFORCE_DATATYPE_COMBOBOX = FieldType.combobox.toString();
    public static final String SFORCE_DATATYPE_MULTIPICKLIST = FieldType.multipicklist.toString();
    public static final String SFORCE_DATATYPE_PICKLIST = FieldType.picklist.toString();
    public static final String SFORCE_DATATYPE_ANYTYPE = FieldType.anyType.toString();
    public static final String SFORCE_DATATYPE_BASE64 = FieldType.base64.toString();
    public static final String SFORCE_DATATYPE_ENCRYPTEDSTRING = FieldType.encryptedstring.toString();
    public static final String SFORCE_DATATYPE_DATACATEGORYGROUPREFERENCE = FieldType.datacategorygroupreference.toString();
    public static final String SFORCE_DATATYPE_LOCATION = FieldType.location.toString();
    public static final String SFORCE_DATATYPE_ADDRESS = FieldType.address.toString();
    public static final String SFORCE_DATATYPE_COMPLEXVALUE = FieldType.complexvalue.toString();
    public static final String SFORCE_DATATYPE_BOOLEAN = FieldType._boolean.toString();
    public static final String SFORCE_DATATYPE_DOUBLE = FieldType._double.toString();
    public static final String SFORCE_DATATYPE_CURRENCY = FieldType.currency.toString();
    public static final String SFORCE_DATATYPE_PERCENT = FieldType.percent.toString();
    public static final String SFORCE_DATATYPE_INT = FieldType._int.toString();
    public static final String SFORCE_DATATYPE_DATETIME = FieldType.datetime.toString();
    public static final String SFORCE_DATATYPE_DATE = FieldType.date.toString();
    public static final String SFORCE_DATATYPE_TIME = FieldType.time.toString();
    public static final String SFORCE_DATATYPE_TEXTAREA = FieldType.textarea.toString();
    private final Statement statement;
    private final AtomicInteger rowId = new AtomicInteger(0);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean beforeFirst = new AtomicBoolean(true);
    private final AtomicBoolean afterLast = new AtomicBoolean(false);
    private final Map<Integer, String> columnNameLookup;
    private final Map<String, Integer> columnIndexLookup;
    private BlockingQueue<Row> mRowQueue = null;
    private final SFDCResultSetMetaData mResultSetMetaData;
    private SForceResultSet mSForceResultSet;
    ISForceQueryResultRecord mCurrentRecord = null;
    protected int currentIndex = -1;
    protected List<Row> mResults = null;
    protected boolean eof = false;

    public SFDCResultSet(Statement theStatement, BlockingQueue<Row> queue, SFDCResultSetMetaData resultMD) throws SQLException {
        this.statement = theStatement;
        this.mRowQueue = queue;
        this.mResults = new ArrayList<Row>();
        this.mResultSetMetaData = resultMD;
        this.columnNameLookup = SFDCResultSet.constructColumnNameLookupMap(resultMD);
        this.columnIndexLookup = SFDCResultSet.constructColumnIndexLookupMap(resultMD);
    }

    public SFDCResultSet(Statement theStatement, SForceResultSet sForceResult, SFDCResultSetMetaData resultMD) throws SQLException {
        this.statement = theStatement;
        this.mSForceResultSet = sForceResult;
        this.mResults = new ArrayList<Row>();
        this.mResultSetMetaData = resultMD;
        this.columnNameLookup = SFDCResultSet.constructColumnNameLookupMap(resultMD);
        this.columnIndexLookup = SFDCResultSet.constructColumnIndexLookupMap(resultMD);
    }

    protected Object getValue(String columnName) throws SQLException {
        this.checkOpen();
        if (this.currentIndex >= 0) {
            if (null != this.mRowQueue) {
                Map<String, String> row = this.mResults.get(this.currentIndex).getRowData();
                try {
                    return row.get(columnName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SQLException(SFDCMessageUtil.getMessage("0024"), SFDCSQLState.INCONSISTENT_CURSOR.getState(), SFDCSQLErrorCode.UNKNOWN_CURSOR_STATE.getErrorCode(), e);
                }
            }
            int columnIndex = this.columnLabel2columnIndex(columnName);
            try {
                return this.mCurrentRecord.getColumnValue(columnIndex - 1, Object.class);
            }
            catch (SForceAPIException e) {
                e.printStackTrace();
                throw new SQLException(SFDCMessageUtil.getMessage("0024"), SFDCSQLState.INCONSISTENT_CURSOR.getState(), SFDCSQLErrorCode.UNKNOWN_CURSOR_STATE.getErrorCode(), e);
            }
        }
        throw new SQLException(SFDCMessageUtil.getMessage("0017", columnName));
    }

    protected Object getValue(int columnIndex) throws SQLException {
        String columnName = this.columnIndex2ColumnName(columnIndex);
        if (null == columnName) {
            throw new SQLException(SFDCMessageUtil.getMessage("0017"), SFDCSQLState.INVALID_COLUMN.getState(), SFDCSQLErrorCode.NULL_NOT_VALID_COLUMN_NAME.getErrorCode());
        }
        return this.getValue(columnName);
    }

    protected String columnIndex2ColumnName(int columnIndex) throws SQLException {
        if (columnIndex <= 0 || columnIndex > this.mResultSetMetaData.getColumnCount()) {
            throw new SQLException(SFDCMessageUtil.getMessage("0016", columnIndex), SFDCSQLState.INVALID_COLUMN.getState(), SFDCSQLErrorCode.OUT_OF_BOUNDS_COLUMN_INDEX.getErrorCode());
        }
        String columnName = this.columnNameLookup.get(columnIndex);
        if (null == columnName) {
            throw new SQLException(SFDCMessageUtil.getMessage("0017"), SFDCSQLState.INVALID_COLUMN.getState(), SFDCSQLErrorCode.NULL_NOT_VALID_COLUMN_NAME.getErrorCode());
        }
        return columnName;
    }

    private int columnLabel2columnIndex(String columnLabel) throws SQLException {
        if (null == columnLabel) {
            throw new SQLException(SFDCMessageUtil.getMessage("0018"), SFDCSQLState.INVALID_COLUMN.getState(), SFDCSQLErrorCode.NULL_NOT_VALID_COLUMN_NAME.getErrorCode());
        }
        Integer index = this.columnIndexLookup.get(columnLabel.toUpperCase());
        if (null == index) {
            throw new SQLException(SFDCMessageUtil.getMessage("0016"), SFDCSQLState.INVALID_COLUMN.getState(), SFDCSQLErrorCode.NULL_NOT_VALID_COLUMN_INDEX.getErrorCode());
        }
        return index;
    }

    public void addResult(Row row) {
        this.mResults.add(row);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.currentIndex + 1 < this.mResults.size()) {
            if (this.currentIndex < 0) {
                this.beforeFirst.set(true);
                this.afterLast.set(false);
            }
            ++this.currentIndex;
            this.rowId.getAndIncrement();
            return true;
        }
        try {
            if (this.eof) {
                this.beforeFirst.set(false);
                this.afterLast.set(true);
                this.rowId.set(0);
                return false;
            }
            if (null != this.mRowQueue) {
                Row row = this.mRowQueue.take();
                if (row instanceof EOFRow) {
                    this.eof = true;
                    this.beforeFirst.set(false);
                    this.afterLast.set(true);
                    this.rowId.set(0);
                    return false;
                }
                this.addResult(row);
                ++this.currentIndex;
                this.rowId.getAndIncrement();
                return true;
            }
            if (this.mSForceResultSet.hasNext()) {
                try {
                    this.mCurrentRecord = this.mSForceResultSet.next();
                    ++this.currentIndex;
                    this.rowId.getAndIncrement();
                    return true;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw new SQLException(SFDCMessageUtil.getMessage("0024"), SFDCSQLState.INCONSISTENT_CURSOR.getState(), SFDCSQLErrorCode.UNKNOWN_CURSOR_STATE.getErrorCode(), e);
                }
            }
            this.eof = true;
            this.beforeFirst.set(false);
            this.afterLast.set(true);
            this.rowId.set(0);
            return false;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw SFDCResultSet.notSupported("absolute");
    }

    @Override
    public void afterLast() throws SQLException {
        throw SFDCResultSet.notSupported("afterLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw SFDCResultSet.notSupported("beforeFirst");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SFDCResultSet.notSupported("cancelRowUpdates");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void close() throws SQLException {
        if (this.closed.compareAndSet(false, true) && null != this.mSForceResultSet) {
            this.mSForceResultSet.close();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SFDCResultSet.notSupported("deleteRow");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkOpen();
        return this.columnLabel2columnIndex(columnLabel);
    }

    @Override
    public boolean first() throws SQLException {
        throw SFDCResultSet.notSupported("first");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getArray");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getArray");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getAsciiStream");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getAsciiStream");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(this.columnIndex2ColumnName(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(this.columnIndex2ColumnName(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        Object value = this.getValue(columnLabel);
        if (null == value) {
            return null;
        }
        return new BigDecimal(String.valueOf(value));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getBinaryStream");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getBinaryStream");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getBlob");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getBlob");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object value = this.getValue(columnIndex);
        return SFDCResultSet.toBoolean(value);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        Object value = this.getValue(columnLabel);
        return SFDCResultSet.toBoolean(value);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnIndex)).byteValue();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnLabel)).byteValue();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this.getValue(columnIndex));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return bos.toByteArray();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this.getValue(columnLabel));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return bos.toByteArray();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getCharacterStream");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getCharacterStream");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getClob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getClob");
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SFDCResultSet.notSupported("getCursorName");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(this.columnIndex2ColumnName(columnIndex));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(this.columnIndex2ColumnName(columnIndex));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        Object value = this.getValue(columnLabel);
        if (null == value) {
            return null;
        }
        try {
            return Date.valueOf(LocalDate.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_DATE));
        }
        catch (Exception e) {
            throw new SQLException(SFDCMessageUtil.getMessage("0026", value), SFDCSQLState.DATA_CONVERSION_ERROR.getState(), SFDCSQLErrorCode.INVALID_DATE.getErrorCode(), e);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(columnLabel);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnIndex)).doubleValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnLabel)).doubleValue();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnIndex)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnLabel)).floatValue();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw SFDCResultSet.notSupported("getHoldability");
    }

    @Override
    public int getInt(int colIndex) throws SQLException {
        try {
            int value = Integer.valueOf((String)this.getValue(colIndex));
            return value;
        }
        catch (NumberFormatException nfe) {
            throw new SQLException("Failed to fetch value at index = " + colIndex);
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        try {
            int value = Integer.valueOf((String)this.getValue(columnName));
            return value;
        }
        catch (NumberFormatException nfe) {
            throw new SQLException("Failed to fetch value for Column Name = " + columnName);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnIndex)).longValue();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnLabel)).longValue();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.mResultSetMetaData;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getNCharacterStream");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getNCharacterStream");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getNClob");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getNClob");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getNString");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getNString");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getValue(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getValue(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw SFDCResultSet.notSupported("getObject");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw SFDCResultSet.notSupported("getObject");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getRef");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getRef");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        return this.rowId.get();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getRowId");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnIndex)).shortValue();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return SFDCResultSet.toNumber(this.getValue(columnLabel)).shortValue();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getSQLXML");
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkOpen();
        return this.statement;
    }

    @Override
    public String getString(int colIndex) throws SQLException {
        return (String)this.getValue(colIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return (String)this.getValue(columnName);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object value = this.getValue(columnIndex);
        if (null == value) {
            return null;
        }
        try {
            return Time.valueOf(LocalTime.parse(value.toString(), DateTimeFormatter.ofPattern("HH:mm:ss.SSS'Z'")));
        }
        catch (Exception e) {
            throw new SQLException(SFDCMessageUtil.getMessage("0027", value), SFDCSQLState.DATA_CONVERSION_ERROR.getState(), SFDCSQLErrorCode.INVALID_TIME.getErrorCode(), e);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.columnLabel2columnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(this.columnIndex2ColumnName(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(this.columnIndex2ColumnName(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(String columnIndex) throws SQLException {
        Object value = this.getValue(columnIndex);
        if (null == value) {
            return null;
        }
        try {
            return Timestamp.valueOf(LocalDateTime.parse(value.toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ")));
        }
        catch (Exception e) {
            throw new SQLException(SFDCMessageUtil.getMessage("0028", value), SFDCSQLState.DATA_CONVERSION_ERROR.getState(), SFDCSQLErrorCode.INVALID_TIMESTAMP.getErrorCode(), e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(columnLabel);
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getUnicodeStream");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getUnicodeStream");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("getURL");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("getURL");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw SFDCResultSet.notSupported("insertRow");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        return this.afterLast.get();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        return this.beforeFirst.get();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        return 1 == this.rowId.get();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw SFDCResultSet.notSupported("isLast");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public boolean last() throws SQLException {
        throw SFDCResultSet.notSupported("last");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw SFDCResultSet.notSupported("moveToCurrentRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw SFDCResultSet.notSupported("moveToInsertRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw SFDCResultSet.notSupported("refreshRow");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw SFDCResultSet.notSupported("relative");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw SFDCResultSet.notSupported("rowDeleted");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw SFDCResultSet.notSupported("rowInserted");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw SFDCResultSet.notSupported("rowUpdated");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw SFDCResultSet.notSupported("setFetchDirection");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException(SFDCMessageUtil.getMessage("0011", rows), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.NEGATIVE_VALUE_NOT_ALLOWED.getErrorCode());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(SFDCMessageUtil.getMessage("0009", iface), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.INVALID_UNWRAP.getErrorCode());
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw SFDCResultSet.notSupported("updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw SFDCResultSet.notSupported("updateArray");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw SFDCResultSet.notSupported("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SFDCResultSet.notSupported("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLable, InputStream x) throws SQLException {
        throw SFDCResultSet.notSupported("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLable, InputStream x, int length) throws SQLException {
        throw SFDCResultSet.notSupported("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnLable, InputStream x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateAsciiStream");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBigDecimal");
    }

    @Override
    public void updateBigDecimal(String columnLable, BigDecimal x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBigDecimal");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw SFDCResultSet.notSupported("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw SFDCResultSet.notSupported("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateBinaryStream");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBlob");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBlob");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateBlob");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBoolean");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw SFDCResultSet.notSupported("updateByte");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw SFDCResultSet.notSupported("updateByte");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBytes");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw SFDCResultSet.notSupported("updateBytes");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SFDCResultSet.notSupported("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw SFDCResultSet.notSupported("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        throw SFDCResultSet.notSupported("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        throw SFDCResultSet.notSupported("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateCharacterStream");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw SFDCResultSet.notSupported("updateClob");
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        throw SFDCResultSet.notSupported("updateClob");
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw SFDCResultSet.notSupported("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        throw SFDCResultSet.notSupported("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateClob");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw SFDCResultSet.notSupported("updateDate");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw SFDCResultSet.notSupported("updateDate");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw SFDCResultSet.notSupported("updateDouble");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw SFDCResultSet.notSupported("updateDouble");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw SFDCResultSet.notSupported("updateFloat");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw SFDCResultSet.notSupported("updateFloat");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw SFDCResultSet.notSupported("updateInt");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw SFDCResultSet.notSupported("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw SFDCResultSet.notSupported("updateLong");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw SFDCResultSet.notSupported("updateLong");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateNCharacterStream");
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        throw SFDCResultSet.notSupported("updateNClob");
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNString");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw SFDCResultSet.notSupported("updateNull");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw SFDCResultSet.notSupported("updateNull");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int length) throws SQLException {
        throw SFDCResultSet.notSupported("updateNObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw SFDCResultSet.notSupported("updateNObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int length) throws SQLException {
        throw SFDCResultSet.notSupported("updateNObject");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw SFDCResultSet.notSupported("updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw SFDCResultSet.notSupported("updateRef");
    }

    @Override
    public void updateRow() throws SQLException {
        throw SFDCResultSet.notSupported("updateRow");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw SFDCResultSet.notSupported("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw SFDCResultSet.notSupported("updateRowId");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw SFDCResultSet.notSupported("updateShort");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw SFDCResultSet.notSupported("updateShort");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        throw SFDCResultSet.notSupported("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        throw SFDCResultSet.notSupported("updateSQLXML");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw SFDCResultSet.notSupported("updateString");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw SFDCResultSet.notSupported("updateString");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw SFDCResultSet.notSupported("updateTime");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw SFDCResultSet.notSupported("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw SFDCResultSet.notSupported("updateTimestamp");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw SFDCResultSet.notSupported("updateTimestamp");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw SFDCResultSet.notSupported("getObject");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw SFDCResultSet.notSupported("getObject");
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.currentIndex > 0) {
            --this.currentIndex;
            return true;
        }
        return false;
    }

    private static Number toNumber(Object value) throws SQLException {
        if (null == value) {
            return 0;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new SQLException(SFDCMessageUtil.getMessage("0020", value, value.getClass().getCanonicalName()), SFDCSQLState.DATA_CONVERSION_ERROR.getState(), SFDCSQLErrorCode.INVALID_NUMBER.getErrorCode());
    }

    private static Boolean toBoolean(Object value) throws SQLException {
        if (null == value) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("1".equals(value)) {
                return true;
            }
            if ("0".equals(value)) {
                return false;
            }
        } else if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            if (1 == byteValue) {
                return true;
            }
            if (0 == byteValue) {
                return false;
            }
        } else if (value instanceof Short) {
            Short shortValue = (Short)value;
            if (1 == shortValue) {
                return true;
            }
            if (0 == shortValue) {
                return false;
            }
        } else if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            if (1 == integerValue) {
                return true;
            }
            if (0 == integerValue) {
                return false;
            }
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            if (1L == longValue) {
                return true;
            }
            if (0L == longValue) {
                return false;
            }
        }
        throw new SQLException(SFDCMessageUtil.getMessage("0082", value, value.getClass().getCanonicalName()), SFDCSQLState.DATA_CONVERSION_ERROR.getState(), SFDCSQLErrorCode.INVALID_BOOLEAN.getErrorCode());
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(SFDCMessageUtil.getMessage("0022"), SFDCSQLState.JAVA_FUNCTION.getState(), SFDCSQLErrorCode.RESULTSET_CLOSED.getErrorCode());
        }
    }

    private static Map<Integer, String> constructColumnNameLookupMap(SFDCResultSetMetaData resultMD) throws SQLException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (int i = 1; i <= resultMD.getColumnCount(); ++i) {
            result.put(i, resultMD.getColumnLabel(i).toUpperCase());
        }
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, Integer> constructColumnIndexLookupMap(SFDCResultSetMetaData resultMD) throws SQLException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 1; i <= resultMD.getColumnCount(); ++i) {
            result.put(resultMD.getColumnLabel(i).toUpperCase(), i);
        }
        return Collections.unmodifiableMap(result);
    }

    static SFDCResultSet constructEmptyResultSet(SForceTableColumn[] columns) throws SQLException {
        SFDCResultSetMetaData resultSetMeta = new SFDCResultSetMetaData(Arrays.asList(columns));
        ArrayBlockingQueue<Row> queue = new ArrayBlockingQueue<Row>(1);
        queue.add(new EOFRow());
        return new SFDCResultSet(null, queue, resultSetMeta);
    }

    private static SQLFeatureNotSupportedException notSupported(String s) {
        return new SQLFeatureNotSupportedException(SFDCMessageUtil.getMessage("0023", s), SFDCSQLState.FEATURE_NOT_SUPPORTED.getState(), SFDCSQLErrorCode.JDBC_FEATURE_NOT_SUPPORTED.getErrorCode());
    }
}

