/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc;

import com.ibm.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.ibm.cognos.jdbc.sfdc.messages.SFDCMessageUtil;
import com.ibm.cognos.jdbc.sfdc.util.MetadataUtils;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;

public class SFDCResultSetMetaData
implements ResultSetMetaData {
    private List<SForceTableColumn> mColumns = null;

    public SFDCResultSetMetaData(List<SForceTableColumn> columns) {
        this.mColumns = columns;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String result;
        SForceTableColumn currentColumn = this.getColumn(column);
        int type = MetadataUtils.inferDataTypeAsJDBC(currentColumn.getDataType());
        switch (type) {
            case -9: 
            case 12: {
                result = String.class.getName();
                break;
            }
            case 16: {
                result = Boolean.class.getName();
                break;
            }
            case 4: {
                result = Integer.class.getName();
                break;
            }
            case -5: {
                result = Long.class.getName();
                break;
            }
            case 8: {
                result = Double.class.getName();
                break;
            }
            case 2: 
            case 3: {
                result = Number.class.getName();
                break;
            }
            case 91: {
                result = Date.class.getName();
                break;
            }
            case 93: 
            case 2014: {
                result = Timestamp.class.getName();
                break;
            }
            case 92: {
                result = Time.class.getName();
                break;
            }
            default: {
                throw new SQLException(SFDCMessageUtil.getMessage("0015", type));
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (this.mColumns != null) {
            return this.mColumns.size();
        }
        return 0;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return MetadataUtils.getColumnSize(this.getColumn(column));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return MetadataUtils.inferDataTypeAsJDBC(this.getColumn(column).getDataType());
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn(column).getDataType().name();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumn(column).getTable();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumn(column).isNillable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    private SForceTableColumn getColumn(int column) throws SQLException {
        if (column <= 0 || column > this.mColumns.size()) {
            throw new SQLException(SFDCMessageUtil.getMessage("0016", column));
        }
        return this.mColumns.get(column - 1);
    }
}

