/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.request;

import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class SForceUtil {
    public static String rewriteServerSessionURL(String originalURL) {
        boolean isHTTPS = false;
        String hostPortPart = null;
        int index = -1;
        if (originalURL.startsWith("http://") || originalURL.startsWith("HTTP://")) {
            index = originalURL.indexOf("/", 7);
            hostPortPart = index == -1 ? originalURL : originalURL.substring(7, index);
        } else if (originalURL.startsWith("https://") || originalURL.startsWith("HTTPS://")) {
            isHTTPS = true;
            index = originalURL.indexOf("/", 8);
            hostPortPart = index == -1 ? originalURL : originalURL.substring(8, index);
        } else {
            return originalURL;
        }
        int indexOfColon = hostPortPart.indexOf(":");
        if (indexOfColon == -1) {
            String portNum = "80";
            if (isHTTPS) {
                portNum = "443";
            }
            StringBuffer newURL = new StringBuffer();
            if (isHTTPS) {
                newURL.append("https://");
            } else {
                newURL.append("http://");
            }
            newURL.append(hostPortPart);
            newURL.append(":");
            newURL.append(portNum);
            newURL.append(originalURL.substring(newURL.length() - portNum.length() - 1));
            return newURL.toString();
        }
        return originalURL;
    }

    public static void setProxy(HttpClient httpclient, SForceConnectionParams connectionParams) {
        try {
            if (connectionParams.isProxyEnabled()) {
                String hostName = connectionParams.getProxyHost();
                int proxyPort = connectionParams.getProxyPort();
                String proxyUserName = connectionParams.getProxyUserName();
                String password = connectionParams.getProxyPassword();
                if (hostName != null && hostName.length() > 0) {
                    httpclient.getHostConfiguration().setProxy(hostName, proxyPort);
                    if (proxyUserName != null && proxyUserName.length() > 0) {
                        if (SForceUtil.isProxyNTLMAuthentication(connectionParams)) {
                            int index = proxyUserName.indexOf("\\");
                            String domain = proxyUserName.substring(0, index);
                            String userName = proxyUserName.substring(index + 1);
                            NTCredentials ntCreds = new NTCredentials(userName, password, InetAddress.getLocalHost().getHostName(), domain);
                            httpclient.getState().setProxyCredentials(new AuthScope(hostName, proxyPort), (Credentials)ntCreds);
                        } else {
                            httpclient.getState().setProxyCredentials(new AuthScope(hostName, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                        }
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            throw new SForceException(e);
        }
    }

    public static boolean isProxyNTLMAuthentication(SForceConnectionParams connectionParams) {
        String userName = connectionParams.getProxyUserName();
        if (userName == null) {
            return false;
        }
        return userName.matches("([A-Z]|[a-z]|[0-9])+\\\\([A-Z]|[a-z]|[0-9])+");
    }

    public static String stripEnclosures(String inputString, char enclosedChar) {
        int startIndex = 0;
        int endIndex = 0;
        if (inputString == null) {
            return inputString;
        }
        startIndex = inputString.indexOf(enclosedChar);
        endIndex = inputString.lastIndexOf(enclosedChar);
        if (startIndex > -1 && startIndex < endIndex) {
            return inputString.substring(startIndex + 1, endIndex);
        }
        return inputString;
    }
}

