/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.request.provider.rest;

import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceUtil;
import com.cognos.cdms.ds.sforce.request.provider.SForceAPIProvider;
import com.cognos.cdms.ds.sforce.request.rest.transport.SForceRestAPIStubFactory;
import com.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.cognos.cdms.ds.sforce.request.session.rest.SForceRestAPISession;
import com.cognos.cdms.ds.sforce.soql.cursors.SForceSOQLCursor;
import com.cognos.cdms.ds.sforce.soql.cursors.rest.SForceRESTSOQLCursor;
import com.cognos.cdms.ds.sforce.soql.parsers.ISForceSOQLQuery;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceRestAPIProvider
extends SForceAPIProvider {
    private static final Logger logger = LoggerFactory.getLogger(SForceRestAPIProvider.class);

    @Override
    public SForceSessionKey login(SForceConnectionParams connectionParams) throws SForceAPIException {
        String responseBody = null;
        if (logger.isDebugEnabled()) {
            logger.debug(" try login REST " + connectionParams.toString());
        }
        try {
            SForceRestAPIStubFactory apiStubFactory = SForceRestAPIStubFactory.getInstance();
            HttpClient client = apiStubFactory.getHttpClient(connectionParams);
            String loginURL = this.getLoginUrl(connectionParams);
            PostMethod post = apiStubFactory.getPostMethod(loginURL);
            post.addParameter("grant_type", "password");
            post.addParameter("client_id", connectionParams.getClientId());
            post.addParameter("client_secret", connectionParams.getClientSecret());
            post.addParameter("username", connectionParams.getUserName());
            post.addParameter("password", connectionParams.getPassword());
            client.executeMethod((HttpMethod)post);
            responseBody = post.getResponseBodyAsString();
            JSONObject json = null;
            json = JSONObject.parse((String)responseBody);
            String accessToken = (String)json.get((Object)"access_token");
            if (accessToken == null) {
                throw new SForceAPIException(responseBody);
            }
            String sessionUrl = SForceUtil.rewriteServerSessionURL((String)json.get((Object)"instance_url"));
            String organizationId = null;
            String id = (String)json.get((Object)"id");
            if (id != null) {
                int endIndexOfOrgId = id.lastIndexOf("/");
                int indexOfStartOfOrgId = id.lastIndexOf("/", endIndexOfOrgId - 1);
                if (endIndexOfOrgId != -1 && indexOfStartOfOrgId != -1) {
                    organizationId = id.substring(indexOfStartOfOrgId + 1, endIndexOfOrgId);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" retrieved sessionKey " + accessToken);
            }
            SForceSessionKey sessionKey = new SForceSessionKey(accessToken, sessionUrl, organizationId, connectionParams.getConnectionKey());
            return sessionKey;
        }
        catch (HttpException e) {
            throw new SForceAPIException(e);
        }
        catch (IOException e) {
            if (responseBody != null && responseBody.length() > 0) {
                throw new SForceAPIException(responseBody);
            }
            throw new SForceAPIException(e);
        }
    }

    @Override
    public ISForceSession createSession(SForceConnectionParams connectionParams, SForceSessionKey sessionKey) throws SForceAPIException {
        return new SForceRestAPISession(SForceRestAPIStubFactory.getInstance().getHttpClient(connectionParams), connectionParams, sessionKey);
    }

    @Override
    public SForceSOQLCursor createSOQLCursor(SForceConnectionParams connectionParams, ISForceSOQLQuery query) {
        return new SForceRESTSOQLCursor(connectionParams, query);
    }

    @Override
    protected String getLoginURLPath() {
        return "/services/oauth2/token";
    }
}

