/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.request.provider.soap.axis2;

import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.provider.SForceAPIProvider;
import com.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.cognos.cdms.ds.sforce.request.session.soap.axis2.SForceAxis2SOAPAPISession;
import com.cognos.cdms.ds.sforce.soql.cursors.SForceSOQLCursor;
import com.cognos.cdms.ds.sforce.soql.cursors.soap.axis2.SForceAxis2SOAPSOQLCursor;
import com.cognos.cdms.ds.sforce.soql.parsers.ISForceSOQLQuery;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceAxis2SOAPAPIProvider
extends SForceAPIProvider {
    private static final Logger logger = LoggerFactory.getLogger(SForceAxis2SOAPAPIProvider.class);
    private static int ONE_SECOND_IN_MILLI_SECONDS = 1000;
    private ConnectorConfig config = new ConnectorConfig();
    private PartnerConnection connection = null;

    @Override
    public SForceSessionKey login(SForceConnectionParams connectionParams) throws SForceAPIException {
        if (logger.isDebugEnabled()) {
            logger.debug(" try login Axis2 SOAP " + connectionParams.toString());
        }
        try {
            if (connectionParams.isProxyEnabled()) {
                this.config.setProxy(connectionParams.getProxyHost(), connectionParams.getProxyPort());
                this.config.setProxyUsername(connectionParams.getProxyUserName());
                this.config.setPassword(connectionParams.getProxyPassword());
            }
            this.config.setAuthEndpoint(connectionParams.getUrl());
            this.config.setServiceEndpoint(connectionParams.getUrl());
            this.config.setManualLogin(true);
            this.connection = Connector.newConnection((ConnectorConfig)this.config);
            LoginResult loginResult = this.connection.login(connectionParams.getUserName(), connectionParams.getPassword());
            String sessionId = loginResult.getSessionId();
            String serverUrl = loginResult.getServerUrl();
            String organizationId = loginResult.getUserInfo().getOrganizationId();
            SForceSessionKey sessionKey = new SForceSessionKey(sessionId, serverUrl, organizationId, connectionParams.getConnectionKey());
            this.config.setAuthEndpoint(loginResult.getServerUrl());
            this.config.setServiceEndpoint(loginResult.getServerUrl());
            this.config.setManualLogin(true);
            this.config.setSessionId(sessionId);
            this.connection = Connector.newConnection((ConnectorConfig)this.config);
            return sessionKey;
        }
        catch (ConnectionException e) {
            throw new SForceAPIException(e);
        }
    }

    @Override
    public ISForceSession createSession(SForceConnectionParams connectionParams, SForceSessionKey sessionKey) throws SForceAPIException {
        return new SForceAxis2SOAPAPISession(this.connection, connectionParams, sessionKey);
    }

    @Override
    public SForceSOQLCursor createSOQLCursor(SForceConnectionParams connectionParams, ISForceSOQLQuery query) {
        return new SForceAxis2SOAPSOQLCursor(connectionParams, query);
    }

    @Override
    protected String getLoginURLPath() {
        return "/services/Soap/u/49.0";
    }
}

