/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.request.session.rest;

import com.cognos.cdms.ds.sforce.introspect.objects.SForceTable;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTableInfo;
import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.cognos.cdms.ds.sforce.request.rest.transport.SForceRestAPIStubFactory;
import com.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResult;
import com.cognos.cdms.ds.sforce.request.resultset.rest.SForceRESTQueryResult;
import com.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceRestAPISession
implements ISForceSession {
    private static final Logger logger = LoggerFactory.getLogger(SForceRestAPISession.class);
    private SForceConnectionParams connectionParams;
    private SForceSessionKey sessionKey;
    private static final String STR_QUERY = "/query/";
    private static final String STR_SOBJECTS = "/sobjects/";
    private HttpClient httpClient;

    public SForceRestAPISession(HttpClient httpClient, SForceConnectionParams connectionParams, SForceSessionKey sessionKey) {
        this.httpClient = httpClient;
        this.connectionParams = connectionParams;
        this.sessionKey = sessionKey;
    }

    @Override
    public String getOrganizationKey() {
        return this.sessionKey.getOrganizationId() + ":" + this.connectionParams.getDataSourceId();
    }

    @Override
    public String getConnectionKey() {
        return this.sessionKey.getConnectionKey();
    }

    private SForceConnectionParams getConnectionParameters() {
        return this.connectionParams;
    }

    @Override
    public int getConcurrentCallsLimit() {
        return this.connectionParams.getConcurrentCallsLimit();
    }

    @Override
    public int getUserConcurrentCallsLimit() {
        return this.connectionParams.getUserConcurrentCallsLimit();
    }

    @Override
    public SForceTable[] getTables() throws SForceAPIException {
        OrderedJSONObject response = null;
        ArrayList<SForceTable> list = new ArrayList<SForceTable>();
        String name = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Call describe global");
        }
        try {
            response = this.makeRestBasedCall("GET", this.getSessionServerUrl() + "/services/data/v49.0/sobjects/", null);
            if (logger.isDebugEnabled()) {
                logger.debug(response.serialize());
            }
            JSONArray sobjects = (JSONArray)response.get((Object)"sobjects");
            JSONObject sobject = null;
            SForceTable stable = null;
            if (sobjects != null) {
                for (int i = 0; i < sobjects.size(); ++i) {
                    sobject = (JSONObject)sobjects.get(i);
                    name = (String)sobject.get((Object)"name");
                    boolean queriable = (Boolean)sobject.get((Object)"queryable");
                    stable = new SForceTable(name, queriable);
                    list.add(stable);
                }
            }
        }
        catch (HttpException e) {
            throw new SForceAPIException(e);
        }
        catch (IOException e) {
            throw new SForceAPIException(e);
        }
        return list.toArray(new SForceTable[0]);
    }

    @Override
    public SForceTableInfo getTableMetadata(String objectName) throws SForceAPIException {
        String name = null;
        String type = null;
        ArrayList<String> referenceTo = new ArrayList<String>();
        String relationshipName = null;
        OrderedJSONObject response = null;
        ArrayList<SForceTableColumn> list = new ArrayList<SForceTableColumn>();
        if (logger.isDebugEnabled()) {
            logger.debug("Call Rest Describe Sobject");
        }
        try {
            response = this.makeRestBasedCall("GET", this.getSessionServerUrl() + "/services/data/v49.0/sobjects/", objectName);
            JSONArray fields = (JSONArray)response.get((Object)"fields");
            JSONArray references = null;
            String referenceObject = null;
            JSONObject sobject = null;
            SForceTableColumn stableColumn = null;
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    sobject = (JSONObject)fields.get(i);
                    name = (String)sobject.get((Object)"name");
                    type = (String)sobject.get((Object)"type");
                    boolean nillable = (Boolean)sobject.get((Object)"nillable");
                    boolean idLookup = (Boolean)sobject.get((Object)"idLookup");
                    references = (JSONArray)sobject.get((Object)"referenceTo");
                    for (int referencesCount = 0; referencesCount < references.size(); ++referencesCount) {
                        referenceObject = (String)references.get(referencesCount);
                        if (referenceObject == null) continue;
                        referenceTo.add(referenceObject);
                    }
                    relationshipName = (String)sobject.get((Object)"relationshipName");
                    long length = (Long)sobject.get((Object)"length");
                    long scale = (Long)sobject.get((Object)"scale");
                    long precision = (Long)sobject.get((Object)"precision");
                    long digits = (Long)sobject.get((Object)"digits");
                    stableColumn = new SForceTableColumn(name, type, nillable, idLookup, referenceTo.toArray(new String[0]), relationshipName, (int)length, (int)scale, (int)precision, (int)digits);
                    list.add(stableColumn);
                }
            }
        }
        catch (HttpException e) {
            throw new SForceAPIException(e);
        }
        catch (IOException e) {
            throw new SForceAPIException(e);
        }
        return new SForceTableInfo(objectName, list.toArray(new SForceTableColumn[0]), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, SForceTableInfo> getTablesMetadata(String[] objectNames) throws SForceAPIException {
        ExecutorService execService = Executors.newFixedThreadPool(10);
        try {
            HashMap<String, SForceTableInfo> tableMetadata = new HashMap<String, SForceTableInfo>(objectNames.length);
            ArrayList<Future<SForceTableInfo>> futureTasks = new ArrayList<Future<SForceTableInfo>>();
            String[] stringArray = objectNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String objectName;
                final String finalObjectName = objectName = stringArray[i];
                Callable<SForceTableInfo> worker = new Callable<SForceTableInfo>(){

                    @Override
                    public SForceTableInfo call() throws Exception {
                        HttpClient httpClient = SForceRestAPIStubFactory.getInstance().getHttpClient(SForceRestAPISession.this.connectionParams);
                        SForceRestAPISession newSession = new SForceRestAPISession(httpClient, SForceRestAPISession.this.connectionParams, SForceRestAPISession.this.sessionKey);
                        return newSession.getTableMetadata(finalObjectName);
                    }
                };
                futureTasks.add(execService.submit(worker));
            }
            for (Future future : futureTasks) {
                try {
                    SForceTableInfo tableInfo = (SForceTableInfo)future.get();
                    tableMetadata.put(tableInfo.getName(), tableInfo);
                }
                catch (InterruptedException e) {
                    throw new SForceAPIException(e);
                }
                catch (ExecutionException e) {
                    throw new SForceAPIException(e);
                }
            }
            HashMap<String, SForceTableInfo> hashMap = tableMetadata;
            return hashMap;
        }
        finally {
            execService.shutdown();
        }
    }

    @Override
    public SForceSessionKey getSessionkey() {
        return this.sessionKey;
    }

    @Override
    public SForceResultSet query(String sql, boolean retrieveAllBatches) throws SForceAPIException {
        String sforceQuery = sql;
        long totalSize = 0L;
        String queryLocator = null;
        try {
            if (!retrieveAllBatches) {
                sforceQuery = sforceQuery + " LIMIT " + 2000;
            }
            OrderedJSONObject qr = this.makeRestBasedCall("GET", this.getSessionServerUrl() + "/services/data/v49.0/query/", sforceQuery);
            JSONArray records = (JSONArray)qr.get((Object)"records");
            boolean done = (Boolean)qr.get((Object)"done");
            totalSize = (Long)qr.get((Object)"totalSize");
            queryLocator = (String)qr.get((Object)"nextRecordsUrl");
            SForceRESTQueryResult resultSet = new SForceRESTQueryResult(records, totalSize, done, queryLocator);
            return new SForceResultSet(resultSet, this.getConnectionParameters(), retrieveAllBatches);
        }
        catch (HttpException e) {
            throw new SForceAPIException(e);
        }
        catch (IOException e) {
            throw new SForceAPIException(e);
        }
    }

    @Override
    public ISForceQueryResult queryMore(String queryLocator) throws SForceAPIException {
        if (logger.isDebugEnabled()) {
            logger.debug("query more " + queryLocator);
        }
        SForceRESTQueryResult resultSet = null;
        long totalSize = 0L;
        String receivedQueryLocator = null;
        try {
            OrderedJSONObject qr = this.makeRestBasedCall("GET", this.getSessionServerUrl() + queryLocator, null);
            JSONArray records = (JSONArray)qr.get((Object)"records");
            boolean done = (Boolean)qr.get((Object)"done");
            totalSize = (Long)qr.get((Object)"totalSize");
            receivedQueryLocator = (String)qr.get((Object)"nextRecordsUrl");
            resultSet = new SForceRESTQueryResult(records, totalSize, done, receivedQueryLocator);
        }
        catch (HttpException e) {
            throw new SForceAPIException(e);
        }
        catch (IOException e) {
            throw new SForceAPIException(e);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedJSONObject makeRestBasedCall(String callType, String restUrl, String param) throws IOException, HttpException {
        OrderedJSONObject response = null;
        GetMethod method = null;
        NameValuePair[] params = null;
        BufferedReader br = null;
        InputStreamReader isr = null;
        GZIPInputStream gzis = null;
        String contentEncoding = null;
        StringBuilder sb = null;
        try {
            if (restUrl.indexOf(STR_SOBJECTS) >= 0) {
                if (param != null && !param.equals("")) {
                    restUrl = restUrl + param + "/describe/";
                }
            } else if (restUrl.indexOf(STR_QUERY) >= 0 && param != null) {
                params = new NameValuePair[]{new NameValuePair("q", param)};
            }
            if (callType.equals("GET")) {
                method = SForceRestAPIStubFactory.getInstance().getGetMethod(restUrl);
            } else if (callType.equals("POST")) {
                method = SForceRestAPIStubFactory.getInstance().getPostMethod(restUrl);
            }
            method.setRequestHeader("Authorization", "OAuth " + this.sessionKey.getSessionID());
            method.setRequestHeader("Accept-Encoding", "gzip");
            if (params != null) {
                method.setQueryString(params);
            }
            this.httpClient.executeMethod((HttpMethod)method);
            Header header = method.getResponseHeader("Content-Encoding");
            if (header != null) {
                contentEncoding = header.getValue();
            }
            if (contentEncoding != null && contentEncoding.equals("gzip")) {
                gzis = new GZIPInputStream(method.getResponseBodyAsStream());
                isr = new InputStreamReader((InputStream)gzis, "utf-8");
                br = new BufferedReader(isr);
            } else {
                isr = new InputStreamReader(method.getResponseBodyAsStream(), "utf-8");
                br = new BufferedReader(isr);
            }
            if (br != null) {
                sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            } else {
                throw new RuntimeException("Input stream reads null response");
            }
            if (sb != null) {
                if (sb.charAt(0) == '[') {
                    sb = new StringBuilder(sb.substring(1, sb.length() - 1));
                }
                if ((response = (OrderedJSONObject)OrderedJSONObject.parse((String)sb.toString())).containsKey((Object)"errorCode")) {
                    throw new RuntimeException(sb.toString());
                }
            } else {
                response = (OrderedJSONObject)OrderedJSONObject.parse((InputStream)method.getResponseBodyAsStream());
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (gzis != null) {
                gzis.close();
            }
            if (method != null) {
                method.releaseConnection();
            }
        }
        return response;
    }

    private String getSessionServerUrl() {
        String serverUrl = this.sessionKey.getSessionServerURL();
        int index = serverUrl.indexOf(47, 8);
        if (index != -1) {
            return serverUrl.substring(0, index);
        }
        return serverUrl;
    }
}

