/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.request.session.soap.axis2;

import com.cognos.cdms.ds.sforce.introspect.objects.SForceChildRelationShipInfo;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTable;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTableColumn;
import com.cognos.cdms.ds.sforce.introspect.objects.SForceTableInfo;
import com.cognos.cdms.ds.sforce.request.SForceConnectionParams;
import com.cognos.cdms.ds.sforce.request.SForceResultSet;
import com.cognos.cdms.ds.sforce.request.resultset.ISForceQueryResult;
import com.cognos.cdms.ds.sforce.request.session.ISForceSession;
import com.cognos.cdms.ds.sforce.request.session.SForceAPIException;
import com.cognos.cdms.ds.sforce.request.session.SForceSessionKey;
import com.sforce.soap.partner.ChildRelationship;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.SessionHeader_element;
import com.sforce.soap.partner.fault.InvalidSObjectFault;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import com.sforce.ws.ConnectionException;
import java.util.HashMap;

public class SForceAxis2SOAPAPISession
implements ISForceSession {
    private PartnerConnection connection;
    private SForceConnectionParams connectionParams;
    private SForceSessionKey sessionKey;

    public SForceAxis2SOAPAPISession(PartnerConnection connection, SForceConnectionParams connectionParams, SForceSessionKey sessionKey) {
        this.connection = connection;
        this.connectionParams = connectionParams;
        this.sessionKey = sessionKey;
    }

    @Override
    public int getConcurrentCallsLimit() {
        return this.connectionParams.getConcurrentCallsLimit();
    }

    @Override
    public int getUserConcurrentCallsLimit() {
        return this.connectionParams.getUserConcurrentCallsLimit();
    }

    @Override
    public String getConnectionKey() {
        return this.sessionKey.getConnectionKey();
    }

    @Override
    public String getOrganizationKey() {
        return this.sessionKey.getOrganizationId() + ":" + this.connectionParams.getDataSourceId();
    }

    @Override
    public SForceSessionKey getSessionkey() {
        return this.sessionKey;
    }

    private SessionHeader_element getSessionHeader(String sessionId) {
        SessionHeader_element headerDoc = new SessionHeader_element();
        headerDoc.setSessionId(sessionId);
        return headerDoc;
    }

    @Override
    public SForceTable[] getTables() throws SForceAPIException, ConnectionException {
        try {
            DescribeGlobalResult globalRes = this.connection.describeGlobal();
            DescribeGlobalSObjectResult[] sobjs = globalRes.getSobjects();
            SForceTable[] tables = new SForceTable[sobjs.length];
            for (int i = 0; i < sobjs.length; ++i) {
                tables[i] = new SForceTable(sobjs[i].getName(), sobjs[i].getQueryable());
            }
            return tables;
        }
        catch (UnexpectedErrorFault e) {
            throw new SForceAPIException(e.getExceptionMessage());
        }
    }

    @Override
    public SForceTableInfo getTableMetadata(String objectName) throws SForceAPIException, ConnectionException {
        try {
            DescribeSObjectResult res = this.connection.describeSObject(objectName);
            return this.createTableColumnResult(res);
        }
        catch (InvalidSObjectFault e) {
            throw new SForceAPIException(e);
        }
        catch (UnexpectedErrorFault e) {
            throw new SForceAPIException(e.getExceptionMessage());
        }
    }

    @Override
    public HashMap<String, SForceTableInfo> getTablesMetadata(String[] objectNames) throws SForceAPIException, ConnectionException {
        try {
            DescribeSObjectResult[] descSobjsResult = this.connection.describeSObjects(objectNames);
            return this.createMultipleTableColumnResult(descSobjsResult);
        }
        catch (UnexpectedErrorFault ue) {
            throw new SForceAPIException(ue.getExceptionMessage());
        }
        catch (InvalidSObjectFault e) {
            throw new SForceAPIException(e);
        }
    }

    private HashMap<String, SForceTableInfo> createMultipleTableColumnResult(DescribeSObjectResult[] descSobjsResult) {
        HashMap<String, SForceTableInfo> multipleTabColResult = new HashMap<String, SForceTableInfo>();
        for (DescribeSObjectResult sobjResult : descSobjsResult) {
            multipleTabColResult.put(sobjResult.getName(), this.createTableColumnResult(sobjResult));
        }
        return multipleTabColResult;
    }

    private SForceTableInfo createTableColumnResult(DescribeSObjectResult sobjResult) {
        Field[] fields = sobjResult.getFields();
        SForceTableColumn[] columns = new SForceTableColumn[fields.length];
        for (int index = 0; index < columns.length; ++index) {
            columns[index] = new SForceTableColumn(fields[index].getName(), fields[index].getType().toString(), fields[index].getNillable(), fields[index].getIdLookup(), fields[index].getReferenceTo(), fields[index].getRelationshipName(), fields[index].getLength(), fields[index].getScale(), fields[index].getPrecision(), fields[index].getDigits());
        }
        return new SForceTableInfo(sobjResult.getName(), columns, this.getChildRelationshipInfo(sobjResult));
    }

    private SForceChildRelationShipInfo[] getChildRelationshipInfo(DescribeSObjectResult sobjResult) {
        ChildRelationship[] rels = sobjResult.getChildRelationships();
        SForceChildRelationShipInfo[] childInfo = null;
        if (rels != null) {
            childInfo = new SForceChildRelationShipInfo[rels.length];
            int index = 0;
            for (ChildRelationship rel : rels) {
                SForceChildRelationShipInfo info;
                childInfo[index] = info = new SForceChildRelationShipInfo(rel.getChildSObject(), rel.getDeprecatedAndHidden(), rel.getField(), rel.getRelationshipName());
                ++index;
            }
        }
        return childInfo;
    }

    @Override
    public ISForceQueryResult queryMore(String queryLocator) throws SForceAPIException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SForceResultSet query(String sql, boolean retrieveAllBatches) throws SForceAPIException {
        throw new UnsupportedOperationException();
    }
}

