/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cdms.ds.sforce.soql.parsers;

import com.cognos.cdms.ds.sforce.request.SForceException;
import com.cognos.cdms.ds.sforce.soql.parsers.AbstractSForceSOQLQuery;
import com.cognos.cdms.ds.sforce.soql.parsers.ParseException;
import com.cognos.cdms.ds.sforce.soql.parsers.SForceSOQLQuerySelectable;
import com.cognos.cdms.ds.sforce.soql.parsers.SForceSOQLQuerySelectableType;
import com.cognos.cdms.ds.sforce.soql.parsers.SOQLParser;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SForceSOQLQuery
extends AbstractSForceSOQLQuery {
    private static final Logger logger = LoggerFactory.getLogger(SForceSOQLQuery.class);
    private static final String SEPARATOR = " ";
    Pattern function = Pattern.compile("(\\(.*\\))");
    private Set<String> sobjects = new LinkedHashSet<String>();
    private Set<String> queryResults = new LinkedHashSet<String>();
    private String outerTableName;

    @Override
    public Set<String> getQueryResultList() {
        return this.queryResults;
    }

    private void addQueryResult(String queryResultName) {
        this.queryResults.add(queryResultName.toLowerCase());
    }

    @Override
    public boolean isQueryResult(String resultSetName) {
        return this.queryResults.contains(resultSetName.toLowerCase());
    }

    @Override
    public Set<String> getSObjectList() {
        return this.sobjects;
    }

    public SForceSOQLQuery(String soql) {
        super(soql);
        if (logger.isDebugEnabled()) {
            logger.debug("Parsing soql " + soql);
        }
        this.init(this.soql);
    }

    @Override
    public boolean isSObject(String objectName) {
        return this.sobjects.contains(objectName.toLowerCase());
    }

    private void addSObject(String objectName) {
        this.sobjects.add(objectName.toLowerCase());
    }

    private void processColumn(String currentToken, SForceSOQLQuerySelectable top, AtomicInteger posCounter) {
        ++this.numberOfColumns;
        boolean hasAlias = false;
        String aliasName = null;
        int aliasIndex = currentToken.indexOf(SEPARATOR);
        if (aliasIndex != -1) {
            hasAlias = true;
            aliasName = currentToken.substring(aliasIndex).trim();
        }
        StringTokenizer tokenizer = new StringTokenizer(currentToken, ".");
        while (tokenizer.hasMoreTokens()) {
            String newToken = tokenizer.nextToken().trim();
            if (tokenizer.hasMoreTokens()) {
                if (this.isQueryResult(top.getRelationShipName() + "." + newToken)) {
                    top = top.createChild(newToken, SForceSOQLQuerySelectableType.QUERYRESULT, -1);
                    continue;
                }
                top = top.createChild(newToken, SForceSOQLQuerySelectableType.SOBJECT, -1);
                this.addSObject(top.getFullName());
                continue;
            }
            if (hasAlias) {
                newToken = aliasName;
            } else if (this.isFunction(newToken)) {
                newToken = this.getFunctionAlias();
            }
            top.createChild(newToken, SForceSOQLQuerySelectableType.ELEMENT, posCounter.getAndIncrement());
        }
    }

    private boolean isFunction(String newToken) {
        Matcher m = this.function.matcher(newToken);
        return m.find();
    }

    private void init(String soql) {
        String newSoql = soql.replaceAll("\\\\'", "");
        SOQLParser parser = new SOQLParser(newSoql);
        try {
            parser.parse();
        }
        catch (ParseException e) {
            throw new SForceException(1900013, e.getMessage());
        }
        ArrayList<String> columnsList = parser.getColumnsList();
        ArrayList<String> tableList = parser.getInnerTableList();
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully parsed soql " + soql);
            logger.debug("Columns " + columnsList);
            logger.debug("Table list " + tableList);
        }
        AtomicInteger posCounter = new AtomicInteger(1);
        String firstColumn = columnsList.get(0);
        this.outerTableName = this.getMainTableName(firstColumn);
        this.processInnerTableList(tableList);
        this.top = new SForceSOQLQuerySelectable(this.outerTableName, SForceSOQLQuerySelectableType.QUERYRESULT, null, -1);
        this.processColumns(columnsList, this.outerTableName, this.top, posCounter);
    }

    private void processInnerTableList(ArrayList<String> tableList) {
        for (String tableName : tableList) {
            this.addQueryResult(tableName);
        }
    }

    private String getMainTableName(String firstColumn) {
        int index = firstColumn.indexOf(46);
        return firstColumn.substring(0, index);
    }

    private void processColumns(ArrayList<String> colList, String tableName, SForceSOQLQuerySelectable top, AtomicInteger posCounter) {
        for (String columnName : colList) {
            String name = columnName;
            if (this.containsTableName(name, tableName)) {
                name = name.substring(tableName.length() + 1);
            }
            this.processColumn(name, top, posCounter);
        }
    }

    private boolean containsTableName(String token, String tableName) {
        return token.trim().toLowerCase().indexOf(tableName.toLowerCase() + ".") == 0;
    }

    @Override
    public String getOuterTableName() {
        return this.outerTableName;
    }
}

