/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool;

import com.cognos.css.skintool.CognosBIUnavailableException;
import com.cognos.css.skintool.Console;
import com.cognos.css.skintool.CssServiceImpl;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.Prompt;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.DisplayObject;
import com.cognos.developer.schemas.bibus._3.PromptOption;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;

public class CRNConnect {
    private static final String CAM_NAMESPACE_DISPLAY_NAME = "CAMNamespaceDisplayName";
    private static final String CAM_NAMESPACE = "CAMNamespace";
    private static final String BI_BUS_HEADER = "biBusHeader";
    private static final String BIBUS_SCHEMA = "http://developer.cognos.com/schemas/bibus/3/";
    private static final String CAN_USE_PORTAL_ADMINISTRATION_TOOL = "canUsePortalAdministrationTool";
    private static CRNConnect crnConnect;
    private ContentManagerService_ServiceLocator cmServiceLocator = null;
    private ContentManagerService_PortType cmService = null;
    private Prompt prompt = Prompt.getInstance();
    public static String CM_URL;

    private CRNConnect() {
        this.cmServiceLocator = new ContentManagerService_ServiceLocator();
        CM_URL = Console.getDispatcher();
    }

    public static synchronized CRNConnect getInstance() {
        if (crnConnect == null) {
            crnConnect = new CRNConnect();
        }
        return crnConnect;
    }

    public ContentManagerService_PortType connectToCognosServer() {
        return this.connectToCognosServer(CM_URL);
    }

    public ContentManagerService_PortType connectToCognosServer(String CMURL) {
        CM_URL = CMURL;
        try {
            URL serverURL = new URL(CMURL);
            this.cmService = this.cmServiceLocator.getcontentManagerService(serverURL);
            return this.cmService;
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL:\n" + e.getMessage());
            return null;
        }
        catch (ServiceException e) {
            System.out.println("Service Exception:\n" + e.getMessage());
            return null;
        }
    }

    public ContentManagerService_PortType connectionChange(String endPoint) {
        return this.connectToCognosServer(endPoint);
    }

    public ContentManagerService_PortType getCMService() {
        return this.cmService;
    }

    public String[] getNamespaces() throws CognosBIUnavailableException {
        try {
            this.cmService.query(new SearchPathMultipleObject("/"), new PropEnum[0], new Sort[0], new QueryOptions());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        SOAPHeaderElement temp = ((Stub)this.cmService).getResponseHeader(BIBUS_SCHEMA, BI_BUS_HEADER);
        BiBusHeader bibus = null;
        try {
            bibus = (BiBusHeader)temp.getValueAsType(new QName(BIBUS_SCHEMA, BI_BUS_HEADER));
        }
        catch (Exception e) {
            throw new CognosBIUnavailableException(e.getMessage());
        }
        ((Stub)this.cmService).setHeader(BIBUS_SCHEMA, BI_BUS_HEADER, (Object)bibus);
        Object namespaces = new String[]{};
        try {
            DisplayObject[] dob = bibus.getCAM().getException().getPromptInfo().getDisplayObjects();
            for (int i = 0; i < dob.length; ++i) {
                if (!dob[i].getName().equalsIgnoreCase(CAM_NAMESPACE)) continue;
                PromptOption[] pop = dob[i].getPromptOptions();
                if (pop != null) {
                    namespaces = new String[pop.length * 2];
                    int j = 0;
                    for (int k = 0; k < pop.length; ++k) {
                        namespaces[j] = pop[k].getValue();
                        namespaces[++j] = pop[k].getId();
                        ++j;
                    }
                    continue;
                }
                namespaces = dob[i + 1].getName().equalsIgnoreCase(CAM_NAMESPACE_DISPLAY_NAME) ? new String[]{dob[i + 1].getValue(), dob[i].getValue()} : null;
            }
        }
        catch (NullPointerException npe) {
            namespaces = null;
        }
        ((Stub)this.cmService).clearHeaders();
        return namespaces;
    }

    public boolean doLogin(String userName, char[] password, String nameSpace) throws CognosBIUnavailableException {
        boolean adminFlag;
        block8: {
            adminFlag = false;
            if (this.isValidNamespace(nameSpace)) {
                try {
                    if (this.cmService != null) {
                        this.cmService.logon(new XmlEncodedXML(this.encodeCredentials(userName, password, nameSpace)), new SearchPathSingleObject[0]);
                        SOAPHeaderElement temp = ((Stub)this.cmService).getResponseHeader(BIBUS_SCHEMA, BI_BUS_HEADER);
                        BiBusHeader bibus = null;
                        try {
                            bibus = (BiBusHeader)temp.getValueAsType(new QName(BIBUS_SCHEMA, BI_BUS_HEADER));
                        }
                        catch (Exception e) {
                            throw new CognosBIUnavailableException(e.getMessage());
                        }
                        ((Stub)this.cmService).setHeader(BIBUS_SCHEMA, BI_BUS_HEADER, (Object)bibus);
                        UserCapabilityEnum[] capabilities = bibus.getUserCapabilityCache().getUserCapabilities();
                        for (int j = 0; j < capabilities.length; ++j) {
                            if (!capabilities[j].getValue().equalsIgnoreCase(CAN_USE_PORTAL_ADMINISTRATION_TOOL)) continue;
                            adminFlag = true;
                            break;
                        }
                        this.saveCamPassport(bibus);
                        Object[] args = new Object[]{userName};
                        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_LOGIN_SUCCESSFUL", args));
                        adminFlag = true;
                        break block8;
                    }
                    this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_CONNECT"));
                    adminFlag = false;
                }
                catch (RemoteException re) {
                    this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_USERNAME"));
                    adminFlag = false;
                }
            } else {
                this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_NAMESPACE"));
            }
        }
        return adminFlag;
    }

    private void saveCamPassport(BiBusHeader bibus) {
        ICssService cssService = CssServiceImpl.getInstance();
        String camPassportCookie = "";
        SetCookieVar[] setCookieVars = bibus.getHdrSession().getSetCookieVars();
        for (int i = 0; i < setCookieVars.length; ++i) {
            if (!"cam_passport".equals(setCookieVars[i].getName())) continue;
            camPassportCookie = setCookieVars[i].getValue();
            break;
        }
        if ("".equals(camPassportCookie)) {
            CookieVar[] cookieVars = bibus.getHdrSession().getCookieVars();
            for (int i = 0; i < cookieVars.length; ++i) {
                if (!"cam_passport".equals(cookieVars[i].getName())) continue;
                camPassportCookie = cookieVars[i].getValue();
                break;
            }
        }
        cssService.setCamPassportCookie(camPassportCookie);
    }

    private String encodeCredentials(String userName, char[] password, String nameSpace) {
        StringBuffer credentialXML = new StringBuffer();
        credentialXML.append("<credential>");
        credentialXML.append("<namespace>");
        credentialXML.append(nameSpace);
        credentialXML.append("</namespace>");
        credentialXML.append("<username>");
        credentialXML.append(userName);
        credentialXML.append("</username>");
        credentialXML.append("<password>");
        credentialXML.append(password);
        credentialXML.append("</password>");
        credentialXML.append("</credential>");
        return credentialXML.toString();
    }

    private boolean isValidNamespace(String nameSpace) throws CognosBIUnavailableException {
        boolean found = false;
        String[] namespaceInfo = this.getNamespaces();
        if (namespaceInfo == null) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_CONNECT"));
            return found;
        }
        for (int i = 0; i < namespaceInfo.length; ++i) {
            if (!nameSpace.equals(namespaceInfo[i])) continue;
            found = true;
            break;
        }
        return found;
    }

    static {
        CM_URL = "http://localhost:9300/p2pd/servlet/dispatch";
    }
}

