/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool;

import com.cognos.css.skintool.CRNConnect;
import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.CognosBIUnavailableException;
import com.cognos.css.skintool.CommandFactory;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.Prompt;
import com.cognos.css.skintool.command.ICommand;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Console {
    private Prompt prompt = Prompt.getInstance();
    private static String appName = "p2pd";
    private static String dispatcher = "http://localhost:9300/p2pd/servlet/dispatch";
    private static String gatewayUrl = "http://localhost:80/ibmcognos/cgi-bin/cognos.cgi";

    public Console(InputStream in, PrintStream out) {
        this.prompt.setInput(in);
        this.prompt.setOutput(out);
        try {
            this.readConfigFile();
        }
        catch (Exception e) {
            MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_READ_CONF_FILE");
            System.exit(0);
        }
    }

    private void readConfigFile() throws Exception {
        InputStreamReader reader = new InputStreamReader(new FileInputStream("../../../configuration/cogstartup.xml"));
        Element element = null;
        SAXReader saxreader = new SAXReader();
        element = saxreader.read((Reader)reader).getRootElement();
        List nodes = element.selectNodes("/crn:parameters/crn:parameter[@name='externalDispatcher']/crn:value");
        if (nodes.size() == 1) {
            Console.setDispatcher(((Element)nodes.get(0)).getText());
            Console.setAppName(dispatcher);
        }
        if ((nodes = element.selectNodes("/crn:parameters/crn:parameter[@name='gateway']/crn:value")).size() == 1) {
            Console.setGatewayUrl(((Element)nodes.get(0)).getText());
        }
    }

    public static void main(String[] args) {
        Console console = new Console(System.in, System.out);
        try {
            if (console.login()) {
                console.processCommands();
            }
        }
        catch (CognosBIUnavailableException e) {
            System.out.println(e);
        }
    }

    private void processCommands() {
        String answer = "";
        try {
            while (true) {
                answer = this.prompt.ask(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_PROMPT"));
                ICommand command = CommandFactory.createCommand(answer);
                command.execute();
            }
        }
        catch (CognosBISessionTimeoutException e) {
            System.out.println(e);
            return;
        }
    }

    private boolean login() throws CognosBIUnavailableException {
        CRNConnect connection = CRNConnect.getInstance();
        connection.connectToCognosServer();
        String userName = this.prompt.ask(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_USER_NAME"));
        char[] password = this.prompt.askForPassword(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_PASSWORD"));
        String nameSpace = this.prompt.ask(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_NAME_SPACE"));
        return connection.doLogin(userName, password, nameSpace);
    }

    public static String getDispatcher() {
        return dispatcher;
    }

    public static void setDispatcher(String externalDispatcher) {
        dispatcher = externalDispatcher;
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String dispatcher) {
        int start = dispatcher.indexOf("//");
        start = dispatcher.indexOf("/", start + 2);
        int end = dispatcher.indexOf("/", start + 1);
        appName = dispatcher.substring(start + 1, end);
    }

    public static String getGatewayUrl() {
        return gatewayUrl;
    }

    public static void setGatewayUrl(String gateway) {
        gatewayUrl = gateway;
    }
}

