/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool;

import com.cognos.css.skintool.AbstractCssService;
import com.cognos.css.skintool.CRNConnect;
import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.Console;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.Prompt;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.PortalSkin;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXMLProp;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.Locale;
import org.apache.axis.AxisFault;

public class CssServiceImpl
extends AbstractCssService {
    private static ICssService cssService;
    private String appName;

    private CssServiceImpl() {
        this.prompt = Prompt.getInstance();
        this.gatewayUrl = Console.getGatewayUrl();
        this.appName = Console.getAppName();
    }

    public static synchronized ICssService getInstance() {
        if (cssService == null) {
            cssService = new CssServiceImpl();
        }
        return cssService;
    }

    @Override
    public boolean getSkin(String baseName, String skinName) throws CognosBISessionTimeoutException {
        boolean result = this.getSkinFromCM(baseName, skinName);
        if (!result) {
            String inputFile = new String(this.gatewayUrl + "/css?skin=" + baseName);
            String outputFile = "../../../temp/" + skinName + ".xml";
            result = this.download(skinName, inputFile, outputFile);
        }
        return result;
    }

    @Override
    public boolean generateCss(String skinName, String skeleton) {
        String inputFile = new String(this.gatewayUrl + "/css?skin=" + skinName + "&css=" + skeleton);
        String outputFile = "../../../temp/" + skinName + "/" + skeleton + ".css";
        return this.download(skinName, inputFile, outputFile);
    }

    private boolean getSkinFromCM(String baseName, String skinName) throws CognosBISessionTimeoutException {
        boolean result = false;
        CRNConnect connection = CRNConnect.getInstance();
        PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.published, PropEnum.base, PropEnum.specification};
        Sort[] sortBy = new Sort[]{new Sort()};
        sortBy[0].setOrder(OrderEnum.ascending);
        sortBy[0].setPropName(PropEnum.defaultName);
        QueryOptions options = new QueryOptions();
        try {
            BaseClass[] bc = connection.getCMService().query(new SearchPathMultipleObject("/portal/*[@objectClass='portalSkinFolder']/*[@objectClass='portalSkin']"), properties, sortBy, options);
            for (int i = 0; i < bc.length; ++i) {
                XmlEncodedXMLProp xmlProp;
                XmlEncodedXML xml;
                PortalSkin skin = (PortalSkin)bc[i];
                if (!skinName.toLowerCase().equals(skin.getDefaultName().getValue().toLowerCase()) || (xml = (xmlProp = skin.getSpecification()).getValue()) == null) continue;
                File fp = new File("../../../temp/" + skinName + ".xml");
                FileWriter writer = new FileWriter(fp);
                writer.write(xml.toString());
                writer.flush();
                writer.close();
                result = true;
            }
        }
        catch (AxisFault ex) {
            throw new CognosBISessionTimeoutException();
        }
        catch (RemoteException remoteEx) {
            remoteEx.printStackTrace();
            result = false;
        }
        catch (IOException ioe) {
            Object[] args = new Object[]{skinName};
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_WRITE_STYLE", args));
            result = false;
        }
        return result;
    }

    @Override
    public InputStream getSkeletonXML() {
        return this.getInputStream(this.gatewayUrl + "/css");
    }

    private InputStream getInputStream(String inputFile) {
        try {
            URL url = new URL(inputFile);
            URLConnection connection = url.openConnection();
            connection.setDoInput(true);
            connection.setRequestProperty("Cookie", "cam_passport=" + camPassportCookie);
            return connection.getInputStream();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean download(String skinName, String inputFile, String outputFile) {
        try {
            BufferedInputStream in = new BufferedInputStream(this.getInputStream(inputFile));
            if (skinName != null) {
                int count;
                FileOutputStream fos = new FileOutputStream(outputFile);
                BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
                byte[] data = new byte[1024];
                while ((count = in.read(data, 0, 1024)) != -1) {
                    bout.write(data, 0, count);
                }
                bout.close();
                in.close();
            }
            return true;
        }
        catch (FileNotFoundException fnfe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_SKIN_NAME"));
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean saveSkin(String skinName) throws CognosBISessionTimeoutException {
        File skinFile = new File("../../../temp/" + skinName + ".xml");
        if (!skinFile.exists()) {
            return false;
        }
        CRNConnect connection = CRNConnect.getInstance();
        BaseClass[] bc = new BaseClass[1];
        PortalSkin skin = new PortalSkin();
        TokenProp skinToken = new TokenProp();
        skinToken.setValue(skinName);
        skin.setDefaultName(skinToken);
        if (!this.createSpecificationProperty(skinName, skin)) {
            return false;
        }
        bc[0] = skin;
        StringProp searchPath = new StringProp();
        searchPath.setValue("/portal/*[@objectClass='portalSkinFolder']/*[@objectClass='portalSkin' and @defaultName='" + skinName + "']");
        bc[0].setSearchPath(searchPath);
        UpdateOptions options = new UpdateOptions();
        try {
            connection.getCMService().update(bc, options);
        }
        catch (AxisFault ex) {
            throw new CognosBISessionTimeoutException();
        }
        catch (RemoteException remoteEx) {
            remoteEx.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public BaseClass[] getListOfSkins() throws CognosBISessionTimeoutException {
        CRNConnect connection = CRNConnect.getInstance();
        PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.published};
        Sort[] sortBy = new Sort[]{new Sort()};
        sortBy[0].setOrder(OrderEnum.ascending);
        sortBy[0].setPropName(PropEnum.defaultName);
        QueryOptions options = new QueryOptions();
        try {
            return connection.getCMService().query(new SearchPathMultipleObject("/portal/*[@objectClass='portalSkinFolder']/*[@objectClass='portalSkin' and permission('execute')]"), properties, sortBy, options);
        }
        catch (AxisFault ex) {
            throw new CognosBISessionTimeoutException();
        }
        catch (RemoteException remoteEx) {
            remoteEx.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean createSkin(String baseName, String skinName) throws CognosBISessionTimeoutException {
        CRNConnect connection = CRNConnect.getInstance();
        BaseClass[] bc = new BaseClass[1];
        PortalSkin skin = new PortalSkin();
        TokenProp skinToken = new TokenProp();
        skinToken.setValue(skinName);
        skin.setDefaultName(skinToken);
        StringProp resourceToken = new StringProp();
        resourceToken.setValue(skinName);
        skin.setResourceLocation(resourceToken);
        BooleanProp shown = new BooleanProp();
        shown.setValue(false);
        skin.setShown(shown);
        StringProp previewImageLocation = new StringProp();
        previewImageLocation.setValue("preview.htm");
        skin.setPreviewImageLocation(previewImageLocation);
        TokenProp baseToken = new TokenProp();
        baseToken.setValue(baseName);
        StringProp searchPath = new StringProp();
        searchPath.setValue("/portal/*[@objectClass='portalSkinFolder']/*[@objectClass='portalSkin' and @defaultName='" + baseName + "']");
        PortalSkin baseSkin = new PortalSkin();
        baseSkin.setDefaultName(baseToken);
        baseSkin.setSearchPath(searchPath);
        BaseClassArrayProp baseProp = new BaseClassArrayProp();
        BaseClass[] baseClass = new BaseClass[]{baseSkin};
        baseProp.setValue(baseClass);
        skin.setBase(baseProp);
        BooleanProp publishProp = new BooleanProp();
        publishProp.setValue(false);
        skin.setPublished(publishProp);
        if (!this.createSpecificationProperty(skinName, skin)) {
            return false;
        }
        bc[0] = skin;
        AddOptions options = new AddOptions();
        try {
            connection.getCMService().add(new SearchPathSingleObject("/portal/*[@objectClass='portalSkinFolder']"), bc, options);
        }
        catch (AxisFault ex) {
            throw new CognosBISessionTimeoutException();
        }
        catch (RemoteException remoteEx) {
            remoteEx.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean createSpecificationProperty(String skinName, PortalSkin skin) {
        XmlEncodedXMLProp specification = new XmlEncodedXMLProp();
        XmlEncodedXML value = new XmlEncodedXML();
        try {
            StringBuffer buffer = new StringBuffer("");
            BufferedReader reader = new BufferedReader(new FileReader("../../../temp/" + skinName + ".xml"));
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                buffer.append(temp);
            }
            value.set_value(buffer.toString());
            specification.setValue(value);
            skin.setSpecification(specification);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean publishSkin(String skinName) throws CognosBISessionTimeoutException {
        CRNConnect connection = CRNConnect.getInstance();
        BaseClass[] bc = new BaseClass[1];
        PortalSkin skin = new PortalSkin();
        TokenProp skinToken = new TokenProp();
        skinToken.setValue(skinName);
        skin.setDefaultName(skinToken);
        BooleanProp publishProp = new BooleanProp();
        publishProp.setValue(true);
        skin.setPublished(publishProp);
        bc[0] = skin;
        StringProp searchPath = new StringProp();
        searchPath.setValue("/portal/*[@objectClass='portalSkinFolder']/*[@objectClass='portalSkin' and @defaultName='" + skinName + "']");
        bc[0].setSearchPath(searchPath);
        UpdateOptions options = new UpdateOptions();
        try {
            connection.getCMService().update(bc, options);
        }
        catch (AxisFault ex) {
            throw new CognosBISessionTimeoutException();
        }
        catch (RemoteException remoteEx) {
            remoteEx.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteSkin(String skinName) throws CognosBISessionTimeoutException {
        CRNConnect connection = CRNConnect.getInstance();
        BaseClass[] bc = new BaseClass[1];
        PortalSkin skin = new PortalSkin();
        TokenProp skinToken = new TokenProp();
        skinToken.setValue(skinName);
        skin.setDefaultName(skinToken);
        bc[0] = skin;
        StringProp searchPath = new StringProp();
        searchPath.setValue("/portal/*[@objectClass='portalSkinFolder']/*[@objectClass='portalSkin' and @defaultName='" + skinName + "']");
        bc[0].setSearchPath(searchPath);
        DeleteOptions options = new DeleteOptions();
        try {
            connection.getCMService().delete(bc, options);
        }
        catch (AxisFault ex) {
            throw new CognosBISessionTimeoutException();
        }
        catch (RemoteException remoteEx) {
            remoteEx.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String getBaseSkin(String skinName) throws CognosBISessionTimeoutException {
        CRNConnect connection = CRNConnect.getInstance();
        PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.published, PropEnum.base};
        Sort[] sortBy = new Sort[]{new Sort()};
        sortBy[0].setOrder(OrderEnum.ascending);
        sortBy[0].setPropName(PropEnum.defaultName);
        QueryOptions options = new QueryOptions();
        RefProp[] refProps = new RefProp[1];
        PropEnum refPropName = PropEnum.base;
        PropEnum[] refPropProperties = new PropEnum[]{PropEnum.resourceLocation};
        refProps[0] = new RefProp(refPropProperties, refPropName);
        options.setRefProps(refProps);
        try {
            BaseClass[] bc = connection.getCMService().query(new SearchPathMultipleObject("/portal/*[@objectClass='portalSkinFolder']/*[@objectClass='portalSkin' and @defaultName='" + skinName + "']"), properties, sortBy, options);
            for (int i = 0; i < bc.length; ++i) {
                BaseClassArrayProp baseProp;
                BaseClass[] baseClass;
                PortalSkin baseSkin;
                String baseSkinLocation;
                PortalSkin skin = (PortalSkin)bc[i];
                if (!skinName.toLowerCase().equals(skin.getDefaultName().getValue().toLowerCase()) || (baseSkinLocation = (baseSkin = (PortalSkin)(baseClass = (baseProp = skin.getBase()).getValue())[0]).getResourceLocation().getValue()) == null) continue;
                return baseSkinLocation;
            }
            return "corporate";
        }
        catch (AxisFault ex) {
            throw new CognosBISessionTimeoutException();
        }
        catch (RemoteException remoteEx) {
            return "corporate";
        }
    }

    @Override
    public boolean doesSkinExist(String skinName) throws CognosBISessionTimeoutException {
        boolean result = false;
        BaseClass[] results = this.getListOfSkins();
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                PortalSkin skin = (PortalSkin)results[i];
                if (!skinName.toLowerCase().equals(skin.getDefaultName().getValue().toLowerCase())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean isSkinTooLarge(String skinName) {
        File skinFile = new File("../../../temp/" + skinName + ".xml");
        return skinFile.length() > 256000L;
    }
}

