/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class MessagesManager {
    private static final MessagesManager m_instance = new MessagesManager();
    private boolean m_bInitialized = false;
    private HashMap m_msgResourceMap = new HashMap();
    private HashMap m_msgFormatterMap = new HashMap();
    private List m_msgFileNameList = null;

    private MessagesManager() {
    }

    public synchronized void initialize(List msgFileNameList) {
        if (this.m_msgFileNameList == null) {
            this.m_msgFileNameList = msgFileNameList;
        } else {
            for (String file : msgFileNameList) {
                if (this.m_msgFileNameList.contains(file)) continue;
                this.m_msgFileNameList.add(file);
            }
            this.m_msgResourceMap.clear();
            this.m_msgFormatterMap.clear();
        }
        this.m_bInitialized = true;
    }

    public synchronized void terminate() {
        this.m_msgFileNameList.clear();
        this.m_msgResourceMap.clear();
        this.m_msgFormatterMap.clear();
        this.m_msgFileNameList = null;
        this.m_msgResourceMap = null;
        this.m_msgFormatterMap = null;
        this.m_bInitialized = false;
    }

    public static MessagesManager getInstance() {
        return m_instance;
    }

    public String getMessage(Locale locale, String key) {
        List msgFilesList;
        if (this.m_bInitialized && (msgFilesList = this.getMsgFiles(locale)) != null) {
            for (int i = 0; i < msgFilesList.size(); ++i) {
                ResourceBundle bundle = (ResourceBundle)msgFilesList.get(i);
                try {
                    String msg = bundle.getString(key);
                    if (msg != null) {
                        return msg;
                    }
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        return new String(key);
    }

    public String getMessage(String lang, String key) {
        return this.getMessage(MessagesManager.createLocale(lang), key);
    }

    public String getMessage(Locale locale, String key, Object[] args) {
        if (!this.m_bInitialized) {
            return new String(key);
        }
        String msgString = this.getMessage(locale, key);
        if (msgString == null) {
            return new String(key);
        }
        MessageFormat formatter = this.getMsgFormatter(locale);
        if (formatter == null) {
            return new String(msgString);
        }
        StringBuffer newMsgString = new StringBuffer(msgString.length());
        int idx = 0;
        while ((idx = msgString.indexOf(39)) != -1) {
            newMsgString.append(msgString.substring(0, idx));
            newMsgString.append("''");
            msgString = msgString.substring(idx + 1);
        }
        newMsgString.append(msgString);
        formatter.applyPattern(newMsgString.toString());
        return formatter.format(args).toString();
    }

    public String getMessage(String lang, String key, Object[] args) {
        return this.getMessage(MessagesManager.createLocale(lang), key, args);
    }

    private synchronized MessageFormat getMsgFormatter(Locale locale) {
        String mapkey = MessagesManager.buildJavaLocaleName(locale);
        if (!this.m_msgFormatterMap.containsKey(mapkey)) {
            MessageFormat msgFormatter = new MessageFormat("");
            msgFormatter.setLocale(locale);
            this.m_msgFormatterMap.put(mapkey, msgFormatter);
            return msgFormatter;
        }
        return (MessageFormat)this.m_msgFormatterMap.get(mapkey);
    }

    private synchronized List getMsgFiles(Locale locale) {
        String mapkey = MessagesManager.buildJavaLocaleName(locale);
        if (!this.m_msgResourceMap.containsKey(mapkey)) {
            ArrayList<ResourceBundle> list = new ArrayList<ResourceBundle>();
            int size = this.m_msgFileNameList.size();
            for (int i = 0; i < size; ++i) {
                try {
                    list.add(ResourceBundle.getBundle((String)this.m_msgFileNameList.get(i), locale, this.getClass().getClassLoader()));
                    continue;
                }
                catch (MissingResourceException e) {
                    e.printStackTrace(System.err);
                }
            }
            this.m_msgResourceMap.put(mapkey, list);
            return list;
        }
        return (List)this.m_msgResourceMap.get(mapkey);
    }

    public static String buildJavaLocaleName(Locale locale) {
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (country.length() == 0) {
            return lang;
        }
        return lang + "_" + country;
    }

    public static Locale createLocale(String lang) {
        int sep = lang.indexOf(45);
        if (sep > 0) {
            return new Locale(lang.substring(0, sep), lang.substring(sep + 1));
        }
        return new Locale(lang, "");
    }
}

