/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool;

import com.cognos.css.skintool.MaskingThread;
import com.cognos.css.skintool.MessagesManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class Prompt {
    private BufferedReader input;
    private PrintStream out;
    private static Prompt prompt;
    private MessagesManager messages;

    private Prompt() {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add("cpsskintool");
        MessagesManager.getInstance().initialize(msgFileList);
    }

    public static synchronized Prompt getInstance() {
        if (prompt == null) {
            prompt = new Prompt();
        }
        return prompt;
    }

    public void tell(String statement) {
        this.out.println(statement);
    }

    public String ask(String question) {
        this.out.print(MessagesManager.getInstance().getMessage(Locale.ENGLISH, question));
        String answer = "";
        try {
            answer = this.input.readLine();
        }
        catch (IOException ioe) {
            this.tell(this.messages.getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_READ"));
        }
        return answer;
    }

    public char[] askForPassword(String question) {
        int offset;
        char[] buf;
        MaskingThread maskingthread;
        block11: {
            char[] lineBuffer;
            this.out.print(question);
            maskingthread = new MaskingThread();
            Thread thread = new Thread(maskingthread);
            thread.start();
            buf = lineBuffer = new char[128];
            int room = buf.length;
            offset = 0;
            InputStream in = System.in;
            try {
                while (true) {
                    int c = in.read();
                    switch (c) {
                        case -1: 
                        case 10: {
                            break block11;
                        }
                        case 13: {
                            int c2 = in.read();
                            if (c2 == 10 || c2 == -1) break block11;
                            if (!(in instanceof PushbackInputStream)) {
                                in = new PushbackInputStream(in);
                            }
                            ((PushbackInputStream)in).unread(c2);
                        }
                        default: {
                            if (--room < 0) {
                                buf = new char[offset + 128];
                                room = buf.length - offset - 1;
                                System.arraycopy(lineBuffer, 0, buf, 0, offset);
                                Arrays.fill(lineBuffer, ' ');
                                lineBuffer = buf;
                            }
                            buf[offset++] = (char)c;
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                this.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_READ"));
            }
        }
        maskingthread.stopMasking();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    public void setInput(InputStream input) {
        this.input = new BufferedReader(new InputStreamReader(input));
    }

    public void setOutput(PrintStream out) {
        this.out = out;
    }
}

