/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import java.io.File;
import java.util.Locale;

public class DeleteCommand
extends Command {
    private ICssService cssService;
    private String skinName;

    public DeleteCommand(String[] params, ICssService service) {
        this.cssService = service;
        try {
            this.skinName = params[1];
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_DELETE_SYNTAX"));
            this.printHelp();
            this.canExecute = false;
        }
    }

    @Override
    public boolean execute() throws CognosBISessionTimeoutException {
        boolean result = false;
        if (!this.canExecute) {
            return result;
        }
        Object[] args = new Object[]{this.skinName};
        if (this.cssService.doesSkinExist(this.skinName)) {
            if (!this.cssService.isDefaultSkin(this.skinName)) {
                if (this.confirm(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_CONFIRM_DELETE", args))) {
                    if (this.cssService.deleteSkin(this.skinName) && this.deleteSkinFile(this.skinName)) {
                        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_DELETE_SUCCESSFUL", args));
                        result = true;
                    } else {
                        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_DELETE", args));
                        result = false;
                    }
                }
            } else {
                this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_DELETE", args));
                this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_DELETE2"));
                result = false;
            }
        } else {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_SKIN_NAME", args));
            result = false;
        }
        return result;
    }

    private boolean deleteSkinFile(String skinName) {
        File fp = new File("../../../temp/" + skinName + ".xml");
        if (!fp.exists()) {
            return true;
        }
        return fp.delete();
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_DELETE"));
    }
}

