/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import java.util.Locale;

public class DownloadCommand
extends Command {
    private String skinName;
    private ICssService cssService;

    public DownloadCommand(String[] params, ICssService service) {
        this.cssService = service;
        try {
            this.skinName = params[1];
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_DOWNLOAD_SYNTAX"));
            this.printHelp();
            this.canExecute = false;
        }
    }

    @Override
    public boolean execute() throws CognosBISessionTimeoutException {
        boolean result = false;
        if (!this.canExecute) {
            return result;
        }
        if (this.fileExists("../../../temp/" + this.skinName + ".xml")) {
            if (this.confirm(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_CONFIRM_DOWNLOAD"))) {
                result = this.getSkin();
            }
        } else {
            result = this.getSkin();
        }
        return result;
    }

    private boolean getSkin() throws CognosBISessionTimeoutException {
        boolean result;
        Object[] args = new Object[]{this.skinName};
        if (this.cssService.getSkin(this.skinName)) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_DOWNLOAD_SUCCESSFUL", args));
            result = true;
        } else {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_DOWNLOAD", args));
            result = false;
        }
        return result;
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_DOWNLOAD"));
    }
}

