/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.CommandFactory;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import com.cognos.css.skintool.command.ICommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class GenerateCommand
extends Command {
    private ICssService cssService;
    private String skinName;

    public GenerateCommand(String[] params, ICssService service) {
        this.cssService = service;
        try {
            this.skinName = params[1];
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_GENERATE_SYNTAX"));
            this.printHelp();
            this.canExecute = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute() throws CognosBISessionTimeoutException {
        if (!this.canExecute) {
            return false;
        }
        String baseSkin = this.getBaseSkin(this.skinName);
        Object[] args = new Object[]{this.skinName};
        if (!this.cssService.doesSkinExist(this.skinName)) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_SKIN_NAME", args));
            return false;
        }
        if (!this.confirm(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_CONFIRM_GENERATE", args))) return true;
        ICommand command = CommandFactory.createCommand("validate " + this.skinName);
        if (!command.execute()) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_GENERATE", args));
            return false;
        }
        if (!this.cssService.saveSkin(this.skinName)) return true;
        if (this.createStagingArea("../../../webcontent/skins", baseSkin, this.skinName)) {
            this.generateCssFiles(this.skinName);
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_GENERATE_SUCCESSFUL", args));
            return true;
        }
        Object[] baseArgs = new Object[]{baseSkin};
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_GENERATE_STAGING_AREA", baseArgs));
        return false;
    }

    private void generateCssFiles(String skinName) {
        String appName = "";
        String skeletonName = "";
        try {
            XMLInputFactory f = XMLInputFactory.newInstance();
            XMLStreamReader reader = f.createXMLStreamReader(this.cssService.getSkeletonXML());
            reader.next();
            while (reader.hasNext()) {
                if (reader.isStartElement()) {
                    if ("app".equals(reader.getLocalName())) {
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            if (!"name".equals(reader.getAttributeLocalName(i))) continue;
                            appName = reader.getAttributeValue(i);
                            File subDir = new File(skinName + "\\" + reader.getAttributeValue(i));
                            if (subDir.exists()) continue;
                            subDir.mkdir();
                        }
                    } else if ("skeleton".equals(reader.getLocalName())) {
                        reader.next();
                        skeletonName = reader.getText();
                        this.cssService.generateCss(skinName, appName + "/" + skeletonName);
                    }
                }
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private boolean createStagingArea(String baseDir, String fromDir, String toDir) {
        File[] fileList;
        File stagingDir = new File("../../../temp/" + toDir);
        stagingDir.mkdir();
        String srcDirPath = baseDir + "/" + toDir;
        File srcDir = new File(srcDirPath);
        if (!srcDir.exists()) {
            srcDirPath = baseDir + "/" + fromDir;
            srcDir = new File(srcDirPath);
        }
        if ((fileList = srcDir.listFiles()) != null) {
            try {
                for (int i = 0; i < fileList.length; ++i) {
                    if (!fileList[i].isDirectory()) {
                        FileChannel in = new FileInputStream(fileList[i]).getChannel();
                        FileChannel out = new FileOutputStream(new File(stagingDir, fileList[i].getName())).getChannel();
                        in.transferTo(0L, in.size(), out);
                        continue;
                    }
                    this.createStagingArea(srcDirPath, fileList[i].getName(), toDir + "/" + fileList[i].getName());
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    private String getBaseSkin(String skinName) throws CognosBISessionTimeoutException {
        return this.cssService.getBaseSkin(skinName);
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_GENERATE"));
    }
}

