/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.PortalSkin;
import java.util.Locale;

public class ListCommand
extends Command {
    private ICssService cssService;

    public ListCommand(String[] params, ICssService service) {
        this.cssService = service;
    }

    @Override
    public boolean execute() throws CognosBISessionTimeoutException {
        boolean result = false;
        BaseClass[] results = this.cssService.getListOfSkins();
        if (results != null) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_AVAILABLE_STYLES"));
            String str = String.format("%1$15s %2$10s %3$10s", "Name", "Published", "System");
            this.prompt.tell(str);
            this.prompt.tell("=====================================");
            for (int i = 0; i < results.length; ++i) {
                PortalSkin skin = (PortalSkin)results[i];
                str = String.format("%1$15s %2$10s %3$10s", skin.getDefaultName().getValue(), skin.getPublished().isValue(), this.cssService.isDefaultSkin(skin.getDefaultName().getValue()));
                this.prompt.tell(str);
            }
            result = true;
        }
        return result;
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_LIST"));
    }
}

