/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import java.io.File;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NewCommand
extends Command {
    private String baseName = "";
    private String skinName = "";
    private ICssService cssService;

    public NewCommand(String[] params, ICssService service) {
        this.cssService = service;
        try {
            this.baseName = params[1];
            this.skinName = params[2];
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_NEW_SYNTAX"));
            this.printHelp();
            this.canExecute = false;
        }
    }

    @Override
    public boolean execute() throws CognosBISessionTimeoutException {
        boolean result = false;
        if (!this.canExecute) {
            return result;
        }
        boolean skinExists = this.cssService.doesSkinExist(this.skinName);
        Object[] args = new Object[]{this.skinName};
        if (!this.cssService.isDefaultSkin(this.baseName) && !this.cssService.doesSkinExist(this.baseName)) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_SKIN_NOT_EXIST", args));
            return result;
        }
        this.baseName = this.baseName.toLowerCase();
        if (!skinExists && this.cssService.getSkin(this.baseName, this.skinName) && this.replaceSkinName(this.baseName, this.skinName) && this.cssService.createSkin(this.baseName, this.skinName)) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_NEW_SUCCESSFUL", args));
            result = true;
        } else {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_NEW", args));
            if (skinExists) {
                this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_NEW2"));
            }
            result = false;
        }
        return result;
    }

    private boolean replaceSkinName(String baseName, String skinName) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse("../../../temp/" + skinName + ".xml");
            NodeList nodeList = doc.getElementsByTagName("skin");
            Node node = nodeList.item(0);
            node.getAttributes().getNamedItem("name").setNodeValue(skinName);
            node.getAttributes().getNamedItem("xsi:noNamespaceSchemaLocation").setNodeValue("../bin/utilities/StyleManager/cssstyles.xsd");
            Transformer t = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(new File("../../../temp/" + skinName + ".xml"));
            DOMSource source = new DOMSource(doc);
            t.transform(source, result);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_NEW"));
    }
}

