/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import java.util.Locale;

public class PublishCommand
extends Command {
    private ICssService cssService;
    private String skinName;

    public PublishCommand(String[] params, ICssService service) {
        this.cssService = service;
        try {
            this.skinName = params[1];
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_PUBLISH_SYNTAX"));
            this.printHelp();
            this.canExecute = false;
        }
    }

    @Override
    public boolean execute() throws CognosBISessionTimeoutException {
        boolean result = false;
        if (!this.canExecute) {
            return result;
        }
        Object[] args = new Object[]{this.skinName};
        if (this.cssService.doesSkinExist(this.skinName)) {
            if (this.cssService.publishSkin(this.skinName)) {
                this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_PUBLISH_SUCCESSFUL", args));
                result = true;
            } else {
                this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_PUBLISH", args));
                result = false;
            }
        } else {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_SKIN_NAME", args));
            result = false;
        }
        return result;
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_PUBLISH"));
    }
}

