/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.CommandFactory;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import com.cognos.css.skintool.command.ICommand;
import java.util.Locale;

public class SaveCommand
extends Command {
    private ICssService cssService;
    private String skinName;

    public SaveCommand(String[] params, ICssService service) {
        this.cssService = service;
        try {
            this.skinName = params[1];
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_SAVE_SYNTAX"));
            this.printHelp();
            this.canExecute = false;
        }
    }

    @Override
    public boolean execute() throws CognosBISessionTimeoutException {
        boolean result = false;
        if (!this.canExecute) {
            return result;
        }
        Object[] args = new Object[]{this.skinName};
        if (this.cssService.doesSkinExist(this.skinName)) {
            if (!this.cssService.isSkinTooLarge(this.skinName)) {
                if (this.skinName != null && !this.cssService.isDefaultSkin(this.skinName)) {
                    ICommand command = CommandFactory.createCommand("validate " + this.skinName);
                    if (command.execute()) {
                        if (this.cssService.saveSkin(this.skinName)) {
                            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_SAVE_SUCCESSFUL", args));
                            result = true;
                        } else {
                            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_SAVE", args));
                            result = false;
                        }
                    } else {
                        result = false;
                    }
                } else {
                    this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_SAVE_SYSTEM", args));
                }
            } else {
                this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_SKIN_FILE_TO_LARGE"));
            }
        } else {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_SKIN_NAME", args));
            result = false;
        }
        return result;
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_SAVE"));
    }
}

