/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import java.util.Locale;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

public class ValidateCommand
extends Command {
    private String skinName;
    private ICssService cssService;

    public ValidateCommand(String[] params, ICssService service) {
        this.cssService = service;
        try {
            this.skinName = params[1];
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_VALIDATE_SYNTAX"));
            this.printHelp();
            this.canExecute = false;
        }
    }

    @Override
    public boolean execute() {
        boolean result = false;
        if (!this.canExecute) {
            return result;
        }
        if (this.cssService.isSkinTooLarge(this.skinName)) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_SKIN_FILE_TO_LARGE"));
            return result;
        }
        Object[] args = new Object[]{this.skinName};
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(ValidateCommand.class.getClassLoader().getResourceAsStream("com/cognos/css/skintool/cssstyles.xsd"));
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(schemaSource);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource("../../../temp/" + this.skinName + ".xml"));
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_VALIDATE_SUCCESSFUL", args));
            result = true;
        }
        catch (Exception e) {
            this.prompt.tell("\n");
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_VALIDATE2", args));
            this.prompt.tell(e.getMessage());
            this.prompt.tell("\n");
        }
        return result;
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_VALIDATE"));
    }
}

