/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.css.skintool.command;

import com.cognos.css.skintool.CognosBISessionTimeoutException;
import com.cognos.css.skintool.ICssService;
import com.cognos.css.skintool.MessagesManager;
import com.cognos.css.skintool.command.Command;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipCommand
extends Command {
    private ICssService cssService;
    private String skinName;

    public ZipCommand(String[] params, ICssService service) {
        this.cssService = service;
        try {
            this.skinName = params[1];
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_INVALID_ZIP_SYNTAX"));
            this.printHelp();
            this.canExecute = false;
        }
    }

    @Override
    public boolean execute() throws CognosBISessionTimeoutException {
        boolean result = false;
        if (!this.canExecute) {
            return false;
        }
        Object[] args = new Object[]{this.skinName};
        if (this.createZipArchive(this.skinName)) {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_ZIP_SUCCESSFUL", args));
            result = true;
        } else {
            this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_UNABLE_TO_ZIP", args));
            result = false;
        }
        return result;
    }

    private boolean createZipArchive(String skinName) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream("../../../temp/" + skinName + ".zip"));
            this.zipDir("../../../temp/" + skinName, zos);
            zos.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void zipDir(String dirName, ZipOutputStream zos) {
        try {
            File dir = new File(dirName);
            File[] dirList = dir.listFiles();
            byte[] buf = new byte[2156];
            int bytesIn = 0;
            for (int i = 0; i < dirList.length; ++i) {
                if (dirList[i].isDirectory()) {
                    this.zipDir(dirList[i].getPath(), zos);
                    continue;
                }
                ZipEntry entry = new ZipEntry(dirList[i].getPath().substring(13));
                zos.putNextEntry(entry);
                FileInputStream fis = new FileInputStream(dirList[i]);
                while ((bytesIn = fis.read(buf)) != -1) {
                    zos.write(buf, 0, bytesIn);
                }
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void printHelp() {
        this.prompt.tell(MessagesManager.getInstance().getMessage(Locale.ENGLISH, "CMDLN_HELP_ZIP"));
    }
}

