/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.ISMLocation;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.ArrayList;

public class BoundingRegion {
    private double longMin = 0.0;
    private double latMin = 0.0;
    private double longMax = 0.0;
    private double latMax = 0.0;
    private Line2D.Double topBorder = null;
    private Line2D.Double bottomBorder = null;
    private Line2D.Double leftBorder = null;
    private Line2D.Double rightBorder = null;
    private int defaultPercent = 10;

    private void initBorders() {
        this.longMin = 200.0;
        this.latMin = 200.0;
        this.longMax = -200.0;
        this.latMax = -200.0;
    }

    public JSONObject generateBoundingRegion(ArrayList<ISMLocation> sMLocations, JSONObject smallestRegion) throws Exception {
        return this.generateBoundingRegion(sMLocations, smallestRegion, this.defaultPercent, this.defaultPercent, this.defaultPercent, this.defaultPercent);
    }

    public JSONObject generateBoundingRegion(ArrayList<ISMLocation> sMLocations, JSONObject smallestRegion, int topPercent, int bottomPercent, int leftPercent, int rightPercent) throws Exception {
        String name;
        JSONObject propObj;
        JSONArray coordinatesObjArr;
        String type;
        JSONObject geometryObj;
        JSONObject featureObj;
        int i;
        JSONArray featuresObjArr;
        if (topPercent < 0 || topPercent > 100) {
            topPercent = this.defaultPercent;
        }
        if (bottomPercent < 0 || bottomPercent > 100) {
            bottomPercent = this.defaultPercent;
        }
        if (leftPercent < 0 || leftPercent > 100) {
            leftPercent = this.defaultPercent;
        }
        if (rightPercent < 0 || rightPercent > 100) {
            rightPercent = this.defaultPercent;
        }
        this.initBorders();
        JSONObject geojsonMap = (JSONObject)smallestRegion.get((Object)"geojson");
        JSONObject geojsonCities = (JSONObject)geojsonMap.get((Object)"cities");
        ArrayList<String> cityNames = new ArrayList<String>();
        if (geojsonCities != null) {
            featuresObjArr = (JSONArray)geojsonCities.get((Object)"features");
            for (i = 0; i < featuresObjArr.size(); ++i) {
                featureObj = (JSONObject)featuresObjArr.get(i);
                geometryObj = (JSONObject)featureObj.get((Object)"geometry");
                type = (String)geometryObj.get((Object)"type");
                coordinatesObjArr = (JSONArray)geometryObj.get((Object)"coordinates");
                propObj = (JSONObject)featureObj.get((Object)"properties");
                name = (String)propObj.get((Object)"name");
                cityNames.add(name);
                if (!type.equals("Point")) {
                    throw new Exception("Error in the city geojson: the element is not a point");
                }
                double longit = (Double)coordinatesObjArr.get(0);
                double lat = (Double)coordinatesObjArr.get(1);
                this.increaseBoundingRectangle(longit, lat);
            }
        }
        featuresObjArr = (JSONArray)geojsonMap.get((Object)"features");
        for (i = 0; i < featuresObjArr.size(); ++i) {
            featureObj = (JSONObject)featuresObjArr.get(i);
            geometryObj = (JSONObject)featureObj.get((Object)"geometry");
            type = (String)geometryObj.get((Object)"type");
            coordinatesObjArr = (JSONArray)geometryObj.get((Object)"coordinates");
            propObj = (JSONObject)featureObj.get((Object)"properties");
            name = (String)propObj.get((Object)"name");
            if (!this.iLocationsContain(sMLocations, name) || cityNames.contains(name)) continue;
            if (type.equals("Polygon")) {
                if (featuresObjArr.size() == 1) {
                    return smallestRegion;
                }
                JSONArray polygon = (JSONArray)coordinatesObjArr.get(0);
                this.increaseBoundingRectangle(polygon);
                continue;
            }
            if (type.equals("MultiPolygon")) {
                for (int j = 0; j < coordinatesObjArr.size(); ++j) {
                    JSONArray multiPoly = (JSONArray)coordinatesObjArr.get(j);
                    JSONArray polygon = (JSONArray)multiPoly.get(0);
                    this.increaseBoundingRectangle(polygon);
                }
                continue;
            }
            throw new Exception("Shape is not a polygon ot multipolygon");
        }
        double height = this.latMax - this.latMin;
        double width = this.longMax - this.longMin;
        this.latMax += (double)topPercent * height / 100.0;
        this.latMin -= (double)bottomPercent * height / 100.0;
        this.longMax += (double)rightPercent * width / 100.0;
        this.longMin -= (double)leftPercent * width / 100.0;
        this.longMin = this.formatCoordinate(this.longMin);
        this.longMax = this.formatCoordinate(this.longMax);
        this.latMin = this.formatCoordinate(this.latMin);
        this.latMax = this.formatCoordinate(this.latMax);
        this.topBorder = new Line2D.Double(this.longMin, this.latMax, this.longMax, this.latMax);
        this.bottomBorder = new Line2D.Double(this.longMin, this.latMin, this.longMax, this.latMin);
        this.leftBorder = new Line2D.Double(this.longMin, this.latMax, this.longMin, this.latMin);
        this.rightBorder = new Line2D.Double(this.longMax, this.latMax, this.longMax, this.latMin);
        JSONArray newFeaturesObjArr = new JSONArray();
        for (int i2 = 0; i2 < featuresObjArr.size(); ++i2) {
            JSONObject featureObj2 = (JSONObject)featuresObjArr.get(i2);
            JSONObject propObj2 = (JSONObject)featureObj2.get((Object)"properties");
            String name2 = (String)propObj2.get((Object)"name");
            JSONObject geometryObj2 = (JSONObject)featureObj2.get((Object)"geometry");
            String type2 = (String)geometryObj2.get((Object)"type");
            JSONArray coordinatesObjArr2 = (JSONArray)geometryObj2.get((Object)"coordinates");
            boolean empty = true;
            if (type2.equals("Polygon")) {
                boolean thereIsContent = this.cutPolygon(coordinatesObjArr2, geometryObj2, geojsonMap, name2);
                if (thereIsContent) {
                    empty = false;
                }
            } else {
                JSONArray newc = new JSONArray();
                for (int j = 0; j < coordinatesObjArr2.size(); ++j) {
                    boolean thereIsContent = this.cutPolygon((JSONArray)coordinatesObjArr2.get(j), geometryObj2, geojsonMap, name2);
                    if (!thereIsContent) continue;
                    empty = false;
                    newc.add(coordinatesObjArr2.get(j));
                }
                coordinatesObjArr2 = newc;
            }
            if (empty) continue;
            geometryObj2.put((Object)"coordinates", (Object)coordinatesObjArr2);
            newFeaturesObjArr.add((Object)featureObj2);
        }
        geojsonMap.put((Object)"features", (Object)newFeaturesObjArr);
        return smallestRegion;
    }

    private boolean iLocationsContain(ArrayList<ISMLocation> inputLocations, String name) {
        for (ISMLocation loc : inputLocations) {
            if (!this.removeExtraWS(loc.getName()).equals(name)) continue;
            return true;
        }
        return false;
    }

    private String removeExtraWS(String inputName) {
        String name = inputName.trim();
        name = name.replaceAll("\\s+", " ").replaceAll("\\s+\\.", ".");
        return name;
    }

    private void increaseBoundingRectangle(JSONArray polygon) {
        for (int i = 0; i < polygon.size(); ++i) {
            JSONArray point = (JSONArray)polygon.get(i);
            double longit = (Double)point.get(0);
            double lat = (Double)point.get(1);
            this.increaseBoundingRectangle(longit, lat);
        }
    }

    private void increaseBoundingRectangle(double longit, double lat) {
        if (longit > this.longMax) {
            this.longMax = longit;
        }
        if (longit < this.longMin) {
            this.longMin = longit;
        }
        if (lat > this.latMax) {
            this.latMax = lat;
        }
        if (lat < this.latMin) {
            this.latMin = lat;
        }
    }

    private double formatCoordinate(double dlatlong) {
        int decimalPlaces = 2;
        BigDecimal bd_Latlong = new BigDecimal(dlatlong);
        bd_Latlong = bd_Latlong.setScale(decimalPlaces, 4);
        dlatlong = bd_Latlong.doubleValue();
        return dlatlong;
    }

    private boolean cutPolygon(JSONArray coordinatesObjArr, JSONObject geometryObj, JSONObject geoJsonSourceObj, String name) throws Exception {
        JSONArray polygon = (JSONArray)coordinatesObjArr.get(0);
        JSONArray newPolygon = new JSONArray();
        JSONArray point = (JSONArray)polygon.get(0);
        if (this.inside(point)) {
            newPolygon.add((Object)point);
        }
        block5: for (int j = 1; j < polygon.size(); ++j) {
            JSONArray point1 = (JSONArray)polygon.get(j - 1);
            double longit1 = (Double)point1.get(0);
            double lat1 = (Double)point1.get(1);
            JSONArray point2 = (JSONArray)polygon.get(j);
            double longit2 = (Double)point2.get(0);
            double lat2 = (Double)point2.get(1);
            Line2D.Double line = new Line2D.Double(longit1, lat1, longit2, lat2);
            if (this.inside(point1) && this.inside(point2)) {
                newPolygon.add((Object)point2);
                continue;
            }
            JSONArray intersections = this.getIntersectionWithTheBoundingRegion(line);
            int nbIntersectionPoints = intersections.size();
            double intersectionX = 0.0;
            double intersectionY = 0.0;
            switch (nbIntersectionPoints) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    JSONArray corner;
                    JSONArray previousPoint;
                    JSONArray intersectionXY = new JSONArray();
                    JSONObject intersection = (JSONObject)intersections.get(0);
                    intersectionX = (Double)intersection.get((Object)"x");
                    intersectionY = (Double)intersection.get((Object)"y");
                    intersectionXY.add((Object)intersectionX);
                    intersectionXY.add((Object)intersectionY);
                    if (newPolygon.size() > 0 && this.isOnBorder(previousPoint = (JSONArray)newPolygon.get(newPolygon.size() - 1)) && (corner = this.addCorner(previousPoint, intersectionXY)).size() > 0) {
                        newPolygon.add((Object)corner);
                    }
                    newPolygon.add((Object)intersectionXY);
                    if (!this.inside(point2)) continue block5;
                    newPolygon.add((Object)point2);
                    continue block5;
                }
                case 2: {
                    JSONArray intersectionXY = new JSONArray();
                    JSONObject intersection = (JSONObject)intersections.get(0);
                    intersectionX = (Double)intersection.get((Object)"x");
                    intersectionY = (Double)intersection.get((Object)"y");
                    intersectionXY.add((Object)intersectionX);
                    intersectionXY.add((Object)intersectionY);
                    newPolygon.add((Object)intersectionXY);
                    intersectionXY = new JSONArray();
                    intersection = (JSONObject)intersections.get(1);
                    intersectionX = (Double)intersection.get((Object)"x");
                    intersectionY = (Double)intersection.get((Object)"y");
                    intersectionXY.add((Object)intersectionX);
                    intersectionXY.add((Object)intersectionY);
                    newPolygon.add((Object)intersectionXY);
                    continue block5;
                }
                default: {
                    throw new Exception("more than two intersection points");
                }
            }
        }
        polygon = newPolygon;
        coordinatesObjArr.clear();
        if (!newPolygon.isEmpty()) {
            JSONArray firstPoint = (JSONArray)newPolygon.get(0);
            JSONArray lastPoint = (JSONArray)newPolygon.get(newPolygon.size() - 1);
            if (!lastPoint.equals((Object)firstPoint)) {
                JSONArray corner = this.addCorner(firstPoint, lastPoint);
                if (corner.size() > 0) {
                    newPolygon.add((Object)corner);
                }
                newPolygon.add((Object)firstPoint);
            }
            coordinatesObjArr.add((Object)newPolygon);
            return true;
        }
        return false;
    }

    private boolean isOnBorder(JSONArray point) {
        return this.isOnTopBorder(point) || this.isOnBottomBorder(point) || this.isOnLeftBorder(point) || this.isOnRightBorder(point);
    }

    private boolean inside(JSONArray point) {
        Double x = (Double)point.get(0);
        Double y = (Double)point.get(1);
        return y >= this.latMin && y <= this.latMax && x >= this.longMin && x <= this.longMax;
    }

    JSONArray getIntersectionWithTheBoundingRegion(Line2D.Double line) {
        JSONObject anIntersection;
        JSONArray intersections = new JSONArray();
        Point2D.Double point = null;
        if (this.isOnBorder(line)) {
            return intersections;
        }
        if (line.intersectsLine(this.topBorder)) {
            anIntersection = new JSONObject();
            anIntersection.put((Object)"border", (Object)"top");
            point = this.getIntersection(line, this.topBorder);
            anIntersection.put((Object)"x", (Object)point.x);
            anIntersection.put((Object)"y", (Object)point.y);
            intersections.add((Object)anIntersection);
        }
        if (line.intersectsLine(this.bottomBorder)) {
            anIntersection = new JSONObject();
            anIntersection.put((Object)"border", (Object)"bottom");
            point = this.getIntersection(line, this.bottomBorder);
            anIntersection.put((Object)"x", (Object)point.x);
            anIntersection.put((Object)"y", (Object)point.y);
            intersections.add((Object)anIntersection);
        }
        if (line.intersectsLine(this.leftBorder)) {
            anIntersection = new JSONObject();
            anIntersection.put((Object)"border", (Object)"left");
            point = this.getIntersection(line, this.leftBorder);
            anIntersection.put((Object)"x", (Object)point.x);
            anIntersection.put((Object)"y", (Object)point.y);
            intersections.add((Object)anIntersection);
        }
        if (line.intersectsLine(this.rightBorder)) {
            anIntersection = new JSONObject();
            anIntersection.put((Object)"border", (Object)"right");
            point = this.getIntersection(line, this.rightBorder);
            anIntersection.put((Object)"x", (Object)point.x);
            anIntersection.put((Object)"y", (Object)point.y);
            intersections.add((Object)anIntersection);
        }
        return intersections;
    }

    private boolean isOnBorder(Line2D.Double line) {
        JSONArray point = new JSONArray();
        point.add((Object)line.getX1());
        point.add((Object)line.getY1());
        if (this.equals2digits(line.getX1(), line.getX2()) && (this.isOnLeftBorder(point) || this.isOnRightBorder(point))) {
            return true;
        }
        return this.equals2digits(line.getY1(), line.getY2()) && (this.isOnTopBorder(point) || this.isOnBottomBorder(point));
    }

    private boolean equals2digits(double x1, double x2) {
        int i1 = (int)(100.0 * x1);
        int i2 = (int)(100.0 * x2);
        return i1 == i2;
    }

    private JSONArray addCorner(JSONArray firstPoint, JSONArray lastPoint) {
        double firstX = (Double)firstPoint.get(0);
        double firstY = (Double)firstPoint.get(1);
        int x1 = (int)(100.0 * firstX);
        Double lastX = (Double)lastPoint.get(0);
        int x2 = (int)(100.0 * lastX);
        int y1 = (int)(100.0 * firstY);
        Double lastY = (Double)lastPoint.get(1);
        int y2 = (int)(100.0 * lastY);
        JSONArray corner = new JSONArray();
        if (x1 != x2 && y1 != y2) {
            if (this.isOnTopBorder(firstPoint)) {
                if (this.isOnLeftBorder(lastPoint)) {
                    corner.add((Object)this.longMin);
                } else if (this.isOnRightBorder(lastPoint)) {
                    corner.add((Object)this.longMax);
                }
                corner.add((Object)this.latMax);
            } else if (this.isOnBottomBorder(firstPoint)) {
                if (this.isOnLeftBorder(lastPoint)) {
                    corner.add((Object)this.longMin);
                } else if (this.isOnRightBorder(lastPoint)) {
                    corner.add((Object)this.longMax);
                }
                corner.add((Object)this.latMin);
            } else if (this.isOnLeftBorder(firstPoint)) {
                corner.add((Object)this.longMin);
                if (this.isOnTopBorder(lastPoint)) {
                    corner.add((Object)this.latMax);
                } else if (this.isOnBottomBorder(lastPoint)) {
                    corner.add((Object)this.latMin);
                }
            } else if (this.isOnRightBorder(firstPoint)) {
                corner.add((Object)this.longMax);
                if (this.isOnTopBorder(lastPoint)) {
                    corner.add((Object)this.latMax);
                } else if (this.isOnBottomBorder(lastPoint)) {
                    corner.add((Object)this.latMin);
                }
            }
        }
        return corner;
    }

    private Point2D.Double getIntersection(Line2D.Double line1, Line2D.Double line2) {
        double x1 = line1.getX1();
        double y1 = line1.getY1();
        double x2 = line1.getX2();
        double y2 = line1.getY2();
        double x3 = line2.getX1();
        double y3 = line2.getY1();
        double x4 = line2.getX2();
        double y4 = line2.getY2();
        double det = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (det == 0.0) {
            return null;
        }
        double x = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / det;
        double y = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / det;
        x = this.formatCoordinate(x);
        y = this.formatCoordinate(y);
        return new Point2D.Double(x, y);
    }

    private boolean isOnTopBorder(JSONArray point) {
        int intLat;
        double y = (Double)point.get(1);
        int intY = (int)(100.0 * y);
        return intY == (intLat = (int)(this.latMax * 100.0));
    }

    private boolean isOnBottomBorder(JSONArray point) {
        int intLat;
        double y = (Double)point.get(1);
        int intY = (int)(100.0 * y);
        return intY == (intLat = (int)(this.latMin * 100.0));
    }

    private boolean isOnLeftBorder(JSONArray point) {
        int intLong;
        double x = (Double)point.get(0);
        int intX = (int)(100.0 * x);
        return intX == (intLong = (int)(this.longMin * 100.0));
    }

    private boolean isOnRightBorder(JSONArray point) {
        int intLong;
        double x = (Double)point.get(0);
        int intX = (int)(100.0 * x);
        return intX == (intLong = (int)(this.longMax * 100.0));
    }
}

