/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.athena.smartermaps;

import com.ibm.athena.smartermaps.SmarterMaps;
import com.ibm.athena.smartermaps.model.AmbiguityHandler;
import com.ibm.athena.smartermaps.model.LocationEntry;
import com.ibm.athena.smartermaps.model.LocationIndexer;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class GroupsAndAliases {
    private static final LocationIndexer indexer = LocationIndexer.getInstance();
    private Map<String, List<Integer>> groups = new HashMap<String, List<Integer>>();

    public JSONObject addAliases(String path) {
        JSONObject errorsObject = new JSONObject();
        File file = new File(path);
        try {
            FileInputStream fis = new FileInputStream(file);
            return this.addAliases(fis);
        }
        catch (FileNotFoundException e) {
            errorsObject.put((Object)"errors", (Object)("file not found " + file.getAbsolutePath()));
            return errorsObject;
        }
    }

    public JSONObject addAliases(InputStream is) {
        BufferedReader bufferedReader = null;
        JSONObject errorsObject = new JSONObject();
        JSONArray errors = new JSONArray();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(is, "UTF8"));
            String line = bufferedReader.readLine();
            while (line != null && line.length() > 0) {
                StringTokenizer st = new StringTokenizer(line, ",");
                String name = (String)st.nextElement();
                name = name.trim().replace(";", ",");
                while (st.hasMoreElements()) {
                    String alias = st.nextToken();
                    JSONObject aliasResult = indexer.addAlias(name, alias.trim());
                    if (aliasResult.isEmpty()) continue;
                    errors.add((Object)aliasResult);
                }
                line = bufferedReader.readLine();
            }
            if (!errors.isEmpty()) {
                errorsObject.put((Object)"errors", (Object)errors);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            errors.add((Object)" Input Stream not found");
            errorsObject.put((Object)"errors", (Object)errors);
        }
        return errorsObject;
    }

    public JSONObject addGroups(String path, List<SmarterMaps.DisputedTerritories> dTerritories) {
        JSONObject errorsObject = new JSONObject();
        File file = new File(path);
        try {
            FileInputStream is = new FileInputStream(file);
            return this.addGroups(is, dTerritories);
        }
        catch (FileNotFoundException e) {
            errorsObject.put((Object)"errors", (Object)("file not found " + file.getAbsolutePath()));
            return errorsObject;
        }
    }

    public JSONObject addGroups(InputStream is, List<SmarterMaps.DisputedTerritories> dTerritories) {
        BufferedReader bufferedReader = null;
        JSONObject errorsObject = new JSONObject();
        JSONArray errors = new JSONArray();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(is, "UTF8"));
            String line = bufferedReader.readLine();
            while (line != null && line.length() > 0) {
                StringTokenizer st = new StringTokenizer(line, ",");
                String groupName = (String)st.nextElement();
                groupName = groupName.trim();
                ArrayList<String> groupElements = new ArrayList<String>();
                while (st.hasMoreElements()) {
                    String element = st.nextToken();
                    groupElements.add(element.trim());
                }
                this.addGroup(groupName, groupElements, dTerritories);
                List<Integer> groupIds = this.getGroupIds(groupName, groupElements, dTerritories);
                if (groupIds != null) {
                    this.groups.put(groupName, groupIds);
                }
                line = bufferedReader.readLine();
            }
            if (!errors.isEmpty()) {
                errorsObject.put((Object)"errors", (Object)errors);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorsObject;
    }

    public Map<String, List<Integer>> getGroups() {
        return this.groups;
    }

    public JSONObject addGroup(String groupName, List<String> groupElements, List<SmarterMaps.DisputedTerritories> dTerritories) {
        LocationEntry entry;
        int i;
        JSONObject errorsObject = new JSONObject();
        JSONArray errors = new JSONArray();
        if (groupElements.isEmpty()) {
            errors.add((Object)("No content for the group: " + groupName));
        } else if (groupElements.size() == 1) {
            errors.add((Object)("There should more than one element for the group: " + groupName));
        }
        if (!errors.isEmpty()) {
            errorsObject.put((Object)"errors", (Object)errors);
            return errorsObject;
        }
        StringBuffer err = new StringBuffer();
        for (int i2 = 0; i2 < groupElements.size(); ++i2) {
            String name = groupElements.get(i2);
            if (indexer.getLocationIds(name) != null) continue;
            if (err.length() == 0) {
                err.append("In group " + groupName + " Names not found ");
            }
            err.append(name + ",");
        }
        if (err.length() != 0) {
            errors.add((Object)err.toString());
        }
        if (!errors.isEmpty()) {
            errorsObject.put((Object)"errors", (Object)errors);
            return errorsObject;
        }
        AmbiguityHandler ambiguityHandler = new AmbiguityHandler();
        ambiguityHandler.setIndexer(indexer);
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        for (int i3 = 0; i3 < groupElements.size(); ++i3) {
            String name = groupElements.get(i3);
            groupIds.add(ambiguityHandler.disambiguate(name, "", groupElements, dTerritories));
        }
        int countryCount = 0;
        int provinceCount = 0;
        for (i = 0; i < groupIds.size(); ++i) {
            entry = indexer.getLocation((Integer)groupIds.get(i));
            if (entry.getType() == LocationEntry.Type.COUNTRY) {
                ++countryCount;
                continue;
            }
            if (entry.getType() != LocationEntry.Type.PROVINCE && entry.getType() != LocationEntry.Type.REGION) continue;
            ++provinceCount;
        }
        if (countryCount > groupIds.size() / 2) {
            err = new StringBuffer();
            for (i = 0; i < groupIds.size(); ++i) {
                entry = indexer.getLocation((Integer)groupIds.get(i));
                if (entry.getType() == LocationEntry.Type.COUNTRY) continue;
                if (err.length() == 0) {
                    err.append("In group " + groupName + " most elements are countries, except for : ");
                }
                err.append(entry.getName() + ",");
            }
            if (err.length() != 0) {
                errors.add((Object)err.toString());
            }
        } else if (provinceCount > groupIds.size() / 2) {
            err = new StringBuffer();
            String countryName = "";
            for (int i4 = 0; i4 < groupIds.size(); ++i4) {
                LocationEntry countryEntry;
                LocationEntry entry2 = indexer.getLocation((Integer)groupIds.get(i4));
                if (entry2.getType() != LocationEntry.Type.PROVINCE && entry2.getType() != LocationEntry.Type.REGION) {
                    if (err.length() == 0) {
                        err.append("In group " + groupName + " most elements are provinces, except for : ");
                    }
                    err.append(entry2.getName() + ",");
                }
                if ((countryEntry = indexer.getParentOfType(entry2, LocationEntry.Type.COUNTRY)) == null) continue;
                if (countryName.isEmpty()) {
                    countryName = countryEntry.getName();
                    continue;
                }
                if (countryName.equals(countryEntry.getName())) continue;
                err.append("The provinces must be in the same country");
                break;
            }
            if (err.length() != 0) {
                errors.add((Object)err.toString());
            }
        } else {
            errors.add((Object)("In group " + groupName + " elements should all be countries or provinces"));
        }
        if (!errors.isEmpty()) {
            errorsObject.put((Object)"errors", (Object)errors);
            return errorsObject;
        }
        this.groups.put(groupName, groupIds);
        return errorsObject;
    }

    private List<Integer> getGroupIds(String groupName, List<String> groupElements, List<SmarterMaps.DisputedTerritories> dTerritories) {
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        String name = "";
        if (!dTerritories.isEmpty()) {
            return null;
        }
        AmbiguityHandler ambiguityHandler = new AmbiguityHandler();
        ambiguityHandler.setIndexer(indexer);
        for (int i = 0; i < groupElements.size(); ++i) {
            name = groupElements.get(i);
            groupIds.add(ambiguityHandler.disambiguate(name, "", groupElements, dTerritories));
        }
        return groupIds;
    }
}

